/*
 * Decompiled with CFR 0.152.
 */
package jade.core.management;

import jade.core.AID;
import jade.core.Command;
import jade.core.ContainerID;
import jade.core.GenericCommand;
import jade.core.IMTPException;
import jade.core.NameClashException;
import jade.core.Node;
import jade.core.NotFoundException;
import jade.core.ServiceException;
import jade.core.SliceProxy;
import jade.core.management.AgentManagementSlice;
import jade.security.Credentials;
import jade.security.JADEPrincipal;
import jade.security.JADESecurityException;

public class AgentManagementProxy
extends SliceProxy
implements AgentManagementSlice {
    @Override
    public void createAgent(AID agentID, String className, Object[] arguments, JADEPrincipal owner, Credentials initialCredentials, boolean startIt, Command sourceCmd) throws IMTPException, NotFoundException, NameClashException, JADESecurityException {
        try {
            GenericCommand cmd = new GenericCommand("1", "jade.core.management.AgentManagement", null);
            cmd.addParam(agentID);
            cmd.addParam(className);
            cmd.addParam(arguments);
            cmd.addParam(owner);
            cmd.addParam(initialCredentials);
            cmd.addParam(new Boolean(startIt));
            cmd.setPrincipal(sourceCmd.getPrincipal());
            cmd.setCredentials(sourceCmd.getCredentials());
            Node n = this.getNode();
            Object result = n.accept(cmd);
            if (result != null && result instanceof Throwable) {
                if (result instanceof IMTPException) {
                    throw (IMTPException)result;
                }
                if (result instanceof NotFoundException) {
                    throw (NotFoundException)result;
                }
                if (result instanceof NameClashException) {
                    throw (NameClashException)result;
                }
                if (result instanceof JADESecurityException) {
                    throw (JADESecurityException)result;
                }
                throw new IMTPException("An undeclared exception was thrown", (Throwable)result);
            }
        }
        catch (ServiceException se) {
            throw new IMTPException("Unable to access remote node", se);
        }
    }

    @Override
    public void killAgent(AID agentID, Command sourceCmd) throws IMTPException, NotFoundException {
        try {
            GenericCommand cmd = new GenericCommand("2", "jade.core.management.AgentManagement", null);
            cmd.addParam(agentID);
            cmd.setPrincipal(sourceCmd.getPrincipal());
            cmd.setCredentials(sourceCmd.getCredentials());
            Node n = this.getNode();
            Object result = n.accept(cmd);
            if (result != null && result instanceof Throwable) {
                if (result instanceof IMTPException) {
                    throw (IMTPException)result;
                }
                if (result instanceof NotFoundException) {
                    throw (NotFoundException)result;
                }
                throw new IMTPException("An undeclared exception was thrown", (Throwable)result);
            }
        }
        catch (ServiceException se) {
            throw new IMTPException("Unable to access remote node", se);
        }
    }

    @Override
    public void changeAgentState(AID agentID, int newState) throws IMTPException, NotFoundException {
        try {
            GenericCommand cmd = new GenericCommand("3", "jade.core.management.AgentManagement", null);
            cmd.addParam(agentID);
            cmd.addParam(new Integer(newState));
            Node n = this.getNode();
            Object result = n.accept(cmd);
            if (result != null && result instanceof Throwable) {
                if (result instanceof IMTPException) {
                    throw (IMTPException)result;
                }
                if (result instanceof NotFoundException) {
                    throw (NotFoundException)result;
                }
                throw new IMTPException("An undeclared exception was thrown", (Throwable)result);
            }
        }
        catch (ServiceException se) {
            throw new IMTPException("Unable to access remote node", se);
        }
    }

    @Override
    public void bornAgent(AID name, ContainerID cid, Command sourceCmd) throws IMTPException, NameClashException, NotFoundException, JADESecurityException {
        try {
            GenericCommand cmd = new GenericCommand("4", "jade.core.management.AgentManagement", null);
            cmd.addParam(name);
            cmd.addParam(cid);
            cmd.setPrincipal(sourceCmd.getPrincipal());
            cmd.setCredentials(sourceCmd.getCredentials());
            Node n = this.getNode();
            Object result = n.accept(cmd);
            if (result != null && result instanceof Throwable) {
                if (result instanceof IMTPException) {
                    throw (IMTPException)result;
                }
                if (result instanceof NotFoundException) {
                    throw (NotFoundException)result;
                }
                if (result instanceof NameClashException) {
                    throw (NameClashException)result;
                }
                if (result instanceof JADESecurityException) {
                    throw (JADESecurityException)result;
                }
                throw new IMTPException("An undeclared exception was thrown", (Throwable)result);
            }
        }
        catch (ServiceException se) {
            throw new IMTPException("Unable to access remote node", se);
        }
    }

    @Override
    public void deadAgent(AID name, Command sourceCmd) throws IMTPException, NotFoundException {
        try {
            GenericCommand cmd = new GenericCommand("5", "jade.core.management.AgentManagement", null);
            cmd.addParam(name);
            cmd.setPrincipal(sourceCmd.getPrincipal());
            cmd.setCredentials(sourceCmd.getCredentials());
            Node n = this.getNode();
            Object result = n.accept(cmd);
            if (result != null && result instanceof Throwable) {
                if (result instanceof IMTPException) {
                    throw (IMTPException)result;
                }
                if (result instanceof NotFoundException) {
                    throw (NotFoundException)result;
                }
                throw new IMTPException("An undeclared exception was thrown", (Throwable)result);
            }
        }
        catch (ServiceException se) {
            throw new IMTPException("Unable to access remote node", se);
        }
    }

    @Override
    public void suspendedAgent(AID name) throws IMTPException, NotFoundException {
        try {
            GenericCommand cmd = new GenericCommand("6", "jade.core.management.AgentManagement", null);
            cmd.addParam(name);
            Node n = this.getNode();
            Object result = n.accept(cmd);
            if (result != null && result instanceof Throwable) {
                if (result instanceof IMTPException) {
                    throw (IMTPException)result;
                }
                if (result instanceof NotFoundException) {
                    throw (NotFoundException)result;
                }
                throw new IMTPException("An undeclared exception was thrown", (Throwable)result);
            }
        }
        catch (ServiceException se) {
            throw new IMTPException("Unable to access remote node", se);
        }
    }

    @Override
    public void resumedAgent(AID name) throws IMTPException, NotFoundException {
        try {
            GenericCommand cmd = new GenericCommand("7", "jade.core.management.AgentManagement", null);
            cmd.addParam(name);
            Node n = this.getNode();
            Object result = n.accept(cmd);
            if (result != null && result instanceof Throwable) {
                if (result instanceof IMTPException) {
                    throw (IMTPException)result;
                }
                if (result instanceof NotFoundException) {
                    throw (NotFoundException)result;
                }
                throw new IMTPException("An undeclared exception was thrown", (Throwable)result);
            }
        }
        catch (ServiceException se) {
            throw new IMTPException("Unable to access remote node", se);
        }
    }

    @Override
    public void exitContainer() throws IMTPException, NotFoundException {
        try {
            GenericCommand cmd = new GenericCommand("8", "jade.core.management.AgentManagement", null);
            Node n = this.getNode();
            Object result = n.accept(cmd);
            if (result != null && result instanceof Throwable) {
                if (result instanceof IMTPException) {
                    throw (IMTPException)result;
                }
                if (result instanceof NotFoundException) {
                    throw (NotFoundException)result;
                }
                throw new IMTPException("An undeclared exception was thrown", (Throwable)result);
            }
        }
        catch (ServiceException se) {
            throw new IMTPException("Unable to access remote node", se);
        }
    }
}

