/*
 * Decompiled with CFR 0.152.
 */
package jade.core.replication;

import jade.core.AID;
import jade.core.ContainerID;
import jade.core.GenericCommand;
import jade.core.IMTPException;
import jade.core.Location;
import jade.core.Node;
import jade.core.NotFoundException;
import jade.core.ServiceException;
import jade.core.SliceProxy;
import jade.core.replication.AgentReplicationSlice;
import jade.core.replication.GlobalReplicationInfo;

public class AgentReplicationProxy
extends SliceProxy
implements AgentReplicationSlice {
    @Override
    public void invokeAgentMethod(AID aid, String methodName, Object[] arguments) throws IMTPException, ServiceException, NotFoundException {
        GenericCommand cmd = new GenericCommand("I", "jade.core.replication.AgentReplication", null);
        cmd.addParam(aid);
        cmd.addParam(methodName);
        cmd.addParam(arguments);
        Node n = this.getNode();
        Object result = n.accept(cmd);
        if (result != null && result instanceof Throwable) {
            if (result instanceof NotFoundException) {
                throw (NotFoundException)result;
            }
            if (result instanceof ServiceException) {
                throw (ServiceException)result;
            }
            if (result instanceof IMTPException) {
                throw (IMTPException)result;
            }
            throw new IMTPException("An undeclared exception was thrown", (Throwable)result);
        }
    }

    @Override
    public ContainerID getAgentLocation(AID aid) throws IMTPException, NotFoundException {
        GenericCommand cmd = new GenericCommand("G", "jade.core.replication.AgentReplication", null);
        cmd.addParam(aid);
        try {
            Node n = this.getNode();
            Object result = n.accept(cmd);
            if (result != null && result instanceof Throwable) {
                if (result instanceof NotFoundException) {
                    throw (NotFoundException)result;
                }
                if (result instanceof IMTPException) {
                    throw (IMTPException)result;
                }
                throw new IMTPException("An undeclared exception was thrown", (Throwable)result);
            }
            return (ContainerID)result;
        }
        catch (ServiceException se) {
            throw new IMTPException("Error accessing remote node", se);
        }
    }

    @Override
    public void replicaCreationRequested(AID virtualAid, AID replicaAid) throws IMTPException {
        GenericCommand cmd = new GenericCommand("R", "jade.core.replication.AgentReplication", null);
        cmd.addParam(virtualAid);
        cmd.addParam(replicaAid);
        try {
            Node n = this.getNode();
            Object result = n.accept(cmd);
            if (result != null && result instanceof Throwable) {
                if (result instanceof IMTPException) {
                    throw (IMTPException)result;
                }
                throw new IMTPException("An undeclared exception was thrown", (Throwable)result);
            }
        }
        catch (ServiceException se) {
            throw new IMTPException("Error accessing remote node", se);
        }
    }

    @Override
    public void synchReplication(GlobalReplicationInfo info) throws IMTPException {
        GenericCommand cmd = new GenericCommand("S", "jade.core.replication.AgentReplication", null);
        cmd.addParam(info.getVirtual());
        cmd.addParam(info.getMaster());
        cmd.addParam(info.getReplicationMode());
        cmd.addParam(info.getAllReplicas());
        try {
            Node n = this.getNode();
            Object result = n.accept(cmd);
            if (result != null && result instanceof Throwable) {
                if (result instanceof IMTPException) {
                    throw (IMTPException)result;
                }
                throw new IMTPException("An undeclared exception was thrown", (Throwable)result);
            }
        }
        catch (ServiceException se) {
            throw new IMTPException("Error accessing remote node", se);
        }
    }

    @Override
    public void notifyBecomeMaster(AID masterAid) throws IMTPException {
        GenericCommand cmd = new GenericCommand("NB", "jade.core.replication.AgentReplication", null);
        cmd.addParam(masterAid);
        try {
            Node n = this.getNode();
            Object result = n.accept(cmd);
            if (result != null && result instanceof Throwable) {
                if (result instanceof IMTPException) {
                    throw (IMTPException)result;
                }
                throw new IMTPException("An undeclared exception was thrown", (Throwable)result);
            }
        }
        catch (ServiceException se) {
            throw new IMTPException("Error accessing remote node", se);
        }
    }

    @Override
    public void notifyReplicaRemoved(AID masterAid, AID removedReplica, Location where) throws IMTPException {
        GenericCommand cmd = new GenericCommand("NR", "jade.core.replication.AgentReplication", null);
        cmd.addParam(masterAid);
        cmd.addParam(removedReplica);
        cmd.addParam(where);
        try {
            Node n = this.getNode();
            Object result = n.accept(cmd);
            if (result != null && result instanceof Throwable) {
                if (result instanceof IMTPException) {
                    throw (IMTPException)result;
                }
                throw new IMTPException("An undeclared exception was thrown", (Throwable)result);
            }
        }
        catch (ServiceException se) {
            throw new IMTPException("Error accessing remote node", se);
        }
    }
}

