/*
 * Decompiled with CFR 0.152.
 */
package jade.core.replication;

import jade.core.AID;
import jade.util.Logger;
import jade.util.leap.RoundList;
import java.io.Serializable;

class GlobalReplicationInfo
implements Serializable {
    private AID virtualAid;
    private AID masterAid;
    private int replicationMode;
    private RoundList allReplicas = new RoundList();
    private Logger myLogger = Logger.getJADELogger(this.getClass().getName());

    GlobalReplicationInfo(AID virtual, AID master, int replicationMode) {
        this.virtualAid = virtual;
        this.masterAid = master;
        this.replicationMode = replicationMode;
        this.allReplicas.add(master);
    }

    AID getVirtual() {
        return this.virtualAid;
    }

    AID getMaster() {
        return this.masterAid;
    }

    int getReplicationMode() {
        return this.replicationMode;
    }

    synchronized void addReplica(AID replicaAid) {
        if (!this.allReplicas.contains(replicaAid)) {
            this.myLogger.log(Logger.CONFIG, "Adding replica " + replicaAid.getLocalName() + " to global replication information of virtual agent " + this.virtualAid.getLocalName());
            this.allReplicas.add(replicaAid);
        }
    }

    synchronized void removeReplica(AID replicaAid) {
        if (this.allReplicas.remove(replicaAid)) {
            this.myLogger.log(Logger.CONFIG, "Removing replica " + replicaAid.getLocalName() + " from global replication information of virtual agent " + this.virtualAid.getLocalName());
        }
    }

    synchronized AID getReplica() {
        if (this.replicationMode == 1) {
            return (AID)this.allReplicas.get();
        }
        return this.masterAid;
    }

    synchronized AID[] getAllReplicas() {
        Object[] oo = this.allReplicas.toArray();
        AID[] aids = new AID[oo.length];
        for (int i = 0; i < oo.length; ++i) {
            aids[i] = (AID)oo[i];
        }
        return aids;
    }

    synchronized AID masterReplicaDead() {
        this.removeReplica(this.masterAid);
        if (this.allReplicas.size() == 0) {
            this.masterAid = null;
        } else {
            this.masterAid = (AID)this.allReplicas.get();
            this.myLogger.log(Logger.INFO, "New master replica " + this.masterAid.getLocalName() + " selected for virtual agent " + this.virtualAid.getLocalName());
        }
        return this.masterAid;
    }

    synchronized void masterReplicaChanged(AID newMasterAid) {
        this.removeReplica(this.masterAid);
        this.masterAid = newMasterAid;
        this.myLogger.log(Logger.INFO, "New master replica " + this.masterAid.getLocalName() + " set for virtual agent " + this.virtualAid.getLocalName());
    }
}

