/*
 * Decompiled with CFR 0.152.
 */
package jade.domain.JADEAgentManagement;

import jade.content.onto.BCReflectiveIntrospector;
import jade.content.onto.Introspector;
import jade.content.onto.Ontology;
import jade.content.onto.OntologyException;
import jade.content.onto.SerializableOntology;
import jade.content.schema.AgentActionSchema;
import jade.content.schema.ConceptSchema;
import jade.content.schema.PredicateSchema;
import jade.content.schema.PrimitiveSchema;
import jade.content.schema.TermSchema;
import jade.core.ContainerID;
import jade.core.PlatformID;
import jade.domain.FIPAAgentManagement.AlreadyRegistered;
import jade.domain.FIPAAgentManagement.ExceptionOntology;
import jade.domain.FIPAAgentManagement.NotRegistered;
import jade.domain.JADEAgentManagement.CreateAgent;
import jade.domain.JADEAgentManagement.DebugOff;
import jade.domain.JADEAgentManagement.DebugOn;
import jade.domain.JADEAgentManagement.InstallMTP;
import jade.domain.JADEAgentManagement.JADEManagementVocabulary;
import jade.domain.JADEAgentManagement.KillAgent;
import jade.domain.JADEAgentManagement.KillContainer;
import jade.domain.JADEAgentManagement.QueryAgentsOnLocation;
import jade.domain.JADEAgentManagement.QueryPlatformLocationsAction;
import jade.domain.JADEAgentManagement.ShowGui;
import jade.domain.JADEAgentManagement.ShutdownPlatform;
import jade.domain.JADEAgentManagement.SniffOff;
import jade.domain.JADEAgentManagement.SniffOn;
import jade.domain.JADEAgentManagement.UninstallMTP;
import jade.domain.JADEAgentManagement.WhereIsAgentAction;

public class JADEManagementOntology
extends Ontology
implements JADEManagementVocabulary {
    private static final String[] WILDCARDS = new String[]{"%C", "%A"};
    private static Ontology theInstance = new JADEManagementOntology();

    public static Ontology getInstance() {
        return theInstance;
    }

    private JADEManagementOntology() {
        super("JADE-Agent-Management", new Ontology[]{ExceptionOntology.getInstance(), SerializableOntology.getInstance()}, (Introspector)new BCReflectiveIntrospector());
        try {
            this.add(new ConceptSchema("location"));
            this.add(new ConceptSchema("container-ID"), ContainerID.class);
            this.add(new ConceptSchema("platform-ID"), PlatformID.class);
            this.add(new AgentActionSchema("shutdown-platform"), ShutdownPlatform.class);
            this.add(new AgentActionSchema("kill-container"), KillContainer.class);
            this.add(new AgentActionSchema("create-agent"), CreateAgent.class);
            this.add(new AgentActionSchema("kill-agent"), KillAgent.class);
            this.add(new AgentActionSchema("install-mtp"), InstallMTP.class);
            this.add(new AgentActionSchema("uninstall-mtp"), UninstallMTP.class);
            this.add(new AgentActionSchema("sniff-on"), SniffOn.class);
            this.add(new AgentActionSchema("sniff-off"), SniffOff.class);
            this.add(new AgentActionSchema("debug-on"), DebugOn.class);
            this.add(new AgentActionSchema("debug-off"), DebugOff.class);
            this.add(new AgentActionSchema("showgui"), ShowGui.class);
            this.add(new AgentActionSchema("where-is-agent"), WhereIsAgentAction.class);
            this.add(new AgentActionSchema("query-agents-on-location"), QueryAgentsOnLocation.class);
            this.add(new AgentActionSchema("query-platform-locations"), QueryPlatformLocationsAction.class);
            this.add(new PredicateSchema("already-registered"), AlreadyRegistered.class);
            this.add(new PredicateSchema("not-registered"), NotRegistered.class);
            ConceptSchema cs = (ConceptSchema)this.getSchema("location");
            cs.add("name", (PrimitiveSchema)this.getSchema("BO_String"));
            cs.add("protocol", (PrimitiveSchema)this.getSchema("BO_String"), 1);
            cs.add("address", (PrimitiveSchema)this.getSchema("BO_String"), 1);
            cs = (ConceptSchema)this.getSchema("container-ID");
            cs.addSuperSchema((ConceptSchema)this.getSchema("location"));
            cs.add("main", (PrimitiveSchema)this.getSchema("BO_Boolean"), 1);
            cs.add("port", (PrimitiveSchema)this.getSchema("BO_String"), 1);
            cs.add("protocol", (PrimitiveSchema)this.getSchema("BO_String"), 1);
            cs = (ConceptSchema)this.getSchema("platform-ID");
            cs.addSuperSchema((ConceptSchema)this.getSchema("location"));
            AgentActionSchema as = (AgentActionSchema)this.getSchema("shutdown-platform");
            as = (AgentActionSchema)this.getSchema("kill-container");
            as.add("container", (ConceptSchema)this.getSchema("container-ID"));
            as.add("password", (PrimitiveSchema)this.getSchema("BO_String"), 1);
            as = (AgentActionSchema)this.getSchema("create-agent");
            as.add("agent-name", (PrimitiveSchema)this.getSchema("BO_String"));
            as.add("class-name", (PrimitiveSchema)this.getSchema("BO_String"));
            as.add("arguments", (TermSchema)TermSchema.getBaseSchema(), 0, -1);
            as.add("container", (ConceptSchema)this.getSchema("container-ID"));
            as.add("owner", (TermSchema)TermSchema.getBaseSchema(), 1);
            as.add("initial-credentials", (TermSchema)TermSchema.getBaseSchema(), 1);
            as = (AgentActionSchema)this.getSchema("kill-agent");
            as.add("agent", (ConceptSchema)this.getSchema("agent-identifier"));
            as.add("password", (PrimitiveSchema)this.getSchema("BO_String"), 1);
            as = (AgentActionSchema)this.getSchema("install-mtp");
            as.add("address", (PrimitiveSchema)this.getSchema("BO_String"), 1);
            as.add("container", (ConceptSchema)this.getSchema("container-ID"));
            as.add("class-name", (PrimitiveSchema)this.getSchema("BO_String"));
            as = (AgentActionSchema)this.getSchema("uninstall-mtp");
            as.add("address", (PrimitiveSchema)this.getSchema("BO_String"));
            as.add("container", (ConceptSchema)this.getSchema("container-ID"));
            as = (AgentActionSchema)this.getSchema("sniff-on");
            as.add("sniffer", (ConceptSchema)this.getSchema("agent-identifier"));
            as.add("sniffed-agents", (ConceptSchema)this.getSchema("agent-identifier"), 1, -1);
            as.add("password", (PrimitiveSchema)this.getSchema("BO_String"), 1);
            as = (AgentActionSchema)this.getSchema("sniff-off");
            as.add("sniffer", (ConceptSchema)this.getSchema("agent-identifier"));
            as.add("sniffed-agents", (ConceptSchema)this.getSchema("agent-identifier"), 1, -1);
            as.add("password", (PrimitiveSchema)this.getSchema("BO_String"), 1);
            as = (AgentActionSchema)this.getSchema("debug-on");
            as.add("debugger", (ConceptSchema)this.getSchema("agent-identifier"));
            as.add("debugged-agents", (ConceptSchema)this.getSchema("agent-identifier"), 1, -1);
            as.add("password", (PrimitiveSchema)this.getSchema("BO_String"), 1);
            as = (AgentActionSchema)this.getSchema("debug-off");
            as.add("debugger", (ConceptSchema)this.getSchema("agent-identifier"));
            as.add("debugged-agents", (ConceptSchema)this.getSchema("agent-identifier"), 1, -1);
            as.add("password", (PrimitiveSchema)this.getSchema("BO_String"), 1);
            as = (AgentActionSchema)this.getSchema("where-is-agent");
            as.add("agent-identifier", (ConceptSchema)this.getSchema("agent-identifier"));
            as = (AgentActionSchema)this.getSchema("query-agents-on-location");
            as.add("location", (ConceptSchema)this.getSchema("location"));
        }
        catch (OntologyException oe) {
            oe.printStackTrace();
        }
    }

    public static String adjustAgentName(String nameWithWildcards, String[] values) {
        if (values == null) {
            return nameWithWildcards;
        }
        StringBuffer out = new StringBuffer(nameWithWildcards);
        int wL = WILDCARDS.length;
        int vL = values.length;
        int minLength = Math.min(wL, vL);
        for (int i = 0; i < minLength; ++i) {
            int index = out.indexOf(WILDCARDS[i]);
            if (index < 0) continue;
            while (index >= 0) {
                out = out.replace(index, index + WILDCARDS[i].length(), values[i]);
                index = out.indexOf(WILDCARDS[i]);
            }
        }
        return out.toString();
    }
}

