/*
 * Decompiled with CFR 0.152.
 */
package jade.domain.introspection;

import jade.content.Concept;
import jade.content.ContentManager;
import jade.content.lang.Codec;
import jade.content.lang.sl.SLCodec;
import jade.content.onto.Ontology;
import jade.content.onto.OntologyException;
import jade.content.onto.basic.Action;
import jade.content.onto.basic.Result;
import jade.core.Agent;
import jade.core.behaviours.CyclicBehaviour;
import jade.domain.introspection.GetKeys;
import jade.domain.introspection.GetValue;
import jade.domain.introspection.IntrospectionOntology;
import jade.lang.acl.ACLMessage;
import jade.lang.acl.MessageTemplate;
import jade.util.leap.ArrayList;
import java.lang.reflect.Method;

public class IntrospectionServer
extends CyclicBehaviour {
    private Codec codec;
    private Ontology onto;
    private MessageTemplate template;
    private static Class serializableClass;

    public IntrospectionServer(Agent a) {
        super(a);
    }

    @Override
    public void onStart() {
        ContentManager cm = this.myAgent.getContentManager();
        this.onto = IntrospectionOntology.getInstance();
        cm.registerOntology(this.onto);
        this.codec = cm.lookupLanguage("fipa-sl");
        if (this.codec == null) {
            this.codec = cm.lookupLanguage("fipa-sl2");
            if (this.codec == null) {
                this.codec = cm.lookupLanguage("fipa-sl1");
                if (this.codec == null) {
                    this.codec = cm.lookupLanguage("fipa-sl0");
                }
            }
        }
        if (this.codec == null) {
            this.codec = new SLCodec();
            cm.registerLanguage(this.codec);
        }
        this.template = MessageTemplate.and(MessageTemplate.MatchOntology(this.onto.getName()), MessageTemplate.MatchPerformative(16));
    }

    @Override
    public void action() {
        block9: {
            ACLMessage request = this.myAgent.receive(this.template);
            if (request != null) {
                try {
                    ContentManager cm = this.myAgent.getContentManager();
                    Action actionExpr = (Action)cm.extractContent(request);
                    Concept act = actionExpr.getAction();
                    if (act instanceof GetKeys) {
                        this.serveGetKeys(request, actionExpr, (GetKeys)act);
                        break block9;
                    }
                    if (act instanceof GetValue) {
                        this.serveGetValue(request, actionExpr, (GetValue)act);
                        break block9;
                    }
                    this.serveUnknownAction(request, actionExpr, act);
                }
                catch (OntologyException oe) {
                    this.reply(request, 10);
                    oe.printStackTrace();
                }
                catch (Codec.CodecException ce) {
                    this.reply(request, 10);
                    ce.printStackTrace();
                }
                catch (ValueEncodingException vee) {
                    ACLMessage msg = request.createReply();
                    msg.setPerformative(6);
                    msg.setContent("VALUE_NOT_ENCODABLE");
                    this.myAgent.send(msg);
                }
                catch (Throwable t) {
                    this.reply(request, 6);
                    t.printStackTrace();
                }
            } else {
                this.block();
            }
        }
    }

    protected void reply(ACLMessage request, int performative) {
        ACLMessage msg = request.createReply();
        msg.setPerformative(performative);
        this.myAgent.send(msg);
    }

    protected void serveGetKeys(ACLMessage request, Action aExpr, GetKeys action) throws Exception {
        ArrayList keys = new ArrayList();
        Method[] mm = this.myAgent.getClass().getMethods();
        for (int i = 0; i < mm.length; ++i) {
            Class<?> retType;
            Method method = mm[i];
            if (!method.getName().startsWith("get") || method.getParameterTypes().length != 0 || !(retType = method.getReturnType()).isPrimitive() && (serializableClass == null || !serializableClass.isAssignableFrom(retType))) continue;
            String key = method.getName().substring(3);
            keys.add(key);
        }
        Result r = new Result(aExpr, keys);
        ACLMessage reply = request.createReply();
        this.myAgent.getContentManager().fillContent(reply, r);
        reply.setPerformative(7);
        this.myAgent.send(reply);
    }

    protected void serveGetValue(ACLMessage request, Action aExpr, GetValue action) throws Exception {
        Method method = this.myAgent.getClass().getMethod("get" + action.getKey(), new Class[0]);
        Object value = method.invoke((Object)this.myAgent, (Object[])null);
        if (value == null) {
            value = "null";
        }
        Result r = new Result(aExpr, value);
        ACLMessage reply = request.createReply();
        try {
            this.myAgent.getContentManager().fillContent(reply, r);
            reply.setPerformative(7);
            this.myAgent.send(reply);
        }
        catch (OntologyException oe) {
            throw new ValueEncodingException();
        }
        catch (Codec.CodecException ce) {
            throw new ValueEncodingException();
        }
    }

    protected void serveUnknownAction(ACLMessage request, Action aExpr, Object action) {
        this.reply(request, 14);
    }

    static {
        try {
            serializableClass = Class.forName("java.io.Serializable");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private class ValueEncodingException
    extends Exception {
        private ValueEncodingException() {
        }
    }
}

