/*
 * Decompiled with CFR 0.152.
 */
package jade.gui;

import jade.core.AID;
import jade.gui.VisualAIDList;
import jade.gui.VisualPropertiesList;
import jade.gui.VisualStringList;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class AIDGui
extends JDialog {
    private boolean editable;
    private boolean checkSlots;
    private AID agentAID;
    private JTextField nameText;
    private JCheckBox isLocalName;
    private VisualStringList addressListPanel;
    private VisualAIDList resolverListPanel;
    private VisualPropertiesList propertiesListPanel;
    private AID out;
    private Component parentGUI;

    public AIDGui(Component owner) {
        this.setTitle("AID");
        this.parentGUI = owner;
    }

    private Component getChildrenOwner() {
        return this.parentGUI != null ? this.parentGUI : this;
    }

    public AID ShowAIDGui(AID agentIdentifier, boolean ed, boolean checkMandatorySlots) {
        this.out = null;
        this.editable = ed;
        this.checkSlots = checkMandatorySlots;
        this.agentAID = agentIdentifier == null ? new AID() : agentIdentifier;
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        JPanel namePanel = new JPanel();
        namePanel.setLayout(new BoxLayout(namePanel, 0));
        JLabel label = new JLabel("NAME");
        label.setPreferredSize(new Dimension(80, 26));
        label.setMinimumSize(new Dimension(80, 26));
        label.setMaximumSize(new Dimension(80, 26));
        namePanel.add(label);
        this.isLocalName = new JCheckBox();
        this.isLocalName.setVisible(ed);
        this.isLocalName.setToolTipText("Select if the name is not a GUID.");
        namePanel.add(this.isLocalName);
        this.nameText = new JTextField();
        this.nameText.setBackground(Color.white);
        this.nameText.setText(this.agentAID.getName());
        this.nameText.setPreferredSize(new Dimension(125, 26));
        this.nameText.setMinimumSize(new Dimension(125, 26));
        this.nameText.setMaximumSize(new Dimension(125, 26));
        this.nameText.setEditable(this.editable);
        namePanel.add(this.nameText);
        mainPanel.add(namePanel);
        JPanel addressesPanel = new JPanel();
        addressesPanel.setLayout(new BorderLayout());
        addressesPanel.setBorder(BorderFactory.createTitledBorder("Addresses"));
        this.addressListPanel = new VisualStringList(this.agentAID.getAllAddresses(), this.getChildrenOwner());
        this.addressListPanel.setDimension(new Dimension(200, 40));
        this.addressListPanel.setEnabled(this.editable);
        addressesPanel.add(this.addressListPanel);
        mainPanel.add(addressesPanel);
        JPanel resolversPanel = new JPanel();
        resolversPanel.setLayout(new BorderLayout());
        resolversPanel.setBorder(BorderFactory.createTitledBorder("Resolvers"));
        this.resolverListPanel = new VisualAIDList(this.agentAID.getAllResolvers(), this.getChildrenOwner());
        this.resolverListPanel.setDimension(new Dimension(200, 40));
        this.resolverListPanel.setEnabled(this.editable);
        this.resolverListPanel.setCheckMandatorySlots(checkMandatorySlots);
        resolversPanel.add(this.resolverListPanel);
        mainPanel.add(resolversPanel);
        JPanel propertiesPanel = new JPanel();
        propertiesPanel.setLayout(new BorderLayout());
        propertiesPanel.setBorder(BorderFactory.createTitledBorder("Properties"));
        this.propertiesListPanel = new VisualPropertiesList(this.agentAID.getAllUserDefinedSlot(), this.getChildrenOwner());
        this.propertiesListPanel.setDimension(new Dimension(200, 40));
        this.propertiesListPanel.setEnabled(this.editable);
        propertiesPanel.add(this.propertiesListPanel);
        mainPanel.add(propertiesPanel);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 0));
        JButton okButton = new JButton("OK");
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String param = e.getActionCommand();
                if (param.equals("OK")) {
                    if (AIDGui.this.editable) {
                        String name = AIDGui.this.nameText.getText().trim();
                        if (AIDGui.this.checkSlots && name.length() == 0) {
                            JOptionPane.showMessageDialog(AIDGui.this, "AID must have a non-empty name.", "Error Message", 0);
                            return;
                        }
                        AIDGui.this.out = new AID();
                        if (AIDGui.this.isLocalName.isSelected()) {
                            AIDGui.this.out.setLocalName(name);
                        } else {
                            AIDGui.this.out.setName(name);
                        }
                        Enumeration addresses = AIDGui.this.addressListPanel.getContent();
                        while (addresses.hasMoreElements()) {
                            AIDGui.this.out.addAddresses((String)addresses.nextElement());
                        }
                        Enumeration resolvers = AIDGui.this.resolverListPanel.getContent();
                        while (resolvers.hasMoreElements()) {
                            AIDGui.this.out.addResolvers((AID)resolvers.nextElement());
                        }
                        Properties new_prop = AIDGui.this.propertiesListPanel.getContentProperties();
                        Enumeration<?> key_en = new_prop.propertyNames();
                        while (key_en.hasMoreElements()) {
                            String key = (String)key_en.nextElement();
                            AIDGui.this.out.addUserDefinedSlot(key, new_prop.getProperty(key));
                        }
                    } else {
                        AIDGui.this.out = AIDGui.this.agentAID;
                    }
                    AIDGui.this.dispose();
                }
            }
        });
        buttonPanel.add(okButton);
        if (this.editable) {
            JButton cancelButton = new JButton("Cancel");
            cancelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String param = e.getActionCommand();
                    if (param.equals("Cancel")) {
                        AIDGui.this.out = null;
                        AIDGui.this.dispose();
                    }
                }
            });
            buttonPanel.add(cancelButton);
        }
        mainPanel.add(buttonPanel);
        this.getContentPane().add((Component)mainPanel, "Center");
        this.setResizable(false);
        this.setModal(true);
        this.ShowCorrect();
        return this.out;
    }

    private void ShowCorrect() {
        this.pack();
        if (this.parentGUI != null) {
            this.setLocation(this.parentGUI.getX() + (this.parentGUI.getWidth() - this.getWidth()) / 2, this.parentGUI.getY() + (this.parentGUI.getHeight() - this.getHeight()) / 2);
        }
        this.setVisible(true);
        this.toFront();
    }
}

