/*
 * Decompiled with CFR 0.152.
 */
package jade.imtp.leap;

import jade.core.IMTPException;
import jade.core.Node;
import jade.core.PlatformManager;
import jade.core.Profile;
import jade.core.UnreachableException;
import jade.imtp.leap.Command;
import jade.imtp.leap.DeliverableDataInputStream;
import jade.imtp.leap.DeliverableDataOutputStream;
import jade.imtp.leap.DispatcherException;
import jade.imtp.leap.ICP;
import jade.imtp.leap.ICPException;
import jade.imtp.leap.LEAPSerializationException;
import jade.imtp.leap.NodeStub;
import jade.imtp.leap.PlatformManagerStub;
import jade.imtp.leap.Skeleton;
import jade.imtp.leap.Stub;
import jade.imtp.leap.StubHelper;
import jade.imtp.leap.TransportProtocol;
import jade.mtp.TransportAddress;
import jade.util.Logger;
import jade.util.leap.ArrayList;
import jade.util.leap.HashMap;
import jade.util.leap.Iterator;
import jade.util.leap.List;
import jade.util.leap.Map;

class CommandDispatcher
implements StubHelper,
ICP.Listener {
    private static final String MAIN_PROTO_CLASS = "main-proto-class";
    protected static final String DEFAULT_NAME = "Default";
    private static boolean enableMultiplePlatforms;
    protected static CommandDispatcher defaultCommandDispatcher;
    protected static Map dispatchers;
    private String platformName;
    protected String name = "Default";
    protected TransportAddress routerTA = null;
    protected Map skeletons = new HashMap();
    protected Map ids = new HashMap();
    protected int nextID = 1;
    protected Map icps = new HashMap();
    protected List addresses = new ArrayList();
    protected List urls = new ArrayList();
    private PlatformManager thePlatformManager = null;
    private Logger myLogger = Logger.getMyLogger(this.getClass().getName());

    public static final synchronized CommandDispatcher getDispatcher(String name) throws IMTPException {
        if (enableMultiplePlatforms) {
            if (name != null) {
                CommandDispatcher cd = (CommandDispatcher)dispatchers.get(name);
                if (cd == null) {
                    cd = new CommandDispatcher();
                    cd.setPlatformName(name);
                    dispatchers.put(name, cd);
                }
                return cd;
            }
            throw new IMTPException("No platform name specified and enable-multiple-platforms mode activated");
        }
        if (defaultCommandDispatcher == null) {
            defaultCommandDispatcher = new CommandDispatcher();
            defaultCommandDispatcher.setPlatformName(name);
        }
        return defaultCommandDispatcher;
    }

    private static synchronized void removeDispatcher(String name) {
        if (enableMultiplePlatforms) {
            dispatchers.remove(name);
        }
    }

    private void setPlatformName(String name) {
        this.platformName = name;
    }

    private CommandDispatcher() {
    }

    synchronized PlatformManager getPlatformManagerProxy(Profile p) throws IMTPException {
        if (this.thePlatformManager == null) {
            PlatformManagerStub stub = new PlatformManagerStub(this.platformName);
            TransportAddress mainTA = this.initMainTA(p);
            stub.bind(this);
            stub.addTA(mainTA);
            this.setPlatformManager(stub);
        }
        return this.thePlatformManager;
    }

    private void setPlatformManager(PlatformManager pm) throws IMTPException {
        this.thePlatformManager = pm;
        String actualPlatformName = this.thePlatformManager.getPlatformName();
        if (this.platformName != null && !this.platformName.equals("*")) {
            if (!this.platformName.equals(actualPlatformName)) {
                throw new IMTPException("Wrong platform name " + this.platformName + ". It should be " + actualPlatformName);
            }
        } else {
            this.platformName = actualPlatformName;
        }
    }

    synchronized void setPlatformManagerProxy(PlatformManager pm) {
        this.thePlatformManager = pm;
    }

    public PlatformManager getPlatformManagerStub(String addr) throws IMTPException {
        try {
            PlatformManagerStub stub = new PlatformManagerStub(this.platformName);
            TransportAddress ta = this.stringToAddr(addr);
            stub.bind(this);
            stub.addTA(ta);
            return stub;
        }
        catch (DispatcherException de) {
            throw new IMTPException("Invalid address for a Platform Manager", de);
        }
    }

    public void addAddressToStub(Stub target, String toAdd) {
        try {
            TransportAddress ta = this.stringToAddr(toAdd);
            target.addTA(ta);
        }
        catch (DispatcherException de) {
            de.printStackTrace();
        }
    }

    public void removeAddressFromStub(Stub target, String toRemove) {
        try {
            TransportAddress ta = this.stringToAddr(toRemove);
            target.removeTA(ta);
        }
        catch (DispatcherException de) {
            de.printStackTrace();
        }
    }

    public void clearStubAddresses(Stub target) {
        target.clearTAs();
    }

    void setRouterAddress(String url) {
        block4: {
            if (url != null) {
                try {
                    TransportAddress ta = this.stringToAddr(url);
                    if (this.routerTA != null && !this.routerTA.equals(ta) && this.myLogger.isLoggable(Logger.WARNING)) {
                        this.myLogger.log(Logger.WARNING, "Transport address of current router has been changed");
                    }
                    this.routerTA = ta;
                }
                catch (Exception e) {
                    if (!this.myLogger.isLoggable(Logger.WARNING)) break block4;
                    this.myLogger.log(Logger.WARNING, "Can't initialize router address");
                }
            }
        }
    }

    @Override
    public Command dispatchCommand(List destTAs, Command command) throws DispatcherException, UnreachableException {
        Integer id;
        Skeleton skel;
        Command response = null;
        if (this.isLocal(destTAs) && (skel = (Skeleton)this.skeletons.get(id = new Integer(command.getObjectID()))) != null) {
            response = skel.processCommand(command);
        }
        if (response == null) {
            try {
                response = this.dispatchSerializedCommand(destTAs, this.serializeCommand(command), command.getRequireFreshConnection(), this.name);
            }
            catch (LEAPSerializationException lse) {
                throw new DispatcherException("Error serializing command " + command + " [" + lse.getMessage() + "]");
            }
        }
        if (command.getCode() == 2 && this.name.equals(DEFAULT_NAME)) {
            this.name = (String)response.getParamAt(0);
        }
        return response;
    }

    private boolean isLocal(List destTAs) {
        try {
            TransportAddress ta1 = (TransportAddress)this.addresses.get(0);
            TransportAddress ta2 = (TransportAddress)destTAs.get(0);
            return ta1.getHost().equals(ta2.getHost()) && ta1.getPort().equals(ta2.getPort()) && ta2.getFile() == null;
        }
        catch (Exception e) {
            return false;
        }
    }

    private Command dispatchSerializedCommand(List destTAs, byte[] commandPayload, boolean requireFreshConnection, String origin) throws DispatcherException, UnreachableException {
        if (destTAs == null || destTAs.size() == 0) {
            throw new DispatcherException("no destination address specified.");
        }
        byte[] responsePayload = null;
        try {
            responsePayload = this.dispatchDirectly(destTAs, commandPayload, requireFreshConnection);
        }
        catch (UnreachableException ue) {
            if (this.myLogger.isLoggable(Logger.FINE)) {
                this.myLogger.log(Logger.FINE, "Destination unreachable. Dispatch command through router.", ue);
            }
            if (this.routerTA != null) {
                responsePayload = this.dispatchThroughRouter(destTAs, commandPayload, requireFreshConnection, origin);
            }
            throw ue;
        }
        try {
            Command response = this.deserializeCommand(responsePayload);
            this.checkRemoteExceptions(response);
            return response;
        }
        catch (LEAPSerializationException lse) {
            throw new DispatcherException("error deserializing response [" + lse.getMessage() + "].");
        }
    }

    private byte[] dispatchDirectly(List destTAs, byte[] commandPayload, boolean requireFreshConnection) throws UnreachableException {
        UnreachableException lastException = null;
        for (int i = 0; i < destTAs.size(); ++i) {
            try {
                return this.send((TransportAddress)destTAs.get(i), commandPayload, requireFreshConnection);
            }
            catch (UnreachableException ue) {
                lastException = ue;
                continue;
            }
        }
        throw lastException;
    }

    private byte[] dispatchThroughRouter(List destTAs, byte[] commandPayload, boolean requireFreshConnection, String origin) throws DispatcherException, UnreachableException {
        Command forward = new Command(37);
        forward.addParam(commandPayload);
        forward.addParam(destTAs);
        forward.addParam(origin);
        try {
            return this.send(this.routerTA, this.serializeCommand(forward), requireFreshConnection);
        }
        catch (LEAPSerializationException lse) {
            throw new DispatcherException("error serializing FORWARD command [" + lse.getMessage() + "].");
        }
    }

    protected void checkRemoteExceptions(Command response) throws DispatcherException, UnreachableException {
        if (response.getCode() == 2) {
            String exception = (String)response.getParamAt(0);
            if (exception.equals("jade.imtp.leap.DispatcherException")) {
                throw new DispatcherException("DispatcherException in remote site. " + response.getParamAt(1));
            }
            if (exception.equals("jade.core.UnreachableException")) {
                throw new UnreachableException((String)response.getParamAt(1));
            }
        }
    }

    protected byte[] serializeCommand(Command command) throws LEAPSerializationException {
        DeliverableDataOutputStream ddout = new DeliverableDataOutputStream(this);
        ddout.serializeCommand(command);
        return ddout.getSerializedByteArray();
    }

    protected Command deserializeCommand(byte[] data) throws LEAPSerializationException {
        return new DeliverableDataInputStream(data, this).deserializeCommand();
    }

    protected Command buildExceptionResponse(Exception exception) {
        Command response = new Command(2);
        response.addParam(exception.getClass().getName());
        response.addParam(exception.getMessage());
        return response;
    }

    private TransportAddress initMainTA(Profile p) throws IMTPException {
        TransportAddress mainTA = null;
        try {
            String mainURL = p.getParameter("main-url", null);
            try {
                mainTA = this.stringToAddr(mainURL);
            }
            catch (DispatcherException de) {
                String mainTPClass = p.getParameter(MAIN_PROTO_CLASS, null);
                if (mainTPClass != null) {
                    TransportProtocol tp = (TransportProtocol)Class.forName(mainTPClass).newInstance();
                    mainTA = tp.stringToAddr(mainURL);
                }
                throw de;
            }
            return mainTA;
        }
        catch (Exception e) {
            throw new IMTPException("Error getting Main Container address", e);
        }
    }

    public void addICP(ICP peer, String peerID, Profile p) {
        try {
            TransportAddress ta = peer.activate(this, peerID, p);
            TransportProtocol tp = peer.getProtocol();
            String url = tp.addrToString(ta);
            if (this.myLogger.isLoggable(Logger.FINE)) {
                this.myLogger.log(Logger.FINE, "ICP " + peerID + " of class " + peer.getClass().getName() + " activated. Address is: " + url);
            }
            this.addresses.add(ta);
            this.urls.add(url);
            String proto = tp.getName().toLowerCase();
            List list = (List)this.icps.get(proto);
            if (list == null) {
                list = new ArrayList();
                this.icps.put(proto, list);
            }
            list.add(peer);
        }
        catch (ICPException icpe) {
            this.myLogger.log(Logger.WARNING, "Error adding ICP " + peer + "[" + icpe.getMessage() + "].");
        }
    }

    TransportProtocol getProtocol(String protoName) {
        List list = (List)this.icps.get(protoName.toLowerCase());
        if (list != null && list.size() > 0) {
            ICP icp = (ICP)list.get(0);
            return icp.getProtocol();
        }
        return null;
    }

    public int getID(Object remoteObject) throws IMTPException {
        Integer id = (Integer)this.ids.get(remoteObject);
        if (id != null) {
            return id;
        }
        throw new IMTPException("specified object is not remotized by this command dispatcher.");
    }

    public List getLocalTAs() {
        return this.addresses;
    }

    public List getLocalURLs() {
        return this.urls;
    }

    protected TransportAddress stringToAddr(String url) throws DispatcherException {
        Iterator peers = this.icps.values().iterator();
        while (peers.hasNext()) {
            try {
                return ((ICP)((List)peers.next()).get(0)).getProtocol().stringToAddr(url);
            }
            catch (Throwable throwable) {
            }
        }
        throw new DispatcherException("can't convert URL " + url + ".");
    }

    public synchronized void registerSkeleton(Skeleton skeleton, Object remotizedObject) throws IMTPException {
        Integer id = null;
        if (remotizedObject instanceof PlatformManager) {
            id = new Integer(0);
            this.name = "Service-Manager";
            this.setPlatformManager((PlatformManager)remotizedObject);
        } else {
            id = new Integer((int)(System.currentTimeMillis() & 0xFFFFFFL));
        }
        if (this.myLogger.isLoggable(Logger.FINE)) {
            this.myLogger.log(Logger.FINE, "Registering skeleton " + skeleton + " for remotized object " + remotizedObject + ". ID is " + id);
        }
        this.skeletons.put(id, skeleton);
        this.ids.put(remotizedObject, id);
    }

    public synchronized void deregisterSkeleton(final Object remoteObject) {
        if (this.myLogger.isLoggable(Logger.FINE)) {
            this.myLogger.log(Logger.FINE, "Deregistering skeleton for remotized object " + remoteObject);
        }
        if (this.skeletons.size() == 1) {
            this.removeRemoteObject(remoteObject);
        } else {
            Thread t = new Thread(){

                @Override
                public void run() {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    CommandDispatcher.this.removeRemoteObject(remoteObject);
                }
            };
            t.start();
        }
    }

    private synchronized void removeRemoteObject(Object remoteObject) {
        Object id = this.ids.remove(remoteObject);
        if (id != null) {
            if (this.myLogger.isLoggable(Logger.FINE)) {
                this.myLogger.log(Logger.FINE, "Asynchronous deregisteration of skeleton for remotized object " + remoteObject + ". ID is " + id);
            }
            this.skeletons.remove(id);
        }
        if (this.ids.isEmpty()) {
            if (this.myLogger.isLoggable(Logger.FINE)) {
                this.myLogger.log(Logger.FINE, "All skeletons deregistered. Shutting down.");
            }
            this.shutDown();
        }
    }

    @Override
    public Stub buildLocalStub(Object remotizedObject) throws IMTPException {
        Stub stub = null;
        if (remotizedObject instanceof Node) {
            stub = new NodeStub(this.getID(remotizedObject), this.platformName);
        } else if (remotizedObject instanceof PlatformManager) {
            stub = new PlatformManagerStub(this.platformName);
        } else {
            throw new IMTPException("can't create a stub for object " + remotizedObject + ".");
        }
        stub.bind(this);
        Iterator it = this.addresses.iterator();
        while (it.hasNext()) {
            stub.addTA((TransportAddress)it.next());
        }
        return stub;
    }

    private byte[] send(TransportAddress ta, byte[] commandPayload, boolean requireFreshConnection) throws UnreachableException {
        List list = (List)this.icps.get(ta.getProto().toLowerCase());
        if (list == null) {
            throw new UnreachableException("no ICP suitable for protocol " + ta.getProto() + ".");
        }
        ICPException lastException = null;
        for (int i = 0; i < list.size(); ++i) {
            try {
                return ((ICP)list.get(i)).deliverCommand(ta, commandPayload, requireFreshConnection);
            }
            catch (ICPException icpe) {
                lastException = icpe;
                continue;
            }
        }
        throw new UnreachableException("ICPException delivering command to address " + ta + ".", lastException);
    }

    private void shutDown() {
        Iterator peersKeys = this.icps.keySet().iterator();
        while (peersKeys.hasNext()) {
            List list = (List)this.icps.get(peersKeys.next());
            for (int i = 0; i < list.size(); ++i) {
                try {
                    ((ICP)list.get(i)).deactivate();
                    continue;
                }
                catch (ICPException iCPException) {
                    // empty catch block
                }
            }
            list.clear();
        }
        this.icps.clear();
        this.urls.clear();
        this.addresses.clear();
        this.thePlatformManager = null;
        this.name = DEFAULT_NAME;
        this.nextID = 1;
        CommandDispatcher.removeDispatcher(this.platformName);
        this.platformName = null;
    }

    @Override
    public byte[] handleCommand(byte[] commandPayload) throws LEAPSerializationException {
        try {
            long start = System.currentTimeMillis();
            Command command = this.deserializeCommand(commandPayload);
            Command response = null;
            if (command.getCode() == 37) {
                byte[] originalPayload = (byte[])command.getParamAt(0);
                List destTAs = (List)command.getParamAt(1);
                String origin = (String)command.getParamAt(2);
                if (origin.equals(this.name)) {
                    response = this.buildExceptionResponse(new UnreachableException("destination unreachable (and forward loop)."));
                } else {
                    try {
                        response = this.dispatchSerializedCommand(destTAs, originalPayload, false, origin);
                    }
                    catch (UnreachableException ue) {
                        response = this.buildExceptionResponse(ue);
                    }
                }
            } else {
                Integer id = new Integer(command.getObjectID());
                Skeleton s = (Skeleton)this.skeletons.get(id);
                response = s != null ? s.processCommand(command) : this.buildExceptionResponse(new DispatcherException("No skeleton for object-id " + id));
            }
            long elapsed = System.currentTimeMillis() - start;
            if (elapsed > 100L) {
                response.addParam(new Integer((int)elapsed));
            }
            return this.serializeCommand(response);
        }
        catch (LEAPSerializationException lse) {
            lse.printStackTrace();
            return this.serializeCommand(this.buildExceptionResponse(new DispatcherException(lse.toString())));
        }
        catch (Exception e) {
            return this.serializeCommand(this.buildExceptionResponse(new DispatcherException(e.toString())));
        }
    }

    static {
        dispatchers = new HashMap();
        enableMultiplePlatforms = "true".equals(System.getProperty("jade.enable.multiple.platforms"));
    }
}

