/*
 * Decompiled with CFR 0.152.
 */
package jade.imtp.leap.JICP;

import jade.core.IMTPException;
import jade.imtp.leap.JICP.JICPAddress;
import jade.imtp.leap.JICP.JICPConnection;
import jade.imtp.leap.JICP.JICPPacket;
import java.net.InetSocketAddress;
import java.net.Socket;

public class NATUtils {
    private String serverAddr;
    private int serverPort;

    public NATUtils(String serverAddr, int serverPort) {
        this.serverAddr = serverAddr;
        this.serverPort = serverPort;
    }

    public InetSocketAddress[] getNATMapping(final String localAddress, final int localPort, int timeout) throws Exception {
        JICPAddress ta = new JICPAddress(this.serverAddr, String.valueOf(this.serverPort), null, null);
        JICPConnection con = null;
        try {
            con = new JICPConnection(ta){

                @Override
                protected void bindSocket(Socket sc) {
                    try {
                        if (localPort > 0) {
                            if (localAddress != null) {
                                sc.bind(new InetSocketAddress(localAddress, localPort));
                            } else {
                                sc.bind(new InetSocketAddress(localPort));
                            }
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            };
            JICPPacket pkt = new JICPPacket(21, 0, new byte[]{0});
            con.writePacket(pkt);
            InetSocketAddress internalEndPoint = new InetSocketAddress(con.getLocalHost(), con.getLocalPort());
            JICPPacket rsp = con.readPacket();
            if (rsp.getType() != 100) {
                byte[] data = rsp.getData();
                if (data != null) {
                    String str = new String(data);
                    System.out.println("Received data " + str);
                    String[] ss = str.split(":");
                    if (ss.length == 2) {
                        try {
                            InetSocketAddress externalEndPoint = new InetSocketAddress(ss[0], Integer.parseInt(ss[1]));
                            InetSocketAddress[] inetSocketAddressArray = new InetSocketAddress[]{internalEndPoint, externalEndPoint};
                            return inetSocketAddressArray;
                        }
                        catch (NumberFormatException nfe) {
                            throw new IMTPException("Wrong port format in JICP response");
                        }
                    }
                    throw new IMTPException("Missing port information in JICP response");
                }
                throw new IMTPException("Null JICP response");
            }
            throw new IMTPException("JICP Protocol error");
        }
        finally {
            try {
                con.close();
            }
            catch (Exception exception) {}
        }
    }

    public static void main(String[] args) {
        NATUtils nat = new NATUtils(args[0], Integer.parseInt(args[1]));
        try {
            InetSocketAddress[] aa = nat.getNATMapping(null, 8888, 10000);
            System.out.println("local =    " + aa[0]);
            System.out.println("external = " + aa[1]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

