/*
 * Decompiled with CFR 0.152.
 */
package jade.imtp.leap.sms;

import jade.imtp.leap.ICPException;
import jade.imtp.leap.JICP.Connection;
import jade.imtp.leap.JICP.JICPConnection;
import jade.imtp.leap.JICP.JICPPacket;
import jade.imtp.leap.sms.SMSManager;
import jade.util.Logger;
import jade.util.leap.Properties;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;

public class PhoneBasedSMSManager
extends SMSManager {
    private static final String LOCAL_PORT = "jade_imtp_leap_sms_PhoneBasedSMSManager_local-port";
    private static final int DEFAULT_LOCAL_PORT = 1100;
    private static final int IDLE = 0;
    private static final int CONNECTED = 1;
    private static final int TERMINATED = 2;
    private int status = 0;
    private Connection myConnection;
    private Logger myLogger = Logger.getMyLogger(this.getClass().getName());

    @Override
    protected void init(Properties pp) throws ICPException {
        super.init(pp);
        int localPort = 1100;
        try {
            localPort = Integer.parseInt(this.myProperties.getProperty(LOCAL_PORT));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.initConnection(localPort);
    }

    private void initConnection(final int localPort) throws ICPException {
        try {
            final ServerSocket server = new ServerSocket(localPort);
            Thread t = new Thread(){

                @Override
                public void run() {
                    try {
                        PhoneBasedSMSManager.this.myLogger.log(Logger.INFO, "PB-SMSManager waiting for the helper phone to connect on port " + localPort + " ...");
                        Socket s = server.accept();
                        PhoneBasedSMSManager.this.myLogger.log(Logger.INFO, "PB-SMSManager: Helper phone connected");
                        try {
                            server.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        PhoneBasedSMSManager.this.notifyConnected(new JICPConnection(s));
                    }
                    catch (Exception e) {
                        PhoneBasedSMSManager.this.myLogger.log(Logger.SEVERE, "PB-SMSManager: Problems accepting connection from the helper phone.");
                        e.printStackTrace();
                        PhoneBasedSMSManager.this.shutDown();
                    }
                }
            };
            t.start();
        }
        catch (IOException ioe) {
            throw new ICPException("I/O error opening server socket on port " + localPort);
        }
    }

    private void notifyConnected(Connection c) {
        this.myConnection = c;
        this.status = 1;
    }

    public void shutDown() {
        this.myLogger.log(Logger.FINE, "PB-SMSManager shutting down...");
        this.status = 2;
        if (this.myConnection != null) {
            try {
                this.myConnection.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    protected void send(String msisdn, int port, byte type, byte[] data) {
        String recipientID = msisdn;
        if (port != -1) {
            recipientID = recipientID + ":" + port;
        }
        if (this.status == 1) {
            this.myLogger.log(Logger.FINEST, "PB-SMSManager sending SMS request to the helper phone. Recipient: " + recipientID);
            JICPPacket pkt = new JICPPacket(0, type, recipientID, data);
            try {
                this.myConnection.writePacket(pkt);
                this.myLogger.log(Logger.FINEST, "PB-SMSManager: request correctly sent.");
            }
            catch (IOException ioe) {
                this.myLogger.log(Logger.WARNING, "PB-SMSManager: Error sending command to the helper phone. " + ioe);
            }
        } else {
            this.myLogger.log(Logger.WARNING, "PB-SMSManager: Helper phone not connected. Can't send SMS to " + recipientID);
        }
    }
}

