/*
 * Decompiled with CFR 0.152.
 */
package jade.proto.states;

import jade.core.AID;
import jade.core.Agent;
import jade.core.behaviours.DataStore;
import jade.core.behaviours.OneShotBehaviour;
import jade.lang.acl.ACLMessage;
import jade.util.leap.Iterator;

public class ReplySender
extends OneShotBehaviour {
    public static final int NO_REPLY_SENT = -1;
    private int ret;
    private String replyKey;
    private String msgKey;

    public ReplySender(Agent a, String replyKey, String msgKey, DataStore ds) {
        this(a, replyKey, msgKey);
        this.setDataStore(ds);
    }

    public ReplySender(Agent a, String replyKey, String msgKey) {
        super(a);
        this.replyKey = replyKey;
        this.msgKey = msgKey;
    }

    @Override
    public void action() {
        ACLMessage msg;
        this.ret = -1;
        DataStore ds = this.getDataStore();
        ACLMessage reply = (ACLMessage)ds.get(this.replyKey);
        if (reply != null && (msg = (ACLMessage)ds.get(this.msgKey)) != null) {
            ReplySender.adjustReply(this.myAgent, reply, msg);
            this.myAgent.send(reply);
            this.ret = reply.getPerformative();
        }
    }

    @Override
    public int onEnd() {
        return this.ret;
    }

    public void setMsgKey(String msgKey) {
        this.msgKey = msgKey;
    }

    public void setReplyKey(String replyKey) {
        this.replyKey = replyKey;
    }

    public static void adjustReply(Agent myAgent, ACLMessage reply, ACLMessage msg) {
        reply.setConversationId(msg.getConversationId());
        reply.setInReplyTo(msg.getReplyWith());
        reply.setProtocol(msg.getProtocol());
        if (reply.getReplyWith() == null) {
            reply.setReplyWith(myAgent.getName() + System.currentTimeMillis());
        }
        if (!reply.getAllReceiver().hasNext()) {
            boolean no_reply_to = true;
            Iterator it = msg.getAllReplyTo();
            while (it.hasNext()) {
                no_reply_to = false;
                reply.addReceiver((AID)it.next());
            }
            if (no_reply_to) {
                reply.addReceiver(msg.getSender());
            }
        }
    }

    protected ReplySender() {
    }
}

