/*
 * Decompiled with CFR 0.152.
 */
package jade.tools.dfgui;

import jade.core.AID;
import jade.domain.FIPAAgentManagement.DFAgentDescription;
import jade.domain.FIPAException;
import jade.gui.DFAgentDscDlg;
import jade.tools.dfgui.DFGUI;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;

class DFGUIViewAction
extends AbstractAction {
    private DFGUI gui;

    public DFGUIViewAction(DFGUI gui) {
        super("View");
        this.gui = gui;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        DFAgentDescription dfd = new DFAgentDescription();
        int kind = this.gui.kindOfOperation();
        AID name = this.gui.getSelectedAgentInTable();
        if (name != null) {
            if (kind == DFGUI.AGENT_VIEW || kind == DFGUI.CHILDREN_VIEW || kind == DFGUI.LASTSEARCH_VIEW) {
                try {
                    if (kind == DFGUI.LASTSEARCH_VIEW) {
                        dfd = this.gui.getDFAgentSearchDsc(name);
                    }
                    dfd = this.gui.myAgent.getDFAgentDsc(name);
                }
                catch (FIPAException fe) {
                    this.gui.showStatusMsg("WARNING! No description for agent called " + name + " is found");
                    return;
                }
            } else if (kind == DFGUI.PARENT_VIEW) {
                dfd = this.gui.myAgent.getDescriptionOfThisDF(name);
            }
        } else {
            return;
        }
        if (dfd != null && kind != -1) {
            DFAgentDscDlg dlg = new DFAgentDscDlg(this.gui);
            dlg.ShowDFDGui(dfd, false, false);
        }
    }
}

