/*
 * Decompiled with CFR 0.152.
 */
package jade.tools.introspector.gui;

import jade.core.AID;
import jade.gui.AgentTree;
import jade.tools.introspector.Introspector;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.tree.TreePath;

class TreeAgentPopupMenu
extends JPopupMenu {
    Introspector debugger;
    String agentName;
    private AgentTree tree;

    public TreeAgentPopupMenu(Introspector d, AgentTree t) {
        this.debugger = d;
        this.tree = t;
        this.build();
    }

    void build() {
        JMenuItem debugOn = new JMenuItem("Debug On");
        JMenuItem debugOff = new JMenuItem("Debug Off");
        TreeAgentPopupMenuListener listener = new TreeAgentPopupMenuListener();
        debugOn.addActionListener(listener);
        debugOn.setName("on");
        debugOff.addActionListener(listener);
        debugOff.setName("off");
        this.add(debugOn);
        this.addSeparator();
        this.add(debugOff);
    }

    class TreeAgentPopupMenuListener
    implements ActionListener {
        TreeAgentPopupMenuListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JMenuItem source = (JMenuItem)e.getSource();
            TreePath[] paths = ((TreeAgentPopupMenu)TreeAgentPopupMenu.this).tree.tree.getSelectionPaths();
            for (int i = 0; i < paths.length; ++i) {
                AgentTree.Node node = (AgentTree.Node)paths[i].getLastPathComponent();
                String agentName = node.getName();
                if (source.getName().equals("on")) {
                    TreeAgentPopupMenu.this.debugger.addAgent(new AID(agentName, true));
                    continue;
                }
                if (!source.getName().equals("off")) continue;
                TreeAgentPopupMenu.this.debugger.removeAgent(new AID(agentName, true));
            }
        }
    }
}

