/*
 * Decompiled with CFR 0.152.
 */
package jade.tools.rma;

import jade.gui.AgentTree;
import jade.tools.rma.ColumnLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableModel;
import javax.swing.tree.TreePath;

class TablePanel
extends JPanel {
    JTable tableView;
    JScrollPane scrollpane;
    JScrollPane tableAggregate;
    Dimension origin = new Dimension(0, 0);
    JComponent selectionModeButtons;
    JComponent resizeModeButtons;
    JPanel mainPanel;
    JPanel controlPanel;
    TableModel dataModel;
    final String[] names = new String[]{"name", "addresses", "state", "owner"};
    Object[][] data = new Object[][]{{"NAME", "ADDRESSES", "STATE", "OWNER"}};

    public TablePanel() {
        this.setLayout(new BorderLayout());
        this.mainPanel = this;
        JPanel column1 = new JPanel(new ColumnLayout());
        JPanel column2 = new JPanel(new ColumnLayout());
        this.tableAggregate = this.createTable();
        this.mainPanel.add((Component)this.tableAggregate, "Center");
    }

    public ImageIcon loadImageIcon(String filename, String description) {
        return new ImageIcon(filename, description);
    }

    private ImageIcon loadIcon(String name, String description) {
        String path = "" + name;
        return this.loadImageIcon(path, description);
    }

    public JScrollPane createTable() {
        this.dataModel = new AbstractTableModel(){

            @Override
            public int getColumnCount() {
                return TablePanel.this.names.length;
            }

            @Override
            public int getRowCount() {
                return TablePanel.this.data.length;
            }

            @Override
            public Object getValueAt(int row, int col) {
                return TablePanel.this.data[row][col];
            }

            @Override
            public String getColumnName(int column) {
                return TablePanel.this.names[column];
            }

            public Class getColumnClass(int c) {
                return String.class;
            }

            @Override
            public void setValueAt(Object aValue, int row, int column) {
                TablePanel.this.data[row][column] = aValue;
            }
        };
        this.tableView = new JTable(this.dataModel);
        DefaultTableCellRenderer colorRenderer = new DefaultTableCellRenderer(){

            @Override
            public void setValue(Object value) {
                if (value instanceof Color) {
                    Color c = (Color)value;
                    this.setForeground(c);
                    this.setText(c.getRed() + ", " + c.getGreen() + ", " + c.getBlue());
                }
            }
        };
        this.tableView.setRowHeight(20);
        this.scrollpane = new JScrollPane(this.tableView);
        this.tableView.setPreferredScrollableViewportSize(new Dimension(200, 70));
        return this.scrollpane;
    }

    public void setData(TreePath[] paths) {
        int numPaths = paths.length;
        this.data = new Object[numPaths][this.names.length];
        for (int i = 0; i < numPaths; ++i) {
            Object[] relCur = paths[i].getPath();
            for (int j = 0; j < relCur.length; ++j) {
                if (!(relCur[j] instanceof AgentTree.AgentNode)) continue;
                AgentTree.AgentNode current = (AgentTree.AgentNode)relCur[j];
                this.data[i][0] = current.getName();
                this.data[i][1] = current.getAddress();
                this.data[i][2] = current.getState();
                this.data[i][3] = current.getOwnership();
            }
        }
        ((AbstractTableModel)this.dataModel).fireTableDataChanged();
    }
}

