/*
 * Decompiled with CFR 0.152.
 */
package jade.util;

import jade.core.IMTPException;
import jade.core.IMTPManager;
import jade.core.Profile;
import jade.mtp.TransportAddress;

public class TransportAddressWrapper {
    private TransportAddress myTA;
    private int hashCode;

    public TransportAddressWrapper(TransportAddress t) {
        this.myTA = t;
        String host = this.myTA.getHost();
        if (host != null) {
            this.hashCode = Profile.isLocalHost(host) ? "localhost".hashCode() : 0;
        }
        this.hashCode += this.myTA.getProto() != null ? this.myTA.getProto().hashCode() : 0;
        this.hashCode += this.myTA.getPort() != null ? this.myTA.getPort().hashCode() : 0;
    }

    public static TransportAddressWrapper getWrapper(String stringifiedTransportAddress, IMTPManager imtpManager) throws IMTPException {
        return new TransportAddressWrapper(imtpManager.stringToAddr(stringifiedTransportAddress));
    }

    public TransportAddress getAddress() {
        return this.myTA;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        TransportAddress otherTA = null;
        if (obj instanceof TransportAddressWrapper) {
            TransportAddressWrapper taw = (TransportAddressWrapper)obj;
            otherTA = taw.getAddress();
        } else if (obj instanceof TransportAddress) {
            otherTA = (TransportAddress)obj;
        } else {
            return false;
        }
        return Profile.compareTransportAddresses(this.myTA, otherTA);
    }

    public String toString() {
        return "W[" + this.myTA + "]";
    }
}

