/*
 * Decompiled with CFR 0.152.
 */
package jade.content.lang.sl;

import jade.content.abs.AbsAggregate;
import jade.content.abs.AbsConcept;
import jade.content.abs.AbsContentElement;
import jade.content.abs.AbsContentElementList;
import jade.content.abs.AbsIRE;
import jade.content.abs.AbsObject;
import jade.content.abs.AbsPredicate;
import jade.content.abs.AbsPrimitive;
import jade.content.abs.AbsReference;
import jade.content.abs.AbsTerm;
import jade.content.abs.AbsVariable;
import jade.content.lang.Codec;
import jade.content.lang.StringCodec;
import jade.content.lang.sl.ExtendedSLParser;
import jade.content.lang.sl.SL0Ontology;
import jade.content.lang.sl.SL1Ontology;
import jade.content.lang.sl.SL2Ontology;
import jade.content.lang.sl.SLOntology;
import jade.content.lang.sl.SLParser;
import jade.content.lang.sl.SimpleSLTokenizer;
import jade.content.onto.Ontology;
import jade.content.onto.OntologyException;
import jade.content.schema.ObjectSchema;
import jade.core.CaseInsensitiveString;
import jade.lang.acl.ISO8601;
import jade.util.leap.Iterator;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.ObjectStreamException;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import org.apache.commons.codec.binary.Base64;

public class SLCodec
extends StringCodec {
    public static final String PRESERVE_JAVA_TYPES = "SL-preserve-java-types";
    private transient SLParser parser;
    private transient ExtendedSLParser extendedParser;
    private SL0Ontology slOnto;
    private Ontology domainOnto = null;
    private transient StringBuffer buffer = null;
    private boolean metaAllowed = true;
    private boolean preserveJavaTypes = false;

    public SLCodec() {
        this(3, SLCodec.readPreserveJavaTypesProperty());
    }

    public SLCodec(boolean preserveJavaTypes) {
        this(3, preserveJavaTypes);
    }

    public SLCodec(int slType) {
        this(slType, SLCodec.readPreserveJavaTypesProperty());
    }

    public SLCodec(int slType, boolean preserveJavaTypes) {
        super(slType == 0 ? "fipa-sl0" : (slType == 1 ? "fipa-sl1" : (slType == 2 ? "fipa-sl2" : "fipa-sl")));
        if (slType < 0 || slType > 2) {
            slType = 3;
        }
        this.slOnto = (SL0Ontology)(slType == 0 ? SL0Ontology.getInstance() : (slType == 1 ? SL1Ontology.getInstance() : (slType == 2 ? SL2Ontology.getInstance() : SLOntology.getInstance())));
        this.preserveJavaTypes = preserveJavaTypes;
        this.initParser();
    }

    private static boolean readPreserveJavaTypesProperty() {
        String strPreserveJavaTypes = System.getProperty(PRESERVE_JAVA_TYPES);
        return "true".equals(strPreserveJavaTypes);
    }

    private void initParser() {
        int slType;
        int n = "fipa-sl0".equals(this.getName()) ? 0 : ("fipa-sl2".equals(this.getName()) ? 1 : (slType = "fipa-sl2".equals(this.getName()) ? 2 : 3));
        if (this.preserveJavaTypes) {
            this.extendedParser = new ExtendedSLParser(new StringReader(""));
            this.extendedParser.setSLType(slType);
        } else {
            this.parser = new SLParser(new StringReader(""));
            this.parser.setSLType(slType);
        }
    }

    public boolean getPreserveJavaTypes() {
        return this.preserveJavaTypes;
    }

    @Override
    public String encode(AbsContentElement content) throws Codec.CodecException {
        return this.encode(null, content);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized String encode(Ontology ontology, AbsContentElement content) throws Codec.CodecException {
        try {
            this.domainOnto = ontology;
            this.buffer = new StringBuffer("(");
            if (content instanceof AbsContentElementList) {
                Iterator i = ((AbsContentElementList)content).iterator();
                while (i.hasNext()) {
                    AbsObject o = (AbsObject)i.next();
                    this.encodeAndAppend(o);
                    this.buffer.append(' ');
                }
            } else {
                this.encodeAndAppend(content);
            }
            this.buffer.append(')');
            String string = this.buffer.toString();
            return string;
        }
        finally {
            this.buffer = null;
        }
    }

    private void encodeAndAppend(String val) {
        String out = SimpleSLTokenizer.isAWord(val) || this.metaAllowed && val.startsWith("??") ? val : SimpleSLTokenizer.quoteString(val);
        this.buffer.append(out);
    }

    /*
     * Unable to fully structure code
     */
    private void encodeAndAppend(AbsPredicate val) throws Codec.CodecException {
        propositionSymbol = val.getTypeName();
        if (val.getCount() > 0) {
            slotNames = this.getSlotNames(val);
            this.buffer.append('(');
            if (this.slOnto.isUnaryLogicalOp(propositionSymbol)) {
                this.buffer.append(propositionSymbol);
                this.buffer.append(' ');
                try {
                    this.encodeAndAppend((AbsPredicate)val.getAbsObject(slotNames[0]));
                }
                catch (RuntimeException e) {
                    throw new Codec.CodecException("A UnaryLogicalOp requires a formula argument", e);
                }
            }
            if (this.slOnto.isBinaryLogicalOp(propositionSymbol)) {
                this.buffer.append(propositionSymbol);
                this.buffer.append(' ');
                try {
                    this.encodeAndAppend((AbsPredicate)val.getAbsObject(slotNames[0]));
                    this.buffer.append(' ');
                    this.encodeAndAppend((AbsPredicate)val.getAbsObject(slotNames[1]));
                }
                catch (RuntimeException e) {
                    throw new Codec.CodecException("A BinaryLogicalOp requires 2 formula arguments", e);
                }
            }
            if (this.slOnto.isQuantifier(propositionSymbol)) {
                this.buffer.append(propositionSymbol);
                this.buffer.append(' ');
                try {
                    this.encodeAndAppend((AbsVariable)val.getAbsObject(slotNames[0]));
                    this.buffer.append(' ');
                    this.encodeAndAppend((AbsPredicate)val.getAbsObject(slotNames[1]));
                }
                catch (RuntimeException e) {
                    throw new Codec.CodecException("A Quantifier requires a variable and a formula arguments", e);
                }
            }
            if (this.slOnto.isConditionedQuantifier(propositionSymbol)) {
                this.buffer.append(propositionSymbol);
                this.buffer.append(' ');
                try {
                    this.encodeAndAppend((AbsVariable)val.getAbsObject(slotNames[0]));
                    this.buffer.append(' ');
                    this.encodeAndAppend((AbsPredicate)val.getAbsObject(slotNames[1]));
                    this.buffer.append(' ');
                    this.encodeAndAppend((AbsPredicate)val.getAbsObject(slotNames[2]));
                }
                catch (RuntimeException e) {
                    throw new Codec.CodecException("A Quantifier requires a variable and a formula arguments", e);
                }
            }
            if (this.slOnto.isModalOp(propositionSymbol)) {
                this.buffer.append(propositionSymbol);
                this.buffer.append(' ');
                try {
                    this.encodeAndAppend((AbsTerm)val.getAbsObject(slotNames[0]));
                    this.buffer.append(' ');
                    this.encodeAndAppend((AbsPredicate)val.getAbsObject(slotNames[1]));
                }
                catch (RuntimeException e) {
                    throw new Codec.CodecException("A ModalOp requires a term and a formula arguments", e);
                }
            }
            if (this.slOnto.isActionOp(propositionSymbol)) {
                this.buffer.append(propositionSymbol);
                this.buffer.append(' ');
                try {
                    this.encodeAndAppend((AbsTerm)val.getAbsObject(slotNames[0]));
                    ap = (AbsPredicate)val.getAbsObject(slotNames[1]);
                    if (ap == null) ** GOTO lbl105
                    this.buffer.append(' ');
                    this.encodeAndAppend(ap);
                }
                catch (RuntimeException e) {
                    throw new Codec.CodecException("An ActionOp requires an actionexpression and (optionally) a formula arguments", e);
                }
            } else {
                if (this.slOnto.isBinaryTermOp(propositionSymbol)) {
                    this.buffer.append(propositionSymbol);
                    this.buffer.append(' ');
                    try {
                        this.encodeAndAppend((AbsTerm)val.getAbsObject(slotNames[0]));
                        this.buffer.append(' ');
                        this.encodeAndAppend((AbsTerm)val.getAbsObject(slotNames[1]));
                    }
                    catch (RuntimeException e) {
                        throw new Codec.CodecException("A BinaryTermOp requires 2 term arguments", e);
                    }
                }
                this.encodeAndAppend(propositionSymbol);
                try {
                    this.encodeSlotsByOrder(val, slotNames);
                }
                catch (RuntimeException e) {
                    throw new Codec.CodecException("SL allows predicates with term arguments only", e);
                }
            }
lbl105:
            // 9 sources

            this.buffer.append(')');
        } else {
            this.encodeAndAppend(propositionSymbol);
        }
    }

    private void encodeAndAppend(AbsIRE val) throws Codec.CodecException {
        this.buffer.append('(');
        this.encodeAndAppend(val.getTypeName());
        this.buffer.append(' ');
        this.encodeAndAppend(val.getTerm());
        this.buffer.append(' ');
        this.encodeAndAppend(val.getProposition());
        this.buffer.append(')');
    }

    private void encodeAndAppend(AbsVariable val) throws Codec.CodecException {
        String var = val.getName();
        if (var.charAt(0) == '?') {
            this.encodeAndAppend(var);
        } else {
            this.buffer.append('?');
            this.encodeAndAppend(var);
        }
    }

    private void encodeAndAppend(AbsReference val) throws Codec.CodecException {
        String objectType = val.getType();
        String name = val.getName();
        this.buffer.append(AbsReference.asString(objectType, name));
    }

    private void encodeAndAppend(AbsConcept val) throws Codec.CodecException {
        String functionSymbol = val.getTypeName();
        this.buffer.append('(');
        String[] slotNames = this.getSlotNames(val);
        if (this.slOnto.isSLFunctionWithoutSlotNames(functionSymbol)) {
            this.buffer.append(functionSymbol);
            try {
                this.encodeSlotsByOrder(val, slotNames);
            }
            catch (RuntimeException e) {
                throw new Codec.CodecException("A FunctionalOperator requires 1 or 2 Term arguments", e);
            }
        }
        this.encodeAndAppend(functionSymbol);
        try {
            if (this.getEncodingByOrder(val)) {
                this.encodeSlotsByOrder(val, slotNames);
            } else {
                this.encodeSlotsByName(val, slotNames);
            }
        }
        catch (RuntimeException e) {
            throw new Codec.CodecException("A FunctionalTerm requires Terms arguments", e);
        }
        this.buffer.append(')');
    }

    private void encodeAndAppend(AbsAggregate val) throws Codec.CodecException {
        this.buffer.append('(');
        this.encodeAndAppend(val.getTypeName());
        Iterator i = val.iterator();
        while (i.hasNext()) {
            this.buffer.append(' ');
            this.encodeAndAppend((AbsObject)i.next());
        }
        this.buffer.append(')');
    }

    private void encodeAndAppend(AbsPrimitive val) throws Codec.CodecException {
        Object v = val.getObject();
        if (v instanceof Date) {
            this.buffer.append(ISO8601.toString((Date)v));
        } else if (v instanceof Number) {
            this.buffer.append(v.toString());
            if (this.preserveJavaTypes) {
                if (v instanceof Long) {
                    this.buffer.append('L');
                } else if (v instanceof Float) {
                    this.buffer.append('F');
                }
            }
        } else if (v instanceof byte[]) {
            byte[] b = (byte[])v;
            b = Base64.encodeBase64((byte[])b);
            this.buffer.append('#');
            this.buffer.append(b.length);
            this.buffer.append('\"');
            try {
                this.buffer.append(new String(b, "US-ASCII"));
            }
            catch (UnsupportedEncodingException uee) {
                throw new Codec.CodecException("Error encoding byte-array to Base64 US-ASCII", uee);
            }
        } else if (v instanceof Boolean) {
            this.buffer.append(v.toString());
        } else {
            String vs = v.toString();
            if (CaseInsensitiveString.equalsIgnoreCase("true", vs) || CaseInsensitiveString.equalsIgnoreCase("false", vs)) {
                this.buffer.append('\"');
                this.buffer.append(vs);
                this.buffer.append('\"');
            } else {
                this.encodeAndAppend(vs);
            }
        }
    }

    private void encodeAndAppend(AbsObject val) throws Codec.CodecException {
        if (val instanceof AbsPrimitive) {
            this.encodeAndAppend((AbsPrimitive)val);
        } else if (val instanceof AbsPredicate) {
            this.encodeAndAppend((AbsPredicate)val);
        } else if (val instanceof AbsIRE) {
            this.encodeAndAppend((AbsIRE)val);
        } else if (val instanceof AbsVariable) {
            this.encodeAndAppend((AbsVariable)val);
        } else if (val instanceof AbsAggregate) {
            this.encodeAndAppend((AbsAggregate)val);
        } else if (val instanceof AbsConcept) {
            this.encodeAndAppend((AbsConcept)val);
        } else if (val instanceof AbsReference) {
            this.encodeAndAppend((AbsReference)val);
        } else {
            throw new Codec.CodecException("SLCodec cannot encode this object " + val);
        }
    }

    @Override
    public AbsContentElement decode(String content) throws Codec.CodecException {
        return this.decode(null, content);
    }

    @Override
    public synchronized AbsContentElement decode(Ontology ontology, String content) throws Codec.CodecException {
        if (ontology == null) {
            ontology = this.slOnto;
        }
        try {
            AbsContentElementList tuple = null;
            if (this.preserveJavaTypes) {
                this.extendedParser.reinit(ontology, content);
                tuple = this.extendedParser.Content();
            } else {
                this.parser.reinit(ontology, content);
                tuple = this.parser.Content();
            }
            if (tuple.size() > 1) {
                return tuple;
            }
            return tuple.get(0);
        }
        catch (Throwable e) {
            throw new Codec.CodecException("Parse exception", e);
        }
    }

    public synchronized AbsTerm decodeTerm(Ontology ontology, String term) throws Codec.CodecException {
        if (ontology == null) {
            ontology = this.slOnto;
        }
        try {
            if (this.preserveJavaTypes) {
                this.extendedParser.reinit(ontology, term);
                return this.extendedParser.Term();
            }
            this.parser.reinit(ontology, term);
            return this.parser.Term();
        }
        catch (Throwable e) {
            throw new Codec.CodecException("Parse exception", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized String encodeTerm(Ontology ontology, AbsTerm term) throws Codec.CodecException {
        try {
            this.domainOnto = ontology;
            this.buffer = new StringBuffer();
            this.encodeAndAppend(term);
            String string = this.buffer.toString();
            return string;
        }
        finally {
            this.buffer = null;
        }
    }

    public synchronized AbsPredicate decodeFormula(Ontology ontology, String formula) throws Codec.CodecException {
        if (ontology == null) {
            ontology = this.slOnto;
        }
        try {
            if (this.preserveJavaTypes) {
                this.extendedParser.reinit(ontology, formula);
                return this.extendedParser.Wff();
            }
            this.parser.reinit(ontology, formula);
            return this.parser.Wff();
        }
        catch (Throwable e) {
            throw new Codec.CodecException("Parse exception", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized String encodeFormula(Ontology ontology, AbsPredicate formula) throws Codec.CodecException {
        try {
            this.domainOnto = ontology;
            this.buffer = new StringBuffer();
            this.encodeAndAppend(formula);
            String string = this.buffer.toString();
            return string;
        }
        finally {
            this.buffer = null;
        }
    }

    public static void main(String[] args) {
        SLCodec codec = null;
        if (args.length > 0) {
            try {
                codec = new SLCodec(Integer.parseInt(args[0]));
            }
            catch (Exception e) {
                System.out.println("usage: SLCodec SLLevel [ContentType]\n where SLLevel can be 0 for SL0, 1 for SL1, 2 for SL2, 3 or more for full SL \n and where ContentType is a char representing the type of content to be parsed: C for a contentexpression (default), T for a term, F for a formula");
                System.exit(0);
            }
        } else {
            codec = new SLCodec(true);
        }
        try {
            BufferedReader buff = new BufferedReader(new InputStreamReader(System.in));
            while (true) {
                int contentType = 70;
                System.out.println("Insert an SL expression (either Wff or T:Term):");
                String str = buff.readLine();
                if (str.startsWith("T:")) {
                    contentType = 84;
                    str = str.substring(2);
                }
                System.out.println("\n\n");
                try {
                    AbsObject result;
                    if (contentType == 70) {
                        result = codec.decodeFormula(null, str);
                        System.out.println("ABS representation:");
                        System.out.println(result);
                        System.out.println("Encoded ABS representation:");
                        System.out.println(codec.encodeFormula(null, (AbsPredicate)result));
                        System.out.println("\n");
                        continue;
                    }
                    if (contentType == 84) {
                        result = codec.decodeTerm(null, str);
                        System.out.println("ABS representation:");
                        System.out.println(result);
                        System.out.println("Encoded ABS representation:");
                        System.out.println(codec.encodeTerm(null, (AbsTerm)result));
                        System.out.println("\n");
                        continue;
                    }
                    result = codec.decode(str);
                    System.out.println("DUMP OF THE DECODE OUTPUT (just for debugging):");
                    System.out.println(result);
                    System.out.println("\n\n");
                    System.out.println("AFTER ENCODE:");
                    System.out.println(codec.encode((AbsContentElement)result));
                    System.out.println("\n\n");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Exception pe) {
            pe.printStackTrace();
            return;
        }
    }

    @Override
    public Ontology getInnerOntology() {
        return this.slOnto;
    }

    private String[] getSlotNames(AbsObject abs) throws Codec.CodecException {
        String[] slotNames = null;
        String type = abs.getTypeName();
        if (this.domainOnto != null && abs.getTypeName() != "agent-identifier") {
            try {
                ObjectSchema s = this.domainOnto.getSchema(type);
                if (s == null) {
                    throw new Codec.CodecException("No schema found for symbol " + type);
                }
                slotNames = s.getNames();
            }
            catch (OntologyException oe) {
                throw new Codec.CodecException("Error getting schema for symbol " + type, oe);
            }
        } else {
            slotNames = abs.getNames();
        }
        return slotNames;
    }

    private boolean getEncodingByOrder(AbsObject abs) throws Codec.CodecException {
        if (this.domainOnto != null) {
            String type = abs.getTypeName();
            try {
                ObjectSchema s = this.domainOnto.getSchema(type);
                return s.getEncodingByOrder();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    private void encodeSlotsByOrder(AbsObject val, String[] slotNames) throws Codec.CodecException {
        boolean lastSlotEmpty = false;
        for (int i = 0; i < slotNames.length; ++i) {
            AbsTerm t = (AbsTerm)val.getAbsObject(slotNames[i]);
            if (t != null) {
                if (lastSlotEmpty) {
                    throw new Codec.CodecException("Non-empty slot " + slotNames[i] + " follows empty slot " + slotNames[i - 1]);
                }
                this.buffer.append(' ');
                this.encodeAndAppend(t);
                continue;
            }
            lastSlotEmpty = true;
        }
    }

    private void encodeSlotsByName(AbsObject val, String[] slotNames) throws Codec.CodecException {
        for (int i = 0; i < slotNames.length; ++i) {
            AbsTerm t = (AbsTerm)val.getAbsObject(slotNames[i]);
            if (t == null) continue;
            if (!slotNames[i].startsWith(UNNAMEDPREFIX)) {
                this.buffer.append(" :");
                this.encodeAndAppend(slotNames[i]);
            }
            this.buffer.append(' ');
            this.encodeAndAppend(t);
        }
    }

    protected Object readResolve() throws ObjectStreamException {
        this.initParser();
        return this;
    }
}

