/*
 * Decompiled with CFR 0.152.
 */
package jade.content.lang.xml;

import jade.content.ContentElementList;
import jade.content.abs.AbsObject;
import jade.content.lang.xml.XMLCodec;
import jade.content.onto.Ontology;
import jade.content.onto.basic.Action;
import jade.content.onto.basic.Result;
import jade.content.onto.basic.TrueProposition;
import jade.core.Agent;
import jade.domain.FIPAAgentManagement.DFAgentDescription;
import jade.domain.FIPAAgentManagement.FIPAManagementOntology;
import jade.domain.FIPAAgentManagement.Property;
import jade.domain.FIPAAgentManagement.Register;
import jade.domain.FIPAAgentManagement.ServiceDescription;
import jade.util.leap.ArrayList;
import java.util.Date;
import java.util.Vector;

public class TestAgent
extends Agent {
    private static final long serialVersionUID = -3099456336278223408L;

    @Override
    protected void setup() {
        try {
            XMLCodec codec = new XMLCodec();
            Ontology onto = FIPAManagementOntology.getInstance();
            DFAgentDescription dfd = new DFAgentDescription();
            dfd.setName(this.getAID());
            dfd.addProtocols("P1");
            dfd.addProtocols("P2");
            ServiceDescription sd = new ServiceDescription();
            sd.setName("service-name");
            sd.setType("service-type");
            sd.addLanguages("L1");
            sd.addProtocols("P3");
            sd.addProtocols("P4");
            sd.addProtocols("P5");
            Property p = new Property("propName", "propVal");
            sd.addProperties(p);
            p = new Property("intPropName", new Integer(25));
            sd.addProperties(p);
            p = new Property("boolPropName", new Boolean(true));
            sd.addProperties(p);
            p = new Property("datePropName", new Date());
            sd.addProperties(p);
            p = new Property("binPropName", new byte[]{1, 2, 3, 4});
            sd.addProperties(p);
            p = new Property("serPropName", new Vector());
            sd.addProperties(p);
            dfd.addServices(sd);
            this.handle(dfd, codec, onto);
            Register reg = new Register();
            reg.setDescription(dfd);
            Action actExpr = new Action(this.getDefaultDF(), reg);
            Result r = new Result(actExpr, "Foo <= Bar");
            this.handle(r, codec, onto);
            ArrayList items = new ArrayList();
            items.add(dfd);
            r.setItems(items);
            ContentElementList ll = new ContentElementList();
            ll.add(r);
            ll.add(new TrueProposition());
            this.handle(ll, codec, onto);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void handle(Object val, XMLCodec codec, Ontology onto) throws Exception {
        String s = codec.encodeObject(onto, val, true);
        System.out.println(s);
        System.out.println("#####################################");
        AbsObject abs = codec.decodeAbsObject(onto, s);
        System.out.println(abs);
        System.out.println("=====================================");
    }
}

