/*
 * Decompiled with CFR 0.152.
 */
package jade.content.lang.xml;

import jade.content.abs.AbsAggregate;
import jade.content.abs.AbsContentElement;
import jade.content.abs.AbsContentElementList;
import jade.content.abs.AbsObject;
import jade.content.abs.AbsPrimitive;
import jade.content.abs.AbsPrimitiveSlotsHolder;
import jade.content.abs.AbsTerm;
import jade.content.lang.Codec;
import jade.content.lang.xml.XMLCodec;
import jade.content.onto.Ontology;
import jade.content.onto.OntologyException;
import jade.content.schema.AggregateSchema;
import jade.content.schema.ObjectSchema;
import jade.lang.acl.ISO8601;
import jade.util.leap.ArrayList;
import jade.util.leap.Iterator;
import jade.util.leap.List;
import java.io.StringReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.codec.binary.Base64;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

class XMLDecoder {
    private Ontology ontology;
    private boolean preserveJavaTypes;

    XMLDecoder() {
    }

    public void init(Ontology onto, boolean preserveJavaTypes) {
        this.ontology = onto;
        this.preserveJavaTypes = preserveJavaTypes;
    }

    public AbsObject decode(String xml) throws Codec.CodecException, OntologyException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        factory.setNamespaceAware(false);
        Node root = null;
        try {
            root = this.parseXML(factory, xml);
        }
        catch (SAXException e) {
            try {
                xml = "<sequence>" + xml + "</" + "sequence" + ">";
                root = this.parseXML(factory, xml);
            }
            catch (SAXException e1) {
                throw new Codec.CodecException("XML parse error", e);
            }
            catch (Exception e2) {
                throw new Codec.CodecException("XML parse error", e2);
            }
        }
        catch (Exception e) {
            throw new Codec.CodecException("XML parse error", e);
        }
        return this.decodeNode(root);
    }

    private Node parseXML(DocumentBuilderFactory factory, String xml) throws Exception {
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document doc = builder.parse(new InputSource(new StringReader(xml)));
        return doc.getDocumentElement();
    }

    private AbsObject decodeNode(Node n) throws Codec.CodecException, OntologyException {
        String typeName = n.getNodeName();
        if (typeName.equals("primitive")) {
            return this.decodePrimitive(n);
        }
        if (typeName.equals("ContentElementList")) {
            return this.decodeContentElementList(n);
        }
        ObjectSchema schema = this.ontology.getSchema(typeName);
        if (schema != null) {
            if (schema instanceof AggregateSchema) {
                return this.decodeAggregate(n.getChildNodes(), n.getAttributes(), schema.getTypeName());
            }
            boolean encodeByOrder = schema.getEncodingByOrder();
            if (encodeByOrder) {
                return this.decodeNodeByOrder(n, schema);
            }
            return this.decodeNodeByName(n, schema);
        }
        throw new OntologyException("No schema found for type name " + typeName);
    }

    private AbsObject decodeNodeByName(Node n, ObjectSchema schema) throws Codec.CodecException, OntologyException {
        AbsPrimitiveSlotsHolder abs = (AbsPrimitiveSlotsHolder)schema.newInstance();
        NamedNodeMap attributes = n.getAttributes();
        int length = attributes.getLength();
        for (int i = 0; i < length; ++i) {
            Node slot = attributes.item(i);
            String slotName = slot.getNodeName();
            String slotTypeName = schema.getSchema(slotName).getTypeName();
            this.setPrimitiveSlot(abs, slotName, slotTypeName, slot.getNodeValue());
        }
        NodeList list = n.getChildNodes();
        length = list.getLength();
        for (int i = 0; i < length; ++i) {
            Node strValue;
            Node attr;
            Node slot = list.item(i);
            if (!(slot instanceof Element)) continue;
            String slotName = slot.getNodeName();
            AbsObject slotValue = null;
            NodeList slotChildList = slot.getChildNodes();
            ObjectSchema slotSchema = schema.getSchema(slotName);
            if (slotSchema instanceof AggregateSchema) {
                slotValue = this.decodeAggregate(slotChildList, slot.getAttributes(), slotSchema.getTypeName());
            } else if (AggregateSchema.getBaseSchema().isCompatibleWith(slotSchema) && (attr = (attributes = slot.getAttributes()).getNamedItem("aggregate")) != null && attr.getNodeValue().equals("true")) {
                slotValue = this.decodeAggregate(slotChildList, attributes, null);
            }
            if (slotValue == null && slotChildList.getLength() == 1 && slot.getAttributes().getLength() == 0 && !((strValue = slotChildList.item(0)) instanceof Element)) {
                slotValue = AbsPrimitive.wrap(strValue.getNodeValue());
            }
            if (slotValue == null) {
                for (int j = 0; j < slotChildList.getLength(); ++j) {
                    Node value = slotChildList.item(j);
                    if (!(value instanceof Element)) continue;
                    slotValue = this.decodeNode(value);
                    break;
                }
            }
            abs.set(slotName, slotValue);
        }
        return abs;
    }

    private AbsObject decodeNodeByOrder(Node n, ObjectSchema schema) throws Codec.CodecException, OntologyException {
        int i;
        AbsPrimitiveSlotsHolder abs = (AbsPrimitiveSlotsHolder)schema.newInstance();
        String[] slotNames = schema.getNames();
        AbsObject[] slotValuesByName = new AbsObject[slotNames.length];
        ArrayList slotValuesByOrder = new ArrayList();
        NamedNodeMap attributes = n.getAttributes();
        int length = attributes.getLength();
        for (int i2 = 0; i2 < length; ++i2) {
            Node slot = attributes.item(i2);
            String slotName = slot.getNodeName();
            String slotTypeName = schema.getSchema(slotName).getTypeName();
            this.setPrimitiveSlot(slotNames, slotValuesByName, slotName, slotTypeName, slot.getNodeValue());
        }
        NodeList list = n.getChildNodes();
        length = list.getLength();
        for (i = 0; i < length; ++i) {
            Node slot = list.item(i);
            if (!(slot instanceof Element) || this.handleAggregateSlot(slotNames, slotValuesByName, slot, schema) || this.handleStringSlot(slotNames, slotValuesByName, slot)) continue;
            slotValuesByOrder.add(this.decodeNode(slot));
        }
        for (i = 0; i < slotNames.length; ++i) {
            if (slotValuesByName[i] != null) {
                abs.set(slotNames[i], slotValuesByName[i]);
                continue;
            }
            ObjectSchema slotSchema = schema.getSchema(slotNames[i]);
            AbsObject slotValue = this.findValueByType(slotValuesByOrder, slotSchema);
            if (slotValue == null) continue;
            abs.set(slotNames[i], slotValue);
            slotValuesByOrder.remove(slotValue);
        }
        return abs;
    }

    private AbsObject findValueByType(List slotValues, ObjectSchema slotSchema) throws OntologyException {
        Iterator it = slotValues.iterator();
        while (it.hasNext()) {
            AbsObject slotValue = (AbsObject)it.next();
            ObjectSchema valueSchema = this.ontology.getSchema(slotValue.getTypeName());
            if (!valueSchema.isCompatibleWith(slotSchema)) continue;
            return slotValue;
        }
        return null;
    }

    private AbsObject decodePrimitive(Node n) throws Codec.CodecException {
        NamedNodeMap attributes = n.getAttributes();
        Node attrType = attributes.getNamedItem("type");
        Node attrValue = attributes.getNamedItem("value");
        if (attrType != null && attrValue != null) {
            return this.decodeAbsPrimitive(attrType.getNodeValue(), attrValue.getNodeValue());
        }
        throw new Codec.CodecException("Missing \"value\" and \"type\" attributes in primitive element " + n);
    }

    private AbsPrimitive decodeAbsPrimitive(String typeName, String value) {
        if ("STRING".equals(typeName) || "BO_String".equals(typeName)) {
            value = XMLCodec.fromXML(value);
            return AbsPrimitive.wrap(value);
        }
        if (this.preserveJavaTypes) {
            int lastChar;
            int length2 = value.length();
            int n = lastChar = length2 > 0 ? (int)value.charAt(length2 - 1) : 35;
            if (lastChar == 76) {
                try {
                    return AbsPrimitive.wrap(Long.parseLong(value.substring(0, length2 - 1)));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (lastChar == 70) {
                try {
                    return AbsPrimitive.wrap(Float.parseFloat(value.substring(0, length2 - 1)));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            try {
                return AbsPrimitive.wrap(Integer.parseInt(value));
            }
            catch (Exception exception) {
            }
        } else {
            try {
                return AbsPrimitive.wrap(Long.parseLong(value));
            }
            catch (Exception length2) {
                // empty catch block
            }
        }
        try {
            return AbsPrimitive.wrap(Double.parseDouble(value));
        }
        catch (Exception length2) {
            try {
                return AbsPrimitive.wrap(ISO8601.toDate(value));
            }
            catch (Exception length2) {
                if (value.startsWith("#")) {
                    try {
                        String base64Str = value.substring(1);
                        return AbsPrimitive.wrap(Base64.decodeBase64((byte[])base64Str.getBytes("US-ASCII")));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (value.equalsIgnoreCase("true")) {
                    return AbsPrimitive.wrap(true);
                }
                if (value.equalsIgnoreCase("false")) {
                    return AbsPrimitive.wrap(false);
                }
                return AbsPrimitive.wrap(value.toString());
            }
        }
    }

    private void setPrimitiveSlot(AbsPrimitiveSlotsHolder abs, String slotName, String slotTypeName, String value) {
        AbsPrimitive slotValue = this.decodeAbsPrimitive(slotTypeName, value);
        abs.set(slotName, slotValue);
    }

    private void setPrimitiveSlot(String[] slotNames, AbsObject[] slotValues, String slotName, String slotType, String value) throws OntologyException {
        for (int i = 0; i < slotNames.length; ++i) {
            if (!slotNames[i].equalsIgnoreCase(slotName)) continue;
            slotValues[i] = this.decodeAbsPrimitive(slotType, value);
            return;
        }
        throw new OntologyException("Attribute " + slotName + " is not a valid slot name.");
    }

    private boolean handleStringSlot(String[] slotNames, AbsObject[] slotValues, Node slot) throws Codec.CodecException, OntologyException {
        String slotName = slot.getNodeName();
        for (int i = 0; i < slotNames.length; ++i) {
            Node strValue;
            if (!slotNames[i].equalsIgnoreCase(slotName)) continue;
            NodeList slotChildList = slot.getChildNodes();
            if (slotChildList.getLength() != 1 || slot.getAttributes().getLength() != 0 || (strValue = slotChildList.item(0)) instanceof Element) break;
            slotValues[i] = AbsPrimitive.wrap(strValue.getNodeValue());
            return true;
        }
        return false;
    }

    private boolean handleAggregateSlot(String[] slotNames, AbsObject[] slotValues, Node slot, ObjectSchema schema) throws Codec.CodecException, OntologyException {
        String slotName = slot.getNodeName();
        for (int i = 0; i < slotNames.length; ++i) {
            if (!slotNames[i].equalsIgnoreCase(slotName)) continue;
            try {
                NamedNodeMap attributes;
                Node attr;
                ObjectSchema slotSchema = schema.getSchema(slotName);
                if (slotSchema instanceof AggregateSchema) {
                    slotValues[i] = this.decodeAggregate(slot.getChildNodes(), slot.getAttributes(), slotSchema.getTypeName());
                    return true;
                }
                if (AggregateSchema.getBaseSchema().isCompatibleWith(slotSchema) && (attr = (attributes = slot.getAttributes()).getNamedItem("aggregate")) != null && attr.getNodeValue().equals("true")) {
                    slotValues[i] = this.decodeAggregate(slot.getChildNodes(), attributes, null);
                    return true;
                }
            }
            catch (OntologyException ontologyException) {}
            break;
        }
        return false;
    }

    private AbsAggregate decodeAggregate(NodeList list, NamedNodeMap attributes, String typeName) throws Codec.CodecException, OntologyException {
        Node attr = attributes.getNamedItem("aggregate-type");
        if (attr != null) {
            typeName = attr.getNodeValue();
        }
        if (typeName == null) {
            typeName = "sequence";
        }
        AbsAggregate abs = new AbsAggregate(typeName);
        int length = list.getLength();
        for (int i = 0; i < length; ++i) {
            Node item = list.item(i);
            if (!(item instanceof Element)) continue;
            abs.add((AbsTerm)this.decodeNode(item));
        }
        return abs;
    }

    private AbsContentElementList decodeContentElementList(Node n) throws Codec.CodecException, OntologyException {
        AbsContentElementList abs = new AbsContentElementList();
        NodeList list = n.getChildNodes();
        int length = list.getLength();
        for (int i = 0; i < length; ++i) {
            Node item = list.item(i);
            if (!(item instanceof Element)) continue;
            abs.add((AbsContentElement)this.decodeNode(item));
        }
        return abs;
    }
}

