/*
 * Decompiled with CFR 0.152.
 */
package jade.core.sam;

import jade.core.sam.AverageMeasure;
import jade.core.sam.AverageMeasureProvider;

public class AverageMeasureProviderImpl
implements AverageMeasureProvider {
    private double sum = 0.0;
    private int nSamples = 0;

    public synchronized void addSample(Number value) {
        if (value != null) {
            this.addSample(value.doubleValue());
        }
    }

    public synchronized void addSample(int value) {
        ++this.nSamples;
        this.sum += (double)value;
    }

    public synchronized void addSample(long value) {
        ++this.nSamples;
        this.sum += (double)value;
    }

    public synchronized void addSample(float value) {
        ++this.nSamples;
        this.sum += (double)value;
    }

    public synchronized void addSample(double value) {
        ++this.nSamples;
        this.sum += value;
    }

    @Override
    public synchronized AverageMeasure getValue() {
        double avg = this.nSamples != 0 ? this.sum / (double)this.nSamples : Double.NaN;
        AverageMeasure result = new AverageMeasure(avg, this.nSamples);
        this.nSamples = 0;
        this.sum = 0.0;
        return result;
    }

    public Object clone() throws CloneNotSupportedException {
        AverageMeasureProviderImpl clonedAvgMeasureProvider = new AverageMeasureProviderImpl();
        clonedAvgMeasureProvider.sum = this.sum;
        clonedAvgMeasureProvider.nSamples = this.nSamples;
        return clonedAvgMeasureProvider;
    }
}

