/*
 * Decompiled with CFR 0.152.
 */
package jade.core.sam;

import jade.core.Profile;
import jade.core.sam.AverageMeasure;
import jade.core.sam.SAMInfo;
import jade.core.sam.SAMInfoHandler;
import jade.util.Logger;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class DefaultSAMInfoHandlerImpl
implements SAMInfoHandler {
    private static final String SAM_PREFIX = "SAM_";
    private Map<String, PrintStream> entityFiles = new HashMap<String, PrintStream>();
    private Map<String, CounterInfo> counters = new HashMap<String, CounterInfo>();
    private SimpleDateFormat timeStampFormatter = new SimpleDateFormat("yyyy-MM-dd HH:mm");
    private String csvSeparator;
    private List<String> summaryFields = null;
    private List<String> summaryValues = null;
    private PrintStream summaryFile = null;
    private File samInfoDirectory;
    private String fileSeparator;
    private Logger myLogger = Logger.getMyLogger(this.getClass().getName());

    DefaultSAMInfoHandlerImpl() {
    }

    @Override
    public void initialize(Profile p) throws Exception {
        this.fileSeparator = System.getProperty("file.separator");
        String samInfoDirectoryName = p.getParameter("jade_core_sam_SAMService_csvdirectory", ".");
        this.samInfoDirectory = new File(samInfoDirectoryName);
        if (!this.samInfoDirectory.exists()) {
            this.myLogger.log(Logger.CONFIG, "SAM csv directory " + this.samInfoDirectory + " does not exists. Creating it ...");
            boolean success = this.samInfoDirectory.mkdirs();
            if (!success) {
                throw new IOException("Cannot create SAM csv directory " + samInfoDirectoryName + ".");
            }
        } else if (!this.samInfoDirectory.isDirectory()) {
            throw new IOException("SAM csv location " + samInfoDirectoryName + " is not a directory.");
        }
        this.csvSeparator = p.getParameter("jade_core_sam_SAMService_csvseparator", ";");
        String summaryStr = p.getParameter("jade_core_sam_SAMService_summary", null);
        if (summaryStr != null && summaryStr.length() > 0) {
            String[] ff = summaryStr.split(";");
            this.summaryFields = new ArrayList<String>(ff.length);
            this.summaryValues = new ArrayList<String>(ff.length);
            for (String field : ff) {
                this.summaryFields.add(field);
                this.summaryValues.add("");
            }
        }
    }

    @Override
    public void shutdown() {
        for (PrintStream ps : this.entityFiles.values()) {
            ps.close();
        }
        for (CounterInfo ci : this.counters.values()) {
            ci.stream.close();
        }
        if (this.summaryFile != null) {
            this.summaryFile.close();
        }
    }

    @Override
    public void handle(Date timeStamp, SAMInfo info) {
        if (this.summaryValues != null) {
            for (int i = 0; i < this.summaryValues.size(); ++i) {
                this.summaryValues.set(i, "");
            }
        }
        String timeStampStr = this.timeStampFormatter.format(timeStamp);
        Map<String, AverageMeasure> entityMeasures = info.getEntityMeasures();
        for (String string : entityMeasures.keySet()) {
            this.myLogger.log(Logger.FINE, "Handling measure of entity " + string);
            try {
                int k;
                AverageMeasure m = entityMeasures.get(string);
                PrintStream stream = this.entityFiles.get(string);
                if (stream == null) {
                    this.myLogger.log(Logger.INFO, "Creating CSV file for measures of entity " + string);
                    File f = this.createFile(string);
                    stream = new PrintStream(f);
                    stream.println("Time-stamp" + this.csvSeparator + "Average-value" + this.csvSeparator + "N-samples");
                    this.entityFiles.put(string, stream);
                }
                stream.println(timeStampStr + this.csvSeparator + m.getValue() + this.csvSeparator + m.getNSamples());
                if (this.summaryFields == null || (k = this.summaryFields.indexOf(string)) < 0) continue;
                this.summaryValues.set(k, String.valueOf(m.getValue()));
            }
            catch (Exception e) {
                this.myLogger.log(Logger.WARNING, "Error writing to CSV file of entity " + string, e);
                this.entityFiles.remove(string);
            }
        }
        Map<String, Long> counterValues = info.getCounterValues();
        for (String counterName : counterValues.keySet()) {
            this.myLogger.log(Logger.FINE, "Handling value of counter " + counterName);
            try {
                int k;
                long value = counterValues.get(counterName);
                CounterInfo ci = this.counters.get(counterName);
                if (ci == null) {
                    this.myLogger.log(Logger.INFO, "Creating CSV file for values of counter " + counterName);
                    File f = this.createFile(counterName);
                    PrintStream stream = new PrintStream(f);
                    stream.println("Time-stamp" + this.csvSeparator + "Value" + this.csvSeparator + "Total-value");
                    ci = new CounterInfo(stream);
                    this.counters.put(counterName, ci);
                }
                ci.totValue += value;
                ci.stream.println(timeStampStr + this.csvSeparator + value + this.csvSeparator + ci.totValue);
                if (this.summaryFields == null || (k = this.summaryFields.indexOf(counterName)) < 0) continue;
                this.summaryValues.set(k, String.valueOf(value));
            }
            catch (Exception e) {
                this.myLogger.log(Logger.WARNING, "Error writing to CSV file of counter " + counterName, e);
                this.counters.remove(counterName);
            }
        }
        if (this.summaryFields != null) {
            try {
                if (this.summaryFile == null) {
                    this.myLogger.log(Logger.INFO, "Creating CSV file for SAM Summary");
                    File file = this.createFile("Summary");
                    this.summaryFile = new PrintStream(file);
                    StringBuffer sb = new StringBuffer("Time-stamp");
                    for (String field : this.summaryFields) {
                        sb.append(this.csvSeparator + field);
                    }
                    this.summaryFile.println(sb.toString());
                }
                StringBuffer stringBuffer = new StringBuffer(timeStampStr);
                for (String value : this.summaryValues) {
                    stringBuffer.append(this.csvSeparator + value);
                }
                this.summaryFile.println(stringBuffer.toString());
            }
            catch (Exception exception) {
                this.myLogger.log(Logger.WARNING, "Error writing to Summary CSV file", exception);
                this.summaryFile = null;
            }
        }
    }

    private File createFile(String name) throws IOException {
        File dir = this.samInfoDirectory;
        String[] ss = name.split("/");
        if (ss.length > 1) {
            String dirName = this.samInfoDirectory.getPath();
            for (int i = 0; i < ss.length - 1; ++i) {
                dirName = dirName + this.fileSeparator + ss[i];
            }
            dir = new File(dirName);
            if (!dir.exists()) {
                this.myLogger.log(Logger.INFO, "Creating directory " + dir + " ...");
                boolean success = dir.mkdirs();
                if (!success) {
                    throw new IOException("Cannot create directory " + dirName + ".");
                }
            }
            name = ss[ss.length - 1];
        }
        String fileName = dir.getPath() + this.fileSeparator + SAM_PREFIX + name + ".csv";
        File file = new File(fileName);
        file.createNewFile();
        return file;
    }

    private class CounterInfo {
        PrintStream stream;
        long totValue = 0L;

        CounterInfo(PrintStream ps) {
            this.stream = ps;
        }
    }
}

