/*
 * Decompiled with CFR 0.152.
 */
package jade.domain;

import jade.JadeClassLoader;
import jade.content.Concept;
import jade.content.ContentElement;
import jade.content.ContentElementList;
import jade.content.Predicate;
import jade.content.lang.Codec;
import jade.content.lang.sl.SLCodec;
import jade.content.onto.basic.Action;
import jade.content.onto.basic.Done;
import jade.content.onto.basic.Result;
import jade.core.AID;
import jade.core.behaviours.ThreadedBehaviourFactory;
import jade.domain.DFAppletManagementBehaviour;
import jade.domain.DFFipaAgentManagementBehaviour;
import jade.domain.DFGUIAdapter;
import jade.domain.DFGUIInterface;
import jade.domain.DFGUIManagement.DFAppletOntology;
import jade.domain.DFGUIManagement.DeregisterFrom;
import jade.domain.DFGUIManagement.Federate;
import jade.domain.DFGUIManagement.GetDescription;
import jade.domain.DFGUIManagement.GetDescriptionUsed;
import jade.domain.DFGUIManagement.GetParents;
import jade.domain.DFGUIManagement.ModifyOn;
import jade.domain.DFGUIManagement.RegisterWith;
import jade.domain.DFGUIManagement.SearchOn;
import jade.domain.DFIteratedSearchManagementBehaviour;
import jade.domain.DFJadeAgentManagementBehaviour;
import jade.domain.DFKBFactory;
import jade.domain.DFService;
import jade.domain.FIPAAgentManagement.AlreadyRegistered;
import jade.domain.FIPAAgentManagement.DFAgentDescription;
import jade.domain.FIPAAgentManagement.Deregister;
import jade.domain.FIPAAgentManagement.FIPAManagementOntology;
import jade.domain.FIPAAgentManagement.FailureException;
import jade.domain.FIPAAgentManagement.InternalError;
import jade.domain.FIPAAgentManagement.Modify;
import jade.domain.FIPAAgentManagement.NotRegistered;
import jade.domain.FIPAAgentManagement.Register;
import jade.domain.FIPAAgentManagement.Search;
import jade.domain.FIPAAgentManagement.SearchConstraints;
import jade.domain.FIPAAgentManagement.ServiceDescription;
import jade.domain.FIPAAgentManagement.Unauthorised;
import jade.domain.FIPAException;
import jade.domain.JADEAgentManagement.JADEManagementOntology;
import jade.domain.JADEAgentManagement.ShowGui;
import jade.domain.KBManagement.KB;
import jade.domain.KBManagement.KBIterator;
import jade.domain.KBManagement.LeaseManager;
import jade.domain.KBSubscriptionManager;
import jade.domain.RemoteDFRequester;
import jade.domain.introspection.AMSSubscriber;
import jade.domain.introspection.DeadAgent;
import jade.domain.introspection.Event;
import jade.gui.GuiAgent;
import jade.gui.GuiEvent;
import jade.lang.acl.ACLMessage;
import jade.lang.acl.ISO8601;
import jade.lang.acl.MessageTemplate;
import jade.proto.AchieveREInitiator;
import jade.proto.SubscriptionResponder;
import jade.util.HashCache;
import jade.util.Logger;
import jade.util.leap.ArrayList;
import jade.util.leap.HashMap;
import jade.util.leap.Iterator;
import jade.util.leap.List;
import jade.util.leap.Properties;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Map;
import java.util.Vector;

public class df
extends GuiAgent
implements DFGUIAdapter {
    private static final int SEARCH_ID_CACHE_SIZE = 16;
    private HashCache searchIdCache = new HashCache(16);
    private int searchIdCnt = 0;
    private List children = new ArrayList();
    private List parents = new ArrayList();
    private HashMap dscDFParentMap = new HashMap();
    private HashMap pendingRequests = new HashMap();
    private DFGUIInterface gui;
    private DFAgentDescription myDescription = null;
    private Codec codec = new SLCodec();
    private ThreadedBehaviourFactory tbf;
    private AMSSubscriber amsSubscriber;
    private static final String AUTOCLEANUP = "jade_domain_df_autocleanup";
    private static final String POOLSIZE = "jade_domain_df_poolsize";
    private static final String MAX_LEASE_TIME = "jade_domain_df_maxleasetime";
    private static final String MAX_RESULTS = "jade_domain_df_maxresult";
    private static final String DISABLE_VALIDATION = "jade_domain_df_disablevalidation";
    private static final String DB_DRIVER = "jade_domain_df_db-driver";
    private static final String DB_URL = "jade_domain_df_db-url";
    private static final String DB_USERNAME = "jade_domain_df_db-username";
    private static final String DB_PASSWORD = "jade_domain_df_db-password";
    private static final String KB_FACTORY = "jade_domain_df_kb-factory";
    private static final String DB_DEFAULT = "jade_domain_df_db-default";
    private static final String DB_CLEANTABLES = "jade_domain_df_db-cleantables";
    private static final String DB_ABORTONERROR = "jade_domain_df_db-abortonerror";
    private static final String DEFAULT_MAX_RESULTS = "100";
    private int maxResultLimit = Integer.parseInt("100");
    private Date maxLeaseTime = null;
    private KB agentDescriptions = null;
    private KBSubscriptionManager subManager = null;
    private SubscriptionResponder dfSubscriptionResponder;
    private Logger logger;

    @Override
    protected void setup() {
        this.logger = Logger.getMyLogger(this.getLocalName());
        String sDisableValidation = this.getProperty(DISABLE_VALIDATION, "false");
        String sAutocleanup = this.getProperty(AUTOCLEANUP, null);
        String sPoolsize = this.getProperty(POOLSIZE, null);
        String sMaxLeaseTime = this.getProperty(MAX_LEASE_TIME, null);
        String sMaxResults = this.getProperty(MAX_RESULTS, DEFAULT_MAX_RESULTS);
        String dbUrl = this.getProperty(DB_URL, null);
        String dbDriver = this.getProperty(DB_DRIVER, null);
        String dbUsername = this.getProperty(DB_USERNAME, null);
        String dbPassword = this.getProperty(DB_PASSWORD, null);
        String kbFactClass = this.getProperty(KB_FACTORY, null);
        String sDBDefault = this.getProperty(DB_DEFAULT, null);
        String sCleanTables = this.getProperty(DB_CLEANTABLES, null);
        String sDBAbortOnError = this.getProperty(DB_ABORTONERROR, null);
        Object[] args = this.getArguments();
        if (args != null && args.length > 0) {
            Properties p = new Properties();
            try {
                p.load((String)args[0]);
                sAutocleanup = p.getProperty(AUTOCLEANUP, sAutocleanup);
                sPoolsize = p.getProperty(POOLSIZE, sPoolsize);
                sMaxLeaseTime = p.getProperty(MAX_LEASE_TIME, sMaxLeaseTime);
                sMaxResults = p.getProperty(MAX_RESULTS, sMaxResults);
                sDisableValidation = p.getProperty(DISABLE_VALIDATION, sDisableValidation);
                dbUrl = p.getProperty(DB_URL, dbUrl);
                dbDriver = p.getProperty(DB_DRIVER, dbDriver);
                dbUsername = p.getProperty(DB_USERNAME, dbUsername);
                dbPassword = p.getProperty(DB_PASSWORD, dbPassword);
                kbFactClass = p.getProperty(KB_FACTORY, kbFactClass);
                sDBDefault = p.getProperty(DB_DEFAULT, sDBDefault);
                sCleanTables = p.getProperty(DB_CLEANTABLES, sCleanTables);
                sDBAbortOnError = p.getProperty(DB_ABORTONERROR, sDBAbortOnError);
            }
            catch (Exception e) {
                this.logger.log(Logger.SEVERE, "Agent " + this.getLocalName() + " - Error loading configuration from file " + args[0], e);
            }
        }
        try {
            this.maxLeaseTime = new Date(Long.parseLong(sMaxLeaseTime));
        }
        catch (Exception p) {
            // empty catch block
        }
        this.logger.log(Logger.CONFIG, "Agent " + this.getLocalName() + " - Max lease time = " + (this.maxLeaseTime != null ? ISO8601.toRelativeTimeString(this.maxLeaseTime.getTime()) : "infinite"));
        try {
            this.maxResultLimit = Integer.parseInt(sMaxResults);
            if (this.maxResultLimit < 0) {
                this.maxResultLimit = Integer.parseInt(DEFAULT_MAX_RESULTS);
                this.logger.log(Logger.WARNING, "Agent " + this.getLocalName() + " - The maxResult parameter of the DF Search Constraints can't be a negative value. It has been set to the default value: " + DEFAULT_MAX_RESULTS);
            } else if (this.maxResultLimit > Integer.parseInt(DEFAULT_MAX_RESULTS)) {
                this.logger.log(Logger.WARNING, "Agent " + this.getLocalName() + " - Setting the maxResult of the DF Search Constraint to large values can cause low performance or system crash !!");
            }
        }
        catch (Exception p) {
            // empty catch block
        }
        this.logger.log(Logger.CONFIG, "Agent " + this.getLocalName() + " - Max search result = " + this.maxResultLimit);
        StringBuffer sb = new StringBuffer("DF KB configuration:\n");
        DFKBFactory kbFactory = new DFKBFactory();
        if (kbFactClass != null) {
            try {
                Object o = JadeClassLoader.forName(kbFactClass).newInstance();
                if (o instanceof DFKBFactory) {
                    kbFactory = (DFKBFactory)o;
                    sb.append("- Factory class = " + kbFactClass);
                    sb.append('\n');
                } else {
                    this.logger.log(Logger.SEVERE, "Agent " + this.getLocalName() + " - The class " + kbFactClass + " is not a valid KB factory for the DF.");
                }
            }
            catch (Exception e) {
                this.logger.log(Logger.SEVERE, "Agent " + this.getLocalName() + " - Error loading class " + kbFactClass + ". " + e);
            }
        }
        boolean cleanTables = this.getBooleanProperty(sCleanTables, DB_CLEANTABLES);
        if (this.isRestarting()) {
            cleanTables = false;
        }
        boolean dbDefault = this.getBooleanProperty(sDBDefault, DB_DEFAULT);
        boolean dbAbortOnError = this.getBooleanProperty(sDBAbortOnError, DB_ABORTONERROR);
        if (dbDefault) {
            sb.append("- Type = persistent using internal HSQL database\n");
            try {
                this.agentDescriptions = kbFactory.getDFDBKB(this.maxResultLimit, null, null, null, null, cleanTables);
            }
            catch (Exception e) {
                this.logger.log(Logger.SEVERE, "Agent " + this.getLocalName() + " - Error creating persistent KB based on internal HSQLDB database", e);
                if (dbAbortOnError) {
                    this.doDelete();
                    return;
                }
                this.logger.log(Logger.WARNING, "Agent " + this.getLocalName() + " - Using volatile (in-memory) KB");
                sb = new StringBuffer("DF KB configuration:\n");
            }
        }
        if (this.agentDescriptions == null && dbUrl != null) {
            if (this.logger.isLoggable(Logger.CONFIG)) {
                sb.append("- Type = persistent\n");
                sb.append("- DB url = " + dbUrl);
                sb.append('\n');
                sb.append("- DB driver = " + dbDriver);
                sb.append('\n');
                sb.append("- DB username = " + dbUsername);
                sb.append('\n');
                sb.append("- DB password = " + dbPassword);
                sb.append('\n');
            }
            try {
                this.agentDescriptions = kbFactory.getDFDBKB(this.maxResultLimit, dbDriver, dbUrl, dbUsername, dbPassword, cleanTables);
            }
            catch (Exception e) {
                this.logger.log(Logger.SEVERE, "Agent " + this.getLocalName() + " - Error creating persistent KB (+url = " + this.getValue(dbUrl) + ", driver = " + this.getValue(dbDriver) + ", username = " + this.getValue(dbUsername) + ", password = " + this.getValue(dbPassword) + ")", e);
                if (dbAbortOnError) {
                    this.doDelete();
                    return;
                }
                this.logger.log(Logger.WARNING, "Agent " + this.getLocalName() + " - Using volatile (in-memory) KB");
                sb = new StringBuffer("DF KB configuration:\n");
            }
        }
        if (this.agentDescriptions == null) {
            sb.append("- Type = volatile\n");
            this.agentDescriptions = kbFactory.getDFMemKB(this.maxResultLimit);
            if (sPoolsize != null) {
                this.logger.log(Logger.WARNING, "Agent " + this.getLocalName() + " - Ignoring pool-size indication (" + sPoolsize + "). Parameter not supported when using volatile KB");
                sPoolsize = null;
            }
        }
        this.logger.log(Logger.CONFIG, sb.toString());
        this.subManager = new KBSubscriptionManager(this.agentDescriptions);
        this.subManager.setContentManager(this.getContentManager());
        this.getContentManager().registerLanguage(this.codec, "fipa-sl0");
        this.getContentManager().registerLanguage(this.codec, "fipa-sl1");
        this.getContentManager().registerLanguage(this.codec, "fipa-sl2");
        this.getContentManager().registerLanguage(this.codec, "fipa-sl");
        this.getContentManager().registerOntology(FIPAManagementOntology.getInstance());
        this.getContentManager().registerOntology(JADEManagementOntology.getInstance());
        this.getContentManager().registerOntology(DFAppletOntology.getInstance());
        boolean disableValidation = this.getBooleanProperty(sDisableValidation, DISABLE_VALIDATION);
        if (disableValidation) {
            this.getContentManager().setValidationMode(false);
        }
        MessageTemplate mt = MessageTemplate.MatchPerformative(16);
        MessageTemplate mt1 = null;
        mt1 = MessageTemplate.and(mt, MessageTemplate.MatchOntology(FIPAManagementOntology.getInstance().getName()));
        mt1 = MessageTemplate.and(mt1, MessageTemplate.not(MessageTemplate.MatchProtocol("iterated-fipa-request")));
        int poolSize = this.getIntegerProperty(sPoolsize, POOLSIZE);
        if (poolSize == 0) {
            DFFipaAgentManagementBehaviour fipaRequestResponder = new DFFipaAgentManagementBehaviour(this, mt1);
            this.addBehaviour(fipaRequestResponder);
        } else {
            this.logger.log(Logger.INFO, "Agent " + this.getLocalName() + " - FIPA request pool-size = " + poolSize);
            this.tbf = new ThreadedBehaviourFactory();
            for (int i = 0; i < poolSize; ++i) {
                DFFipaAgentManagementBehaviour fipaRequestResponder = new DFFipaAgentManagementBehaviour(this, mt1);
                fipaRequestResponder.setBehaviourName(this.getLocalName() + "#FIPAManagementResponder-" + i);
                this.addBehaviour(this.tbf.wrap(fipaRequestResponder));
            }
        }
        mt1 = MessageTemplate.and(mt, MessageTemplate.MatchOntology(FIPAManagementOntology.getInstance().getName()));
        mt1 = MessageTemplate.and(mt1, MessageTemplate.MatchProtocol("iterated-fipa-request"));
        DFIteratedSearchManagementBehaviour iteratedSearchResponder = new DFIteratedSearchManagementBehaviour(this, mt1);
        this.addBehaviour(iteratedSearchResponder);
        mt1 = MessageTemplate.and(mt, MessageTemplate.MatchOntology(JADEManagementOntology.getInstance().getName()));
        DFJadeAgentManagementBehaviour jadeRequestResponder = new DFJadeAgentManagementBehaviour(this, mt1);
        this.addBehaviour(jadeRequestResponder);
        mt1 = MessageTemplate.and(mt, MessageTemplate.MatchOntology(DFAppletOntology.getInstance().getName()));
        DFAppletManagementBehaviour appletRequestResponder = new DFAppletManagementBehaviour(this, mt1);
        this.addBehaviour(appletRequestResponder);
        mt1 = MessageTemplate.and(MessageTemplate.MatchOntology(FIPAManagementOntology.getInstance().getName()), MessageTemplate.or(MessageTemplate.MatchPerformative(19), MessageTemplate.MatchPerformative(2)));
        this.dfSubscriptionResponder = new SubscriptionResponder(this, mt1, this.subManager){

            @Override
            protected ACLMessage handleCancel(ACLMessage cancel) throws FailureException {
                try {
                    Action act = (Action)this.myAgent.getContentManager().extractContent(cancel);
                    ACLMessage subsMsg = (ACLMessage)((Object)act.getAction());
                    SubscriptionResponder.Subscription s = this.getSubscription(subsMsg);
                    if (s != null) {
                        this.mySubscriptionManager.deregister(s);
                        s.close();
                    }
                }
                catch (Exception e) {
                    if (df.this.logger.isLoggable(Logger.CONFIG)) {
                        df.this.logger.log(Logger.CONFIG, "Agent " + df.this.getLocalName() + " - Unknown CANCEL content. Use default handler");
                    }
                    super.handleCancel(cancel);
                }
                return null;
            }
        };
        this.addBehaviour(this.dfSubscriptionResponder);
        this.setDescriptionOfThisDF(this.getDefaultDescription());
        this.agentDescriptions.setSubscriptionResponder(this.dfSubscriptionResponder);
        this.agentDescriptions.setLeaseManager(new LeaseManager(){

            @Override
            public Date getLeaseTime(Object item) {
                return ((DFAgentDescription)item).getLeaseTime();
            }

            @Override
            public void setLeaseTime(Object item, Date lease) {
                ((DFAgentDescription)item).setLeaseTime(lease);
            }

            @Override
            public Object grantLeaseTime(Object item) {
                if (df.this.maxLeaseTime != null) {
                    Date lease = this.getLeaseTime(item);
                    long current = System.currentTimeMillis();
                    if (lease != null && lease.getTime() > current + df.this.maxLeaseTime.getTime() || lease == null && df.this.maxLeaseTime != null) {
                        this.setLeaseTime(item, new Date(current + df.this.maxLeaseTime.getTime()));
                    }
                }
                return item;
            }

            @Override
            public boolean isExpired(Date lease) {
                return lease != null && lease.getTime() <= System.currentTimeMillis();
            }
        });
        this.myDescription = this.getDefaultDescription();
        boolean autocleanup = this.getBooleanProperty(sAutocleanup, AUTOCLEANUP);
        if (autocleanup) {
            this.activateAutoCleanup();
        }
        Enumeration ss = this.agentDescriptions.getSubscriptions();
        while (ss.hasMoreElements()) {
            SubscriptionResponder.Subscription s = (SubscriptionResponder.Subscription)ss.nextElement();
            this.dfSubscriptionResponder.createSubscription(s.getMessage());
        }
    }

    protected void activateAutoCleanup() {
        this.logger.log(Logger.CONFIG, "Agent " + this.getLocalName() + " - Autocleanup activated");
        this.amsSubscriber = new AMSSubscriber(){

            @Override
            protected void installHandlers(Map handlersTable) {
                handlersTable.put("dead-agent", new AMSSubscriber.EventHandler(){

                    @Override
                    public void handle(Event ev) {
                        DeadAgent da = (DeadAgent)ev;
                        AID id = da.getAgent();
                        try {
                            DFAgentDescription dfd = new DFAgentDescription();
                            dfd.setName(id);
                            df.this.DFDeregister(dfd);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        df.this.unsubscribeAgent(id);
                    }
                });
            }
        };
        this.addBehaviour(this.amsSubscriber);
    }

    protected void unsubscribeAgent(AID id) {
        Vector ss = this.dfSubscriptionResponder.getSubscriptions(id);
        for (int i = 0; i < ss.size(); ++i) {
            try {
                this.subManager.deregister((SubscriptionResponder.Subscription)ss.elementAt(i));
                continue;
            }
            catch (Exception e) {
                this.logger.log(Logger.WARNING, "Agent " + this.getLocalName() + " - Error deregistering subscription of dead agent " + id.getName(), e);
            }
        }
    }

    private boolean getBooleanProperty(String sValue, String name) {
        boolean b = false;
        if (sValue != null) {
            try {
                b = Boolean.valueOf(sValue);
            }
            catch (Exception e) {
                this.logger.log(Logger.WARNING, "Agent " + this.getLocalName() + " - \"" + sValue + "\" is not a valid value for boolean parameter " + name, e);
            }
        }
        return b;
    }

    private int getIntegerProperty(String sValue, String name) {
        int n = 0;
        if (sValue != null) {
            try {
                n = Integer.parseInt(sValue);
            }
            catch (Exception e) {
                this.logger.log(Logger.WARNING, "Agent " + this.getLocalName() + " - \"" + sValue + "\" is not a valid value for integer parameter " + name, e);
            }
        }
        return n;
    }

    private String getValue(String s) {
        return s != null ? s : "null";
    }

    @Override
    protected void takeDown() {
        if (this.amsSubscriber != null) {
            this.send(this.amsSubscriber.getCancel());
        }
        if (this.tbf != null) {
            this.tbf.interrupt();
        }
        if (this.gui != null) {
            this.gui.disposeAsync();
        }
        DFAgentDescription dfd = new DFAgentDescription();
        dfd.setName(this.getAID());
        Iterator it = this.parents.iterator();
        while (it.hasNext()) {
            AID parentName = (AID)it.next();
            try {
                DFService.deregister(this, parentName, dfd);
            }
            catch (FIPAException fe) {
                fe.printStackTrace();
            }
        }
    }

    private void performRecursiveSearch(List localResults, DFAgentDescription dfd, SearchConstraints constraints, Search action) {
        int maxRes = this.getActualMaxResults(constraints);
        int maxDep = constraints.getMaxDepth().intValue();
        SearchConstraints newConstr = new SearchConstraints();
        newConstr.setMaxDepth(new Long(maxDep - 1));
        newConstr.setMaxResults(new Long(maxRes - localResults.size()));
        String searchId = constraints.getSearchId();
        if (searchId == null) {
            searchId = this.getName() + String.valueOf(this.searchIdCnt++) + System.currentTimeMillis();
            if (this.searchIdCnt >= 16) {
                this.searchIdCnt = 0;
            }
            this.searchIdCache.add(searchId);
        }
        newConstr.setSearchId(searchId);
        if (this.logger.isLoggable(Logger.CONFIG)) {
            this.logger.log(Logger.CONFIG, "Agent " + this.getLocalName() + " - Activating recursive search: " + localResults.size() + " item(s) found locally. " + maxRes + " expected. Search depth is " + maxDep + ". Search ID is " + searchId + ". Propagating search to " + this.children.size() + " federated DF(s)");
        }
        this.addBehaviour(new RecursiveSearchHandler(localResults, dfd, newConstr, action));
    }

    protected void DFRegister(DFAgentDescription dfd) throws AlreadyRegistered {
        Object old = this.agentDescriptions.register(dfd.getName(), dfd);
        if (old != null) {
            throw new AlreadyRegistered();
        }
        if (this.isADF(dfd)) {
            if (this.logger.isLoggable(Logger.INFO)) {
                this.logger.log(Logger.INFO, "Agent " + this.getLocalName() + " - Added federation " + dfd.getName().getName() + " --> " + this.getName());
            }
            this.children.add(dfd.getName());
            try {
                this.gui.addChildren(dfd.getName());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.subManager.handleChange(dfd, null);
        try {
            this.gui.addAgentDesc(dfd.getName());
            this.gui.showStatusMsg("Registration of agent: " + dfd.getName().getName() + " done.");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void DFDeregister(DFAgentDescription dfd) throws NotRegistered {
        Object old = this.agentDescriptions.deregister(dfd.getName());
        if (old == null) {
            throw new NotRegistered();
        }
        if (this.children.remove(dfd.getName())) {
            try {
                this.gui.removeChildren(dfd.getName());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        dfd.clearAllServices();
        this.subManager.handleChange(dfd, (DFAgentDescription)old);
        try {
            this.gui.removeAgentDesc(dfd.getName(), this.getAID());
            this.gui.showStatusMsg("Deregistration of agent: " + dfd.getName().getName() + " done.");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void DFModify(DFAgentDescription dfd) throws NotRegistered {
        Object old = this.agentDescriptions.register(dfd.getName(), dfd);
        if (old == null) {
            this.agentDescriptions.deregister(dfd.getName());
            throw new NotRegistered();
        }
        this.subManager.handleChange(dfd, (DFAgentDescription)old);
        try {
            this.gui.removeAgentDesc(dfd.getName(), this.getAID());
            this.gui.addAgentDesc(dfd.getName());
            this.gui.showStatusMsg("Modify of agent: " + dfd.getName().getName() + " done.");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected List DFSearch(DFAgentDescription dfd, int maxResults) {
        return this.agentDescriptions.search(dfd, maxResults);
    }

    protected KBIterator DFIteratedSearch(DFAgentDescription dfd) {
        return this.agentDescriptions.iterator(dfd);
    }

    protected void registerAction(Register r, AID requester) throws FIPAException {
        DFAgentDescription dfd = (DFAgentDescription)r.getDescription();
        DFService.checkIsValid(dfd, true);
        if (this.logger.isLoggable(Logger.CONFIG)) {
            this.logger.log(Logger.CONFIG, "Agent " + this.getLocalName() + " - Agent " + requester.getName() + " requesting action Register for " + dfd.getName());
        }
        if (dfd.getName().equals(this.getAID())) {
            throw new Unauthorised();
        }
        this.DFRegister(dfd);
    }

    protected void deregisterAction(Deregister d, AID requester) throws FIPAException {
        DFAgentDescription dfd = (DFAgentDescription)d.getDescription();
        DFService.checkIsValid(dfd, false);
        if (this.logger.isLoggable(Logger.CONFIG)) {
            this.logger.log(Logger.CONFIG, "Agent " + this.getLocalName() + " - Agent " + requester.getName() + " requesting action Deregister for " + dfd.getName());
        }
        this.DFDeregister(dfd);
    }

    protected void modifyAction(Modify m, AID requester) throws FIPAException {
        DFAgentDescription dfd = (DFAgentDescription)m.getDescription();
        DFService.checkIsValid(dfd, true);
        if (this.logger.isLoggable(Logger.CONFIG)) {
            this.logger.log(Logger.CONFIG, "Agent " + this.getLocalName() + " - Agent " + requester.getName() + " requesting action Modify for " + dfd.getName());
        }
        this.DFModify(dfd);
    }

    protected List searchAction(Search s, AID requester) throws FIPAException {
        DFAgentDescription dfd = (DFAgentDescription)s.getDescription();
        SearchConstraints constraints = s.getConstraints();
        List result = null;
        if (this.logger.isLoggable(Logger.CONFIG)) {
            this.logger.log(Logger.CONFIG, "Agent " + this.getLocalName() + " - Agent " + requester.getName() + " requesting action Search");
        }
        this.checkSearchId(constraints.getSearchId());
        int maxResult = this.getActualMaxResults(constraints);
        result = this.DFSearch(dfd, maxResult);
        if (result.size() < maxResult) {
            Long maxDepth = constraints.getMaxDepth();
            if (this.children.size() > 0 && maxDepth != null && maxDepth.intValue() > 0) {
                this.performRecursiveSearch(result, dfd, constraints, s);
                return null;
            }
        }
        return result;
    }

    protected KBIterator iteratedSearchAction(Search s, AID requester) throws FIPAException {
        DFAgentDescription dfd = (DFAgentDescription)s.getDescription();
        if (this.logger.isLoggable(Logger.CONFIG)) {
            this.logger.log(Logger.CONFIG, "Agent " + this.getLocalName() + " - Agent " + requester.getName() + " requesting action Iterated-Search");
        }
        return this.DFIteratedSearch(dfd);
    }

    void showGuiAction(ShowGui sg, AID requester) throws FailureException {
        if (this.logger.isLoggable(Logger.CONFIG)) {
            this.logger.log(Logger.CONFIG, "Agent " + this.getLocalName() + " - Agent " + requester.getName() + " requesting action ShowGui");
        }
        if (!this.showGui()) {
            throw new FailureException("Gui_is_being_shown_already");
        }
    }

    List getParentsAction(GetParents action, AID requester) {
        if (this.logger.isLoggable(Logger.CONFIG)) {
            this.logger.log(Logger.CONFIG, "Agent " + this.getLocalName() + " - Agent " + requester + " requesting action GetParents.");
        }
        return this.parents;
    }

    List getDescriptionAction(GetDescription action, AID requester) {
        if (this.logger.isLoggable(Logger.CONFIG)) {
            this.logger.log(Logger.CONFIG, "Agent " + this.getLocalName() + " - Agent " + requester + " requesting action GetDescription.");
        }
        ArrayList tmp = new ArrayList();
        tmp.add(this.getDescriptionOfThisDF());
        return tmp;
    }

    List getDescriptionUsedAction(GetDescriptionUsed action, AID requester) {
        AID parent = action.getParentDF();
        if (this.logger.isLoggable(Logger.CONFIG)) {
            this.logger.log(Logger.CONFIG, "Agent " + this.getLocalName() + " - Agent " + requester + " requesting action GetDescriptionUsed to federate with " + parent.getName());
        }
        ArrayList tmp = new ArrayList();
        tmp.add(this.getDescriptionOfThisDF(parent));
        return tmp;
    }

    void federateAction(final Federate action, AID requester) {
        AID remoteDF = action.getDf();
        if (this.logger.isLoggable(Logger.CONFIG)) {
            this.logger.log(Logger.CONFIG, "Agent " + this.getLocalName() + " - Agent " + requester + " requesting action Federate with DF " + remoteDF.getName());
        }
        Register r = new Register();
        DFAgentDescription tmp = action.getDescription();
        final DFAgentDescription dfd = tmp != null ? tmp : this.getDescriptionOfThisDF();
        r.setDescription(dfd);
        RemoteDFRequester b = new RemoteDFRequester(remoteDF, r){

            @Override
            public int onEnd() {
                Object result = this.getResult();
                if (!(result instanceof InternalError)) {
                    df.this.addParent(this.getRemoteDF(), dfd);
                }
                df.this.sendPendingNotification(action, result);
                return 0;
            }
        };
        this.addBehaviour(b);
    }

    void registerWithAction(final RegisterWith action, AID requester) {
        AID remoteDF = action.getDf();
        if (this.logger.isLoggable(Logger.CONFIG)) {
            this.logger.log(Logger.CONFIG, "Agent " + this.getLocalName() + " - Agent " + requester + " requesting action RegisterWith on DF " + remoteDF.getName());
        }
        Register r = new Register();
        final DFAgentDescription dfd = action.getDescription();
        r.setDescription(dfd);
        RemoteDFRequester b = new RemoteDFRequester(remoteDF, r){

            @Override
            public int onEnd() {
                Object result = this.getResult();
                if (!(result instanceof InternalError) && dfd.getName().equals(this.myAgent.getAID())) {
                    df.this.addParent(this.getRemoteDF(), dfd);
                }
                df.this.sendPendingNotification(action, result);
                return 0;
            }
        };
        this.addBehaviour(b);
    }

    void deregisterFromAction(final DeregisterFrom action, AID requester) {
        AID remoteDF = action.getDf();
        if (this.logger.isLoggable(Logger.CONFIG)) {
            this.logger.log(Logger.CONFIG, "Agent " + this.getLocalName() + " - Agent " + requester + " requesting action DeregisterFrom on DF " + remoteDF.getName());
        }
        Deregister d = new Deregister();
        final DFAgentDescription dfd = action.getDescription();
        d.setDescription(dfd);
        RemoteDFRequester b = new RemoteDFRequester(remoteDF, d){

            @Override
            public int onEnd() {
                Object result = this.getResult();
                if (!(result instanceof InternalError) && dfd.getName().equals(this.myAgent.getAID())) {
                    df.this.removeParent(this.getRemoteDF());
                }
                df.this.sendPendingNotification(action, result);
                return 0;
            }
        };
        this.addBehaviour(b);
    }

    void modifyOnAction(final ModifyOn action, AID requester) {
        AID remoteDF = action.getDf();
        if (this.logger.isLoggable(Logger.CONFIG)) {
            this.logger.log(Logger.CONFIG, "Agent " + this.getLocalName() + " - Agent " + requester + " requesting action ModifyOn on DF " + remoteDF.getName());
        }
        Modify m = new Modify();
        m.setDescription(action.getDescription());
        RemoteDFRequester b = new RemoteDFRequester(remoteDF, m){

            @Override
            public int onEnd() {
                df.this.sendPendingNotification(action, this.getResult());
                return 0;
            }
        };
        this.addBehaviour(b);
    }

    void searchOnAction(final SearchOn action, AID requester) {
        AID remoteDF = action.getDf();
        if (this.logger.isLoggable(Logger.CONFIG)) {
            this.logger.log(Logger.CONFIG, "Agent " + this.getLocalName() + " - Agent " + requester + " requesting action SearchOn on DF " + remoteDF.getName());
        }
        Search s = new Search();
        s.setDescription(action.getDescription());
        s.setConstraints(action.getConstraints());
        RemoteDFRequester b = new RemoteDFRequester(remoteDF, s){

            @Override
            public int onEnd() {
                df.this.sendPendingNotification(action, this.getResult());
                return 0;
            }
        };
        this.addBehaviour(b);
    }

    @Override
    protected void onGuiEvent(GuiEvent ev) {
        try {
            switch (ev.getType()) {
                case 0: {
                    this.gui.disposeAsync();
                    this.gui = null;
                    this.doDelete();
                    break;
                }
                case 1: {
                    this.gui.disposeAsync();
                    this.gui = null;
                    break;
                }
                case 1001: {
                    AID df2 = (AID)ev.getParameter(0);
                    final DFAgentDescription dfd = (DFAgentDescription)ev.getParameter(1);
                    DFService.checkIsValid(dfd, true);
                    if (this.getAID().equals(df2)) {
                        this.DFRegister(dfd);
                        break;
                    }
                    this.gui.showStatusMsg("Processing your request & waiting for result...");
                    Register r = new Register();
                    r.setDescription(dfd);
                    RemoteDFRequester b = new RemoteDFRequester(df2, r){

                        @Override
                        public int onEnd() {
                            Object result = this.getResult();
                            if (!(result instanceof InternalError)) {
                                df.this.gui.showStatusMsg("Registration request processed. Ready for new request");
                                if (dfd.getName().equals(this.myAgent.getAID())) {
                                    df.this.addParent(this.getRemoteDF(), dfd);
                                }
                            } else {
                                df.this.gui.showStatusMsg("Error processing request. " + ((InternalError)result).getMessage());
                            }
                            return 0;
                        }
                    };
                    this.addBehaviour(b);
                    break;
                }
                case 1002: {
                    AID df3 = (AID)ev.getParameter(0);
                    final DFAgentDescription dfd = (DFAgentDescription)ev.getParameter(1);
                    DFService.checkIsValid(dfd, false);
                    if (this.getAID().equals(df3)) {
                        this.DFDeregister(dfd);
                        break;
                    }
                    this.gui.showStatusMsg("Processing your request & waiting for result...");
                    Deregister d = new Deregister();
                    d.setDescription(dfd);
                    RemoteDFRequester b = new RemoteDFRequester(df3, d){

                        @Override
                        public int onEnd() {
                            Object result = this.getResult();
                            if (!(result instanceof InternalError)) {
                                df.this.gui.showStatusMsg("Deregistration request processed. Ready for new request");
                                if (dfd.getName().equals(this.myAgent.getAID())) {
                                    df.this.removeParent(this.getRemoteDF());
                                } else {
                                    df.this.gui.removeSearchResult(dfd.getName());
                                }
                            } else {
                                df.this.gui.showStatusMsg("Error processing request. " + ((InternalError)result).getMessage());
                            }
                            return 0;
                        }
                    };
                    this.addBehaviour(b);
                    break;
                }
                case 1003: {
                    AID df4 = (AID)ev.getParameter(0);
                    DFAgentDescription dfd = (DFAgentDescription)ev.getParameter(1);
                    DFService.checkIsValid(dfd, true);
                    if (this.getAID().equals(df4)) {
                        this.DFModify(dfd);
                        break;
                    }
                    this.gui.showStatusMsg("Processing your request & waiting for result...");
                    Modify m = new Modify();
                    m.setDescription(dfd);
                    RemoteDFRequester b = new RemoteDFRequester(df4, m){

                        @Override
                        public int onEnd() {
                            Object result = this.getResult();
                            if (!(result instanceof InternalError)) {
                                df.this.gui.showStatusMsg("Modification request processed. Ready for new request");
                            } else {
                                df.this.gui.showStatusMsg("Error processing request. " + ((InternalError)result).getMessage());
                            }
                            return 0;
                        }
                    };
                    this.addBehaviour(b);
                    break;
                }
                case 1004: {
                    AID df5 = (AID)ev.getParameter(0);
                    DFAgentDescription dfd = (DFAgentDescription)ev.getParameter(1);
                    SearchConstraints sc = (SearchConstraints)ev.getParameter(2);
                    this.gui.showStatusMsg("Processing your request & waiting for result...");
                    Search s = new Search();
                    s.setDescription(dfd);
                    s.setConstraints(sc);
                    RemoteDFRequester b = new RemoteDFRequester(df5, s){

                        @Override
                        public int onEnd() {
                            Object result = this.getResult();
                            if (!(result instanceof InternalError)) {
                                df.this.gui.showStatusMsg("Search request processed. Ready for new request");
                                df.this.gui.refreshLastSearchResults((List)result, this.getRemoteDF());
                            } else {
                                df.this.gui.showStatusMsg("Error processing request. " + ((InternalError)result).getMessage());
                            }
                            return 0;
                        }
                    };
                    this.addBehaviour(b);
                    break;
                }
                case 1005: {
                    AID df6 = (AID)ev.getParameter(0);
                    final DFAgentDescription dfd = (DFAgentDescription)ev.getParameter(1);
                    this.gui.showStatusMsg("Processing your request & waiting for result...");
                    Register r = new Register();
                    r.setDescription(dfd);
                    RemoteDFRequester b = new RemoteDFRequester(df6, r){

                        @Override
                        public int onEnd() {
                            Object result = this.getResult();
                            if (!(result instanceof InternalError)) {
                                df.this.gui.showStatusMsg("Federation request processed. Ready for new request");
                                df.this.addParent(this.getRemoteDF(), dfd);
                            } else {
                                df.this.gui.showStatusMsg("Error processing request. " + ((InternalError)result).getMessage());
                            }
                            return 0;
                        }
                    };
                    this.addBehaviour(b);
                    break;
                }
            }
        }
        catch (FIPAException fe) {
            this.gui.showStatusMsg("Error processing request. " + fe.getMessage());
            fe.printStackTrace();
        }
    }

    @Override
    public DFAgentDescription getDFAgentDsc(AID name) throws FIPAException {
        DFAgentDescription template = new DFAgentDescription();
        template.setName(name);
        List l = this.agentDescriptions.search(template, 1);
        if (l.isEmpty()) {
            return null;
        }
        return (DFAgentDescription)l.get(0);
    }

    @Override
    public DFAgentDescription getDescriptionOfThisDF() {
        return this.myDescription;
    }

    @Override
    public DFAgentDescription getDescriptionOfThisDF(AID parent) {
        return (DFAgentDescription)this.dscDFParentMap.get(parent);
    }

    protected boolean showGui() {
        if (this.gui == null) {
            try {
                Class<?> c = JadeClassLoader.forName("jade.tools.dfgui.DFGUI");
                this.gui = (DFGUIInterface)c.newInstance();
                this.gui.setAdapter(this);
                DFAgentDescription matchEverything = new DFAgentDescription();
                List agents = this.agentDescriptions.search(matchEverything, -1);
                ArrayList AIDList = new ArrayList();
                Iterator it = agents.iterator();
                while (it.hasNext()) {
                    AIDList.add(((DFAgentDescription)it.next()).getName());
                }
                this.gui.refresh(AIDList.iterator(), this.parents.iterator(), this.children.iterator());
                this.gui.setVisible(true);
                return true;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    private DFAgentDescription getDefaultDescription() {
        DFAgentDescription out = new DFAgentDescription();
        out.setName(this.getAID());
        out.addOntologies(FIPAManagementOntology.getInstance().getName());
        out.addLanguages("fipa-sl0");
        out.addProtocols("fipa-request");
        ServiceDescription sd = new ServiceDescription();
        sd.setName("df-service");
        sd.setType("fipa-df");
        sd.addOntologies(FIPAManagementOntology.getInstance().getName());
        sd.addLanguages("fipa-sl0");
        sd.addProtocols("fipa-request");
        try {
            sd.setOwnership(InetAddress.getLocalHost().getHostName());
        }
        catch (UnknownHostException uhe) {
            sd.setOwnership("unknown");
        }
        out.addServices(sd);
        return out;
    }

    protected void setDescriptionOfThisDF(DFAgentDescription dfd) {
        this.myDescription = dfd;
        this.myDescription.setName(this.getAID());
        if (!this.isADF(this.myDescription) && this.logger.isLoggable(Logger.WARNING)) {
            this.logger.log(Logger.WARNING, "Agent " + this.getLocalName() + " - The description set for this DF does not include a \"fipa-df\" service.");
        }
    }

    protected void addParent(AID dfName, DFAgentDescription dfd) {
        this.parents.add(dfName);
        if (this.gui != null) {
            this.gui.addParent(dfName);
        }
        this.dscDFParentMap.put(dfName, dfd);
    }

    protected void removeParent(AID dfName) {
        this.parents.remove(dfName);
        if (this.gui != null) {
            this.gui.removeParent(dfName);
        }
        this.dscDFParentMap.remove(dfName);
    }

    void storePendingRequest(Object key, ACLMessage request) {
        this.pendingRequests.put(key, request);
    }

    void removePendingRequest(Object key) {
        this.pendingRequests.remove(key);
    }

    private void sendPendingNotification(Concept action, Object result) {
        ACLMessage request = (ACLMessage)this.pendingRequests.remove(action);
        if (request != null) {
            ACLMessage notification = request.createReply();
            ContentElement ce = null;
            Action act = new Action(this.getAID(), action);
            if (result instanceof InternalError) {
                notification.setPerformative(6);
                ContentElementList cel = new ContentElementList();
                cel.add(act);
                cel.add((Predicate)result);
                ce = cel;
            } else {
                notification.setPerformative(7);
                ce = result != null ? new Result(act, result) : new Done(act);
            }
            try {
                this.getContentManager().fillContent(notification, ce);
                this.send(notification);
                AID receiver = (AID)notification.getAllReceiver().next();
                if (this.logger.isLoggable(Logger.FINE)) {
                    this.logger.log(Logger.FINE, "Agent " + this.getLocalName() + " - Notification sent back to " + receiver.getName());
                }
            }
            catch (Exception e) {
                if (this.logger.isLoggable(Logger.SEVERE)) {
                    this.logger.log(Logger.SEVERE, "Agent " + this.getLocalName() + " - Error encoding pending notification content.");
                }
                e.printStackTrace();
            }
        } else if (this.logger.isLoggable(Logger.WARNING)) {
            this.logger.log(Logger.WARNING, "Agent " + this.getLocalName() + " - Processed action request not found.");
        }
    }

    int getActualMaxResults(SearchConstraints constraints) {
        int maxResult = constraints.getMaxResults() == null ? 1 : constraints.getMaxResults().intValue();
        maxResult = maxResult < 0 || maxResult > this.maxResultLimit ? this.maxResultLimit : maxResult;
        return maxResult;
    }

    private void checkSearchId(String searchId) throws FIPAException {
        if (searchId != null) {
            if (this.searchIdCache.contains(searchId)) {
                throw new InternalError("search-id already served");
            }
            this.searchIdCache.add(searchId);
        }
    }

    private boolean isADF(DFAgentDescription dfd) {
        try {
            return ((ServiceDescription)dfd.getAllServices().next()).getType().equalsIgnoreCase("fipa-df");
        }
        catch (Exception e) {
            return false;
        }
    }

    private class RecursiveSearchHandler
    extends AchieveREInitiator {
        private static final long DEFAULTTIMEOUT = 300000L;
        private List results;
        private DFAgentDescription template;
        private SearchConstraints constraints;
        private Search action;
        private int maxExpectedResults;
        private int receivedResults;

        private RecursiveSearchHandler(List results, DFAgentDescription template, SearchConstraints constraints, Search action) {
            super(df.this, null);
            this.results = results;
            this.template = template;
            this.constraints = constraints;
            this.action = action;
            this.maxExpectedResults = constraints.getMaxResults().intValue();
            this.receivedResults = 0;
        }

        @Override
        protected Vector prepareRequests(ACLMessage request) {
            Vector<ACLMessage> requests = null;
            ACLMessage incomingRequest = (ACLMessage)df.this.pendingRequests.get(this.action);
            if (incomingRequest != null) {
                Date deadline = incomingRequest.getReplyByDate();
                if (deadline == null) {
                    deadline = new Date(System.currentTimeMillis() + 300000L);
                }
                requests = new Vector<ACLMessage>(df.this.children.size());
                Iterator it = df.this.children.iterator();
                while (it.hasNext()) {
                    AID childDF = (AID)it.next();
                    ACLMessage msg = DFService.createRequestMessage(this.myAgent, childDF, "search", this.template, this.constraints);
                    msg.setReplyByDate(deadline);
                    requests.addElement(msg);
                }
            }
            return requests;
        }

        @Override
        protected void handleInform(ACLMessage inform) {
            int cnt;
            block6: {
                if (df.this.logger.isLoggable(Logger.CONFIG)) {
                    df.this.logger.log(Logger.CONFIG, "Agent " + df.this.getLocalName() + " - Recursive search result received from " + inform.getSender().getName() + ".");
                }
                cnt = 0;
                if (this.receivedResults < this.maxExpectedResults) {
                    try {
                        DFAgentDescription[] dfds = DFService.decodeResult(inform.getContent());
                        for (int i = 0; i < dfds.length; ++i) {
                            if (!this.addResult(dfds[i])) continue;
                            ++this.receivedResults;
                            ++cnt;
                            if (this.receivedResults < this.maxExpectedResults) continue;
                            df.this.sendPendingNotification(this.action, this.results);
                        }
                    }
                    catch (Exception e) {
                        if (!df.this.logger.isLoggable(Logger.SEVERE)) break block6;
                        df.this.logger.log(Logger.SEVERE, "Agent " + df.this.getLocalName() + " - Error decoding reply from federated DF " + inform.getSender().getName() + " during recursive search [" + e.toString() + "].");
                    }
                }
            }
            if (df.this.logger.isLoggable(Logger.CONFIG)) {
                df.this.logger.log(Logger.CONFIG, "Agent " + df.this.getLocalName() + " - " + cnt + " new items found in recursive search.");
            }
        }

        @Override
        protected void handleRefuse(ACLMessage refuse) {
            if (df.this.logger.isLoggable(Logger.WARNING)) {
                df.this.logger.log(Logger.WARNING, "Agent " + df.this.getLocalName() + " - REFUSE received from federated DF " + refuse.getSender().getName() + " during recursive search.");
            }
        }

        @Override
        protected void handleFailure(ACLMessage failure) {
            if (df.this.logger.isLoggable(Logger.WARNING)) {
                df.this.logger.log(Logger.WARNING, "Agent " + df.this.getLocalName() + " - FAILURE received from federated DF " + failure.getSender().getName() + " during recursive search.");
            }
        }

        @Override
        protected void handleNotUnderstood(ACLMessage notUnderstood) {
            if (df.this.logger.isLoggable(Logger.WARNING)) {
                df.this.logger.log(Logger.WARNING, "Agent " + df.this.getLocalName() + " - NOT_UNDERSTOOD received from federated DF " + notUnderstood.getSender().getName() + " during recursive search.");
            }
        }

        @Override
        protected void handleOutOfSequence(ACLMessage msg) {
            if (df.this.logger.isLoggable(Logger.WARNING)) {
                df.this.logger.log(Logger.WARNING, "Agent " + df.this.getLocalName() + " - Out of sequence message " + ACLMessage.getPerformative(msg.getPerformative()) + " received from " + msg.getSender().getName() + " during recursive search.");
            }
        }

        @Override
        public int onEnd() {
            if (this.receivedResults < this.maxExpectedResults) {
                df.this.sendPendingNotification(this.action, this.results);
            }
            return super.onEnd();
        }

        private boolean addResult(DFAgentDescription newDfd) {
            Iterator it = this.results.iterator();
            while (it.hasNext()) {
                DFAgentDescription dfd = (DFAgentDescription)it.next();
                if (!dfd.getName().equals(newDfd.getName())) continue;
                return false;
            }
            this.results.add(newDfd);
            return true;
        }
    }
}

