/*
 * Decompiled with CFR 0.152.
 */
package jade.imtp.leap.JICP;

import jade.imtp.leap.JICP.JICPConnection;
import jade.imtp.leap.SSLHelper;
import jade.mtp.TransportAddress;
import jade.util.Logger;
import java.io.IOException;
import java.net.BindException;
import java.net.InetSocketAddress;
import java.net.Socket;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

public class JICPSConnection
extends JICPConnection {
    private static SSLSocketFactory scsf = null;
    protected static Logger myLogger = Logger.getMyLogger(JICPSConnection.class.getName());

    protected JICPSConnection() {
    }

    public JICPSConnection(TransportAddress ta) throws IOException {
        this(ta, false, 0, null, 0);
    }

    public JICPSConnection(TransportAddress ta, boolean useSSLAuth) throws IOException {
        this(ta, useSSLAuth, 0, null, 0);
    }

    public JICPSConnection(TransportAddress ta, boolean useSSLAuth, int timeout, String bindHost, int bindPort) throws IOException {
        if (useSSLAuth) {
            this.constructJICPSConnectionWithAuth(ta, timeout, bindHost, bindPort);
        } else {
            this.constructJICPSConnectionNoAuth(ta, timeout, bindHost, bindPort);
        }
    }

    private void constructJICPSConnectionNoAuth(TransportAddress ta, int timeout, String bindHost, int bindPort) throws IOException {
        myLogger.log(Logger.INFO, "Creating JICPSConnection with NO-AUTHENTICATION (only confidentiality).");
        if (scsf == null) {
            try {
                SSLContext ctx = SSLHelper.createContextNoAuth();
                scsf = ctx.getSocketFactory();
            }
            catch (Exception e) {
                throw new IOException("Error creating SSLSocketFactory. " + e.toString());
            }
        }
        int bindExceptionCnt = 0;
        while (true) {
            try {
                this.sc = scsf.createSocket();
                if (bindHost != null || bindPort > 0) {
                    myLogger.log(Logger.INFO, "Binding JICPSConnection with bindHost=" + bindHost + " and bindPort=" + bindPort);
                    if (bindHost != null) {
                        this.sc.bind(new InetSocketAddress(bindHost, bindPort));
                    } else {
                        this.sc.bind(new InetSocketAddress(bindPort));
                    }
                } else {
                    this.bindSocket(this.sc);
                }
                this.sc.connect(new InetSocketAddress(ta.getHost(), Integer.parseInt(ta.getPort())), timeout);
                ++socketCnt;
                ((SSLSocket)this.sc).setEnabledCipherSuites(SSLHelper.getSupportedKeys());
                this.sc.setTcpNoDelay(true);
                this.is = this.sc.getInputStream();
                this.os = this.getOutputStream();
            }
            catch (BindException be) {
                if (++bindExceptionCnt < 10) continue;
                myLogger.log(Logger.SEVERE, "Error binding JICPSConnection with bindHost=" + bindHost + " and bindPort=" + bindPort);
                throw be;
            }
            break;
        }
    }

    private void constructJICPSConnectionWithAuth(TransportAddress ta, int timeout, String bindHost, int bindPort) throws IOException {
        if (myLogger.isLoggable(Logger.FINE)) {
            myLogger.log(Logger.FINE, "Creating JICPSConnection with MUTUAL AUTHENTICATION.");
        }
        if (scsf == null) {
            try {
                SSLContext ctx = SSLHelper.createContextWithAuth();
                scsf = ctx.getSocketFactory();
            }
            catch (Exception e) {
                throw new IOException("Error creating SSLSocketFactory. " + e.toString());
            }
        }
        while (true) {
            try {
                this.sc = scsf.createSocket();
                if (bindHost != null || bindPort > 0) {
                    myLogger.log(Logger.INFO, "Binding JICPSConnection with bindHost=" + bindHost + " and bindPort=" + bindPort);
                    if (bindHost != null) {
                        this.sc.bind(new InetSocketAddress(bindHost, bindPort));
                    } else {
                        this.sc.bind(new InetSocketAddress(bindPort));
                    }
                } else {
                    this.bindSocket(this.sc);
                }
                this.sc.connect(new InetSocketAddress(ta.getHost(), Integer.parseInt(ta.getPort())), timeout);
                ++socketCnt;
                this.is = this.sc.getInputStream();
                this.os = this.getOutputStream();
            }
            catch (BindException bindException) {
                continue;
            }
            break;
        }
    }

    public JICPSConnection(Socket s) {
        super(s);
    }
}

