/*
 * Decompiled with CFR 0.152.
 */
package jade.imtp.leap.JICP;

import jade.core.Profile;
import jade.imtp.leap.ICP;
import jade.imtp.leap.ICPException;
import jade.imtp.leap.JICP.Connection;
import jade.imtp.leap.JICP.ConnectionFactory;
import jade.imtp.leap.JICP.JICPPeer;
import jade.imtp.leap.JICP.JICPSConnection;
import jade.imtp.leap.SSLHelper;
import jade.mtp.TransportAddress;
import jade.util.Logger;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;

public class JICPSPeer
extends JICPPeer {
    protected static Logger myLogger = Logger.getMyLogger(JICPSPeer.class.getName());
    private SSLContext ctx = null;
    private boolean useSSLAuth = false;

    @Override
    public TransportAddress activate(ICP.Listener l, String peerID, Profile p) throws ICPException {
        if (myLogger.isLoggable(Logger.FINE)) {
            myLogger.log(Logger.FINE, "About to activate JICP peer.");
        }
        this.ctx = SSLHelper.createContext();
        this.setUseSSLAuth(SSLHelper.needAuth());
        if (myLogger.isLoggable(Logger.FINE)) {
            myLogger.log(Logger.FINE, "activate() context created ctx=" + this.ctx);
        }
        TransportAddress ta = super.activate(l, peerID, p);
        if (myLogger.isLoggable(Logger.INFO)) {
            myLogger.log(Logger.INFO, "JICP Secure Peer activated. (auth=" + this.getUseSSLAuth() + ", ta=" + ta + ")");
        }
        return ta;
    }

    @Override
    public ConnectionFactory getConnectionFactory() {
        return new ConnectionFactory(){

            @Override
            public Connection createConnection(Socket s) {
                return new JICPSConnection(s);
            }

            @Override
            public Connection createConnection(TransportAddress ta) throws IOException {
                return new JICPSConnection(ta, JICPSPeer.this.getUseSSLAuth());
            }
        };
    }

    @Override
    protected ServerSocket getServerSocket(String host, int port, boolean changePortIfBusy) throws ICPException {
        ServerSocket sss = null;
        if (this.getUseSSLAuth()) {
            sss = this.getServerSocketWithAuth(host, port, changePortIfBusy);
            if (myLogger.isLoggable(Logger.FINE)) {
                myLogger.log(Logger.FINE, "Creating JICPSPeer with mutual Authentication.");
            }
        } else {
            sss = this.getServerSocketNoAuth(host, port, changePortIfBusy);
            if (myLogger.isLoggable(Logger.WARNING)) {
                myLogger.log(Logger.WARNING, "Creating JICPSPeer with NO-AUTHENTICATION (only confidentiality).");
            }
        }
        return sss;
    }

    private ServerSocket getServerSocketWithAuth(String host, int port, boolean changePortIfBusy) throws ICPException {
        SSLServerSocket sss;
        block9: {
            if (this.ctx == null) {
                this.ctx = SSLHelper.createContextWithAuth();
            }
            sss = null;
            try {
                SSLServerSocketFactory serverSocketFactory = this.ctx.getServerSocketFactory();
                try {
                    sss = (SSLServerSocket)serverSocketFactory.createServerSocket(port);
                }
                catch (IOException ioe) {
                    if (changePortIfBusy) {
                        try {
                            sss = (SSLServerSocket)serverSocketFactory.createServerSocket(0);
                            break block9;
                        }
                        catch (IOException ioe2) {
                            throw new ICPException("Problems initializing server socket. No free port found.", ioe2);
                        }
                    }
                    throw new ICPException("I/O error opening server socket on port " + port, ioe);
                }
            }
            catch (Exception e) {
                throw new ICPException("Error creating SSLServerSocketFactory.", e);
            }
        }
        if (myLogger.isLoggable(Logger.FINE)) {
            myLogger.log(Logger.FINE, JICPSPeer.getChiperDebugString(sss));
        }
        return sss;
    }

    private static String getChiperDebugString(SSLServerSocket sss) {
        StringBuffer sb = new StringBuffer();
        sb.append("\n--EnabledProtocols:\n");
        String[] prot = sss.getEnabledProtocols();
        for (int i = 0; i < prot.length; ++i) {
            sb.append("  " + prot[i]);
        }
        sb.append("\n--EnabledCipherSuites:\n");
        String[] suite = sss.getEnabledCipherSuites();
        for (int i = 0; i < suite.length; ++i) {
            sb.append("  " + suite[i]);
        }
        sb.append("\n--SupportedCipherSuites\n");
        String[] supported_suite = sss.getSupportedCipherSuites();
        for (int i = 0; i < supported_suite.length; ++i) {
            sb.append("  " + supported_suite[i]);
        }
        sb.append("\n--\n");
        return sb.toString();
    }

    private ServerSocket getServerSocketNoAuth(String host, int port, boolean changePortIfBusy) throws ICPException {
        SSLServerSocket sss;
        block10: {
            if (this.ctx == null) {
                this.ctx = SSLHelper.createContextNoAuth();
            }
            sss = null;
            try {
                SSLServerSocketFactory ssf = this.ctx.getServerSocketFactory();
                try {
                    sss = (SSLServerSocket)ssf.createServerSocket(port);
                }
                catch (IOException ioe) {
                    if (changePortIfBusy) {
                        try {
                            sss = (SSLServerSocket)ssf.createServerSocket(0);
                            break block10;
                        }
                        catch (IOException ioe2) {
                            throw new ICPException("Problems initializing server socket. No free port found.", ioe2);
                        }
                    }
                    throw new ICPException("I/O error opening server socket on port " + port, ioe);
                }
            }
            catch (Exception e) {
                throw new ICPException("Error creating SSLServerSocketFactory.", e);
            }
        }
        try {
            sss.setEnabledCipherSuites(new String[]{"SSL_DH_anon_WITH_RC4_128_MD5"});
            String[] e = sss.getEnabledCipherSuites();
        }
        catch (Exception e) {
            throw new ICPException("Error enabling cypher suites.", e);
        }
        return sss;
    }

    private boolean getUseSSLAuth() {
        return this.useSSLAuth;
    }

    private void setUseSSLAuth(boolean b) {
        this.useSSLAuth = b;
    }
}

