/*
 * Decompiled with CFR 0.152.
 */
package jade.imtp.leap.http;

import jade.mtp.TransportAddress;

public class HTTPAddress
implements TransportAddress {
    private String host;
    private String port;
    private String file;
    private String anchor;

    public HTTPAddress(String host, String port, String file, String anchor) {
        this.host = host;
        this.port = port != null ? port : String.valueOf(80);
        this.file = file;
        this.anchor = anchor;
    }

    @Override
    public String getProto() {
        return "http";
    }

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public String getPort() {
        return this.port;
    }

    @Override
    public String getFile() {
        return this.file;
    }

    @Override
    public String getAnchor() {
        return this.anchor;
    }

    public String toString() {
        StringBuffer address = new StringBuffer();
        address.append(this.getProto());
        address.append("://");
        address.append(this.host);
        if (this.port != null) {
            address.append(":");
            address.append(this.port);
        }
        if (this.file != null) {
            address.append("/");
            address.append(this.file);
        }
        if (this.anchor != null) {
            address.append("#");
            address.append(this.anchor);
        }
        return address.toString();
    }
}

