/*
 * Decompiled with CFR 0.152.
 */
package jade.imtp.leap.nio;

import jade.imtp.leap.ICPException;
import jade.imtp.leap.nio.NIOJICPConnection;
import jade.imtp.leap.nio.SSLEngineHelper;
import java.io.IOException;
import java.nio.channels.SocketChannel;
import java.util.logging.Level;
import java.util.logging.Logger;

public class NIOJICPSConnection
extends NIOJICPConnection {
    private SSLEngineHelper helper = null;
    private static Logger log = Logger.getLogger(NIOJICPSConnection.class.getName());

    @Override
    void init(SocketChannel channel) throws ICPException {
        super.init(channel);
        if (log.isLoggable(Level.FINE)) {
            log.fine("initialize ssl tooling");
        }
        this.helper = new SSLEngineHelper(this.getRemoteHost(), channel.socket().getPort(), this);
        this.addBufferTransformer(this.helper);
    }

    @Override
    public void close() throws IOException {
        try {
            this.helper.close();
        }
        catch (IOException iOException) {
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Unexpected error closing SSLHelper.", e);
        }
        super.close();
    }

    public String toString() {
        return super.toString() + "-CH=" + this.getChannel() + "-SSLEH=" + this.helper;
    }
}

