/*
 * Decompiled with CFR 0.152.
 */
package jade.tools.logging.gui;

import jade.content.onto.basic.Action;
import jade.content.onto.basic.Result;
import jade.core.AID;
import jade.core.Agent;
import jade.domain.FIPAException;
import jade.domain.FIPAService;
import jade.gui.AclGui;
import jade.lang.acl.ACLMessage;
import jade.tools.logging.LogManager;
import jade.tools.logging.gui.LogManagerGUI;
import jade.tools.logging.gui.SetLoggingSystemAction;
import jade.tools.logging.ontology.GetAllLoggers;
import jade.tools.logging.ontology.LevelInfo;
import jade.tools.logging.ontology.LogManagementOntology;
import jade.tools.logging.ontology.LoggerInfo;
import jade.tools.logging.ontology.SetFile;
import jade.tools.logging.ontology.SetLevel;
import jade.util.leap.ArrayList;
import jade.util.leap.Iterator;
import jade.util.leap.List;
import java.awt.Component;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.DefaultCellEditor;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class ContainerLogWindow
extends JInternalFrame
implements InternalFrameListener {
    private static final int NAME_COLUMN = 0;
    private static final int LEVEL_COLUMN = 1;
    private static final int HANDLERS_COLUMN = 2;
    private static final int FILE_COLUMN = 3;
    private Agent myAgent;
    private String containerName;
    private AID controller;
    private LogManagerGUI mainGui;
    private LogManager myLogManager;
    private LogTable myTable;
    private JComboBox levelCombo;
    private JTextField loggingSystemTF;
    private AbstractAction setLoggingSystemAction = new SetLoggingSystemAction(this);

    public ContainerLogWindow(Agent a, String containerName, AID controller, LogManager logManager, LogManagerGUI gui) throws FIPAException {
        super(containerName);
        this.myAgent = a;
        this.containerName = containerName;
        this.controller = controller;
        this.myLogManager = logManager;
        this.mainGui = gui;
        this.setClosable(false);
        this.setIconifiable(true);
        this.setMaximizable(true);
        this.setResizable(true);
        JToolBar bar = new JToolBar();
        JButton button = null;
        URL url = null;
        button = new JButton();
        button.setToolTipText("Set logging system");
        button.setAction(this.setLoggingSystemAction);
        url = this.getClass().getClassLoader().getResource("jade/gui/images/tick_blue.gif");
        button.setIcon(new ImageIcon(url));
        button.setText(null);
        bar.add(button);
        bar.addSeparator();
        bar.add(new JLabel("Logging system:"));
        bar.addSeparator();
        this.loggingSystemTF = new JTextField(64);
        this.loggingSystemTF.setText(this.myLogManager.getName());
        this.loggingSystemTF.setEditable(false);
        bar.add(this.loggingSystemTF);
        this.getContentPane().add((Component)bar, "North");
        List infos = this.retrieveLogInfo();
        this.myTable = new LogTable(infos);
        JTable table = new JTable(this.myTable);
        this.getContentPane().add((Component)new JScrollPane(table), "Center");
        this.levelCombo = new JComboBox();
        List levels = this.myLogManager.getLogLevels();
        for (int i = 0; i < levels.size(); ++i) {
            LevelInfo l = (LevelInfo)levels.get(i);
            this.levelCombo.addItem(l.getName());
        }
        DefaultCellEditor levelEditor = new DefaultCellEditor(this.levelCombo);
        TableColumnModel columnModel = table.getColumnModel();
        TableColumn setLevelColumn = columnModel.getColumn(1);
        setLevelColumn.setCellEditor(levelEditor);
    }

    public String getContainerName() {
        return this.containerName;
    }

    public AID getController() {
        return this.controller;
    }

    private List retrieveLogInfo() throws FIPAException {
        List tmp = null;
        tmp = this.controller != null ? this.remoteRetrieveLogInfo(this.controller) : this.myLogManager.getAllLogInfo();
        ArrayList infos = new ArrayList(tmp.size());
        Iterator it = tmp.iterator();
        while (it.hasNext()) {
            int i;
            LoggerInfo li = (LoggerInfo)it.next();
            String name = li.toString();
            for (i = 0; i < infos.size() && name.compareTo(infos.get(i).toString()) >= 0; ++i) {
            }
            infos.add(i, li);
        }
        return infos;
    }

    private void setLogLevel(String name, int level) throws FIPAException {
        if (this.controller != null) {
            this.remoteSetLogLevel(this.controller, name, level);
        } else {
            this.myLogManager.setLogLevel(name, level);
        }
    }

    private void setLogFile(String name, String fileName) throws FIPAException {
        if (this.controller != null) {
            this.remoteSetLogFile(this.controller, name, fileName);
        } else {
            this.myLogManager.setFile(name, fileName);
        }
    }

    @Override
    public void internalFrameActivated(InternalFrameEvent e) {
        this.moveToFront();
    }

    @Override
    public void internalFrameDeactivated(InternalFrameEvent e) {
    }

    @Override
    public void internalFrameClosed(InternalFrameEvent e) {
    }

    @Override
    public void internalFrameClosing(InternalFrameEvent e) {
    }

    @Override
    public void internalFrameIconified(InternalFrameEvent e) {
    }

    @Override
    public void internalFrameDeiconified(InternalFrameEvent e) {
    }

    @Override
    public void internalFrameOpened(InternalFrameEvent e) {
    }

    private String getLevelName(int n) {
        List l = this.myLogManager.getLogLevels();
        Iterator it = l.iterator();
        while (it.hasNext()) {
            LevelInfo li = (LevelInfo)it.next();
            if (n != li.getValue()) continue;
            return li.getName();
        }
        return "UNKNOWN";
    }

    private int getLevelValue(String name) {
        List l = this.myLogManager.getLogLevels();
        Iterator it = l.iterator();
        while (it.hasNext()) {
            LevelInfo li = (LevelInfo)it.next();
            if (!name.equals(li.getName())) continue;
            return li.getValue();
        }
        return 0;
    }

    void setLoggingSystem() {
        LogManager lm = this.mainGui.initializeLogManager();
        if (lm != null) {
            LogManager old = this.myLogManager;
            this.myLogManager = lm;
            try {
                List infos = this.retrieveLogInfo();
                this.loggingSystemTF.setText(this.myLogManager.getName());
                this.myTable.refresh(infos);
            }
            catch (FIPAException fe) {
                int res = JOptionPane.showConfirmDialog(this, "Cannot retrieve logging information from container " + this.containerName + "\nWould you like to see the message?", "WARNING", 0);
                if (res == 0) {
                    AclGui.showMsgInDialog(fe.getACLMessage(), this.mainGui);
                }
                this.myLogManager = old;
            }
        }
    }

    private ACLMessage createHelperRequest(AID helper) {
        ACLMessage request = new ACLMessage(16);
        request.addReceiver(helper);
        request.setProtocol("fipa-request");
        request.setLanguage("fipa-sl");
        request.setOntology(LogManagementOntology.getInstance().getName());
        return request;
    }

    private List remoteRetrieveLogInfo(AID helper) throws FIPAException {
        ACLMessage request = this.createHelperRequest(helper);
        GetAllLoggers gal = new GetAllLoggers(this.myLogManager.getClass().getName(), null);
        Action act = new Action();
        act.setActor(helper);
        act.setAction(gal);
        try {
            this.myAgent.getContentManager().fillContent(request, act);
            ACLMessage inform = FIPAService.doFipaRequestClient(this.myAgent, request, 10000L);
            if (inform != null) {
                Result res = (Result)this.myAgent.getContentManager().extractContent(inform);
                return res.getItems();
            }
            throw new FIPAException("Response timeout expired");
        }
        catch (FIPAException fe) {
            throw fe;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new FIPAException(e.getMessage());
        }
    }

    private void remoteSetLogLevel(AID helper, String name, int level) throws FIPAException {
        ACLMessage request = this.createHelperRequest(helper);
        SetLevel sl = new SetLevel(name, level);
        Action act = new Action();
        act.setActor(helper);
        act.setAction(sl);
        try {
            this.myAgent.getContentManager().fillContent(request, act);
            ACLMessage inform = FIPAService.doFipaRequestClient(this.myAgent, request, 10000L);
            if (inform == null) {
                throw new FIPAException("Response timeout expired");
            }
        }
        catch (FIPAException fe) {
            throw fe;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new FIPAException(e.getMessage());
        }
    }

    private void remoteSetLogFile(AID helper, String name, String file) throws FIPAException {
        ACLMessage request = this.createHelperRequest(helper);
        SetFile sf = new SetFile(name, file);
        Action act = new Action();
        act.setActor(helper);
        act.setAction(sf);
        try {
            this.myAgent.getContentManager().fillContent(request, act);
            ACLMessage inform = FIPAService.doFipaRequestClient(this.myAgent, request, 10000L);
            if (inform == null) {
                throw new FIPAException("Response timeout expired");
            }
        }
        catch (FIPAException fe) {
            throw fe;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new FIPAException(e.getMessage());
        }
    }

    private class LogTable
    extends AbstractTableModel {
        private List logInfos;

        public LogTable(List infos) {
            this.logInfos = infos;
        }

        public void refresh(List infos) {
            this.logInfos = infos;
            ContainerLogWindow.this.validate();
        }

        @Override
        public int getRowCount() {
            return this.logInfos.size();
        }

        @Override
        public int getColumnCount() {
            return 4;
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return column == 1 || column == 3;
        }

        @Override
        public Object getValueAt(int row, int column) {
            LoggerInfo info = (LoggerInfo)this.logInfos.get(row);
            switch (column) {
                case 0: {
                    return info.getName();
                }
                case 1: {
                    return ContainerLogWindow.this.getLevelName(info.getLevel());
                }
                case 2: {
                    StringBuffer sb = new StringBuffer();
                    List l = info.getHandlers();
                    if (l != null) {
                        Iterator it = l.iterator();
                        while (it.hasNext()) {
                            sb.append(it.next());
                            if (!it.hasNext()) continue;
                            sb.append(", ");
                        }
                    }
                    return sb.toString();
                }
                case 3: {
                    return info.getFile();
                }
            }
            return null;
        }

        @Override
        public void setValueAt(Object value, int row, int column) {
            block5: {
                LoggerInfo info = (LoggerInfo)this.logInfos.get(row);
                try {
                    if (column == 1) {
                        int level = ContainerLogWindow.this.getLevelValue((String)value);
                        ContainerLogWindow.this.setLogLevel(info.getName(), level);
                        info.setLevel(level);
                    } else if (column == 3) {
                        ContainerLogWindow.this.setLogFile(info.getName(), (String)value);
                        info.setFile((String)value);
                    }
                }
                catch (FIPAException fe) {
                    int res = JOptionPane.showConfirmDialog(ContainerLogWindow.this.mainGui, "Cannot set " + this.getColumnName(column) + " to logger " + info.getName() + " in container " + ContainerLogWindow.this.containerName + "\nWould you like to see the message?", "WARNING", 0);
                    if (res != 0) break block5;
                    AclGui.showMsgInDialog(fe.getACLMessage(), ContainerLogWindow.this.mainGui);
                }
            }
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return "Logger Name";
                }
                case 1: {
                    return "Level";
                }
                case 2: {
                    return "Handlers";
                }
                case 3: {
                    return "Log file";
                }
            }
            return null;
        }
    }
}

