/*
 * Decompiled with CFR 0.152.
 */
package jade.util;

import java.util.Properties;

public class Toolkit {
    public static final String DELIM_START = "{";
    public static final String DELIM_STOP = "}";
    public static final int MISSING_PARAM_POLICY_REMOVE = 0;
    public static final int MISSING_PARAM_POLICY_LEAVE = 1;
    public static final int MISSING_PARAM_POLICY_FAIL = 2;

    public static String substituteParameters(String expression, Properties parameters) {
        return Toolkit.substituteParameters(expression, parameters, DELIM_START, DELIM_STOP);
    }

    public static String substituteParameters(String expression, Properties parameters, String startDelim, String stopDelim) {
        return Toolkit.substituteParameters(expression, parameters, startDelim, stopDelim, 0);
    }

    public static String substituteParameters(String expression, Properties parameters, String startDelim, String stopDelim, int missingParamPolicy) {
        if (expression == null || parameters == null || parameters.isEmpty()) {
            return expression;
        }
        StringBuffer sbuf = new StringBuffer();
        int position = 0;
        while (true) {
            int paramEnd;
            int paramStart;
            if ((paramStart = expression.indexOf(startDelim, position)) == -1) {
                if (position == 0) {
                    return expression;
                }
                sbuf.append(expression.substring(position, expression.length()));
                return sbuf.toString();
            }
            sbuf.append(expression.substring(position, paramStart));
            int openDelimCount = 0;
            for (paramEnd = paramStart + 1; paramEnd < expression.length(); ++paramEnd) {
                String ch = Character.toString(expression.charAt(paramEnd));
                if (ch.equals(stopDelim)) {
                    if (openDelimCount == 0) break;
                    --openDelimCount;
                    continue;
                }
                if (!ch.equals(startDelim)) continue;
                ++openDelimCount;
            }
            if (paramEnd >= expression.length()) {
                throw new IllegalArgumentException('\"' + expression + "\" has no closing brace. Opening brace at position " + paramStart + '.');
            }
            String key = expression.substring(paramStart + startDelim.length(), paramEnd);
            String replacement = parameters.getProperty(key = Toolkit.substituteParameters(key, parameters, startDelim, stopDelim, missingParamPolicy), null);
            if (replacement != null) {
                String recursiveReplacement = Toolkit.substituteParameters(replacement, parameters, startDelim, stopDelim, missingParamPolicy);
                sbuf.append(recursiveReplacement);
            } else if (missingParamPolicy == 1) {
                sbuf.append(startDelim).append(key).append(stopDelim);
            } else if (missingParamPolicy == 2) {
                throw new IllegalArgumentException("Missing substitution parameter " + key + " found at position " + paramStart + '.');
            }
            position = paramEnd + stopDelim.length();
        }
    }

    public static void main(String[] args) {
        String s = "Hello {x}...{y{d}}...{z} World";
        Properties pp = new Properties();
        pp.setProperty("x", "ciao");
        String s1 = Toolkit.substituteParameters(s, pp, DELIM_START, DELIM_STOP, 0);
        System.out.println(s1);
        String s2 = Toolkit.substituteParameters(s, pp, DELIM_START, DELIM_STOP, 1);
        System.out.println(s2);
    }
}

