/*
 * Decompiled with CFR 0.152.
 */
package jade.content.abs;

import jade.content.abs.AbsObject;
import jade.content.abs.AbsTerm;
import java.util.Date;

public class AbsPrimitive
implements AbsTerm {
    private Object value = null;
    private String typeName = null;

    private AbsPrimitive(String typeName, Object value) {
        this.typeName = typeName;
        this.value = value;
    }

    public AbsPrimitive(String typeName) {
        this(typeName, null);
    }

    public static AbsPrimitive wrap(String value) {
        AbsPrimitive ret = null;
        if (value != null) {
            ret = new AbsPrimitive("BO_String", value);
        }
        return ret;
    }

    public static AbsPrimitive wrap(boolean value) {
        AbsPrimitive ret = new AbsPrimitive("BO_Boolean", new Boolean(value));
        return ret;
    }

    public static AbsPrimitive wrap(int value) {
        AbsPrimitive ret = new AbsPrimitive("BO_Integer", new Integer(value));
        return ret;
    }

    public static AbsPrimitive wrap(long value) {
        AbsPrimitive ret = new AbsPrimitive("BO_Integer", new Long(value));
        return ret;
    }

    public static AbsPrimitive wrap(float value) {
        AbsPrimitive ret = new AbsPrimitive("BO_Float", new Float(value));
        return ret;
    }

    public static AbsPrimitive wrap(double value) {
        AbsPrimitive ret = new AbsPrimitive("BO_Float", new Double(value));
        return ret;
    }

    public static AbsPrimitive wrap(Date value) {
        AbsPrimitive ret = null;
        if (value != null) {
            ret = new AbsPrimitive("BO_Date", value);
        }
        return ret;
    }

    public static AbsPrimitive wrap(byte[] value) {
        AbsPrimitive ret = null;
        if (value != null) {
            ret = new AbsPrimitive("BO_Byte-sequence", value);
        }
        return ret;
    }

    public void set(String value) {
        if (!this.getTypeName().equals("BO_String")) {
            throw new IllegalArgumentException("Wrong type");
        }
        this.value = value;
    }

    public void set(boolean value) {
        if (!this.getTypeName().equals("BO_Boolean")) {
            throw new IllegalArgumentException("Wrong type");
        }
        this.value = new Boolean(value);
    }

    public void set(int value) {
        if (!this.getTypeName().equals("BO_Integer")) {
            throw new IllegalArgumentException("Wrong type");
        }
        this.value = new Integer(value);
    }

    public void set(long value) {
        if (!this.getTypeName().equals("BO_Integer")) {
            throw new IllegalArgumentException("Wrong type");
        }
        this.value = new Long(value);
    }

    public void set(float value) {
        if (!this.getTypeName().equals("BO_Float")) {
            throw new IllegalArgumentException("Wrong type");
        }
        this.value = new Float(value);
    }

    public void set(double value) {
        if (!this.getTypeName().equals("BO_Float")) {
            throw new IllegalArgumentException("Wrong type");
        }
        this.value = new Double(value);
    }

    public void set(Date value) {
        if (!this.getTypeName().equals("BO_Date")) {
            throw new IllegalArgumentException("Wrong type");
        }
        this.value = value;
    }

    public void set(byte[] value) {
        if (!this.getTypeName().equals("BO_Byte-sequence")) {
            throw new IllegalArgumentException("Wrong type");
        }
        this.value = value;
    }

    public String getString() {
        return (String)this.value;
    }

    public boolean getBoolean() {
        return (Boolean)this.value;
    }

    public int getInteger() {
        try {
            return (Integer)this.value;
        }
        catch (ClassCastException cce) {
            return (int)((Long)this.value).longValue();
        }
    }

    public long getLong() {
        try {
            return (Long)this.value;
        }
        catch (ClassCastException cce) {
            return ((Integer)this.value).intValue();
        }
    }

    public float getFloat() {
        try {
            return ((Float)this.value).floatValue();
        }
        catch (ClassCastException cce) {
            return (float)((Double)this.value).doubleValue();
        }
    }

    public double getDouble() {
        try {
            return (Double)this.value;
        }
        catch (ClassCastException cce) {
            return ((Float)this.value).floatValue();
        }
    }

    public Date getDate() {
        return (Date)this.value;
    }

    public byte[] getByteSequence() {
        return (byte[])this.value;
    }

    public Object getObject() {
        return this.value;
    }

    @Override
    public String getTypeName() {
        return this.typeName;
    }

    @Override
    public AbsObject getAbsObject(String name) {
        return null;
    }

    @Override
    public String[] getNames() {
        return null;
    }

    @Override
    public boolean isGrounded() {
        return true;
    }

    @Override
    public int getCount() {
        return 0;
    }

    public String toString() {
        return this.value.toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof AbsPrimitive) {
            return this.getObject().equals(((AbsPrimitive)obj).getObject());
        }
        return false;
    }

    public int hashCode() {
        return this.getObject().hashCode();
    }

    @Override
    public int getAbsType() {
        return 4;
    }
}

