/*
 * Decompiled with CFR 0.152.
 */
package jade.content.lang.xml;

import jade.content.abs.AbsContentElement;
import jade.content.abs.AbsObject;
import jade.content.lang.Codec;
import jade.content.lang.StringCodec;
import jade.content.lang.xml.XMLDecoder;
import jade.content.lang.xml.XMLEncoder;
import jade.content.onto.Ontology;
import jade.content.onto.OntologyException;
import java.text.StringCharacterIterator;
import java.util.HashMap;
import java.util.Map;

public class XMLCodec
extends StringCodec {
    private static final long serialVersionUID = -711663402273632423L;
    public static final String NAME = "XML";
    public static final String PRIMITIVE_TAG = "primitive";
    public static final String VALUE_ATTR = "value";
    public static final String TYPE_ATTR = "type";
    public static final String AGGREGATE_ATTR = "aggregate";
    public static final String AGGREGATE_TYPE_ATTR = "aggregate-type";
    public static final String BINARY_STARTER = "#";
    private boolean preserveJavaTypes;
    static final String STRING = "STRING";
    static final String INTEGER = "INTEGER";
    static final String BOOLEAN = "BOOLEAN";
    static final String DATE = "DATE";
    static final String BYTE_SEQUENCE = "BYTE_SEQUENCE";
    static final String FLOAT = "FLOAT";
    private static Map<String, String> primitiveTypeNames = new HashMap<String, String>();

    static String getPrimitiveTypeName(String basicOntoPrimitiveTypeName) {
        return primitiveTypeNames.get(basicOntoPrimitiveTypeName);
    }

    public XMLCodec() {
        this(true);
    }

    public XMLCodec(boolean preserveJavaTypes) {
        super(NAME);
        this.preserveJavaTypes = preserveJavaTypes;
    }

    @Override
    public String encode(AbsContentElement content) throws Codec.CodecException {
        throw new Codec.CodecException("Not supported");
    }

    @Override
    public String encode(Ontology ontology, AbsContentElement content) throws Codec.CodecException {
        try {
            return this.encodeAbsObject(ontology, content, false);
        }
        catch (OntologyException oe) {
            throw new Codec.CodecException("Ontology error", oe);
        }
    }

    public String encodeAbsObject(Ontology ontology, AbsObject abs, boolean indent) throws Codec.CodecException, OntologyException {
        XMLEncoder encoder = new XMLEncoder();
        StringBuffer sb = new StringBuffer();
        encoder.init(ontology, sb, this.preserveJavaTypes);
        encoder.setIndentEnabled(indent);
        encoder.encode(abs);
        return sb.toString();
    }

    public String encodeObject(Ontology ontology, Object obj, boolean indent) throws Codec.CodecException, OntologyException {
        AbsObject abs = ontology.fromObject(obj);
        return this.encodeAbsObject(ontology, abs, indent);
    }

    @Override
    public AbsContentElement decode(String content) throws Codec.CodecException {
        throw new Codec.CodecException("Not supported");
    }

    @Override
    public AbsContentElement decode(Ontology ontology, String content) throws Codec.CodecException {
        try {
            AbsObject abs = this.decodeAbsObject(ontology, content);
            if (abs instanceof AbsContentElement) {
                return (AbsContentElement)abs;
            }
            throw new Codec.CodecException(abs.getTypeName() + " is not a content element");
        }
        catch (OntologyException oe) {
            throw new Codec.CodecException("Ontology error", oe);
        }
    }

    public AbsObject decodeAbsObject(Ontology ontology, String xml) throws Codec.CodecException, OntologyException {
        XMLDecoder decoder = new XMLDecoder();
        decoder.init(ontology, this.preserveJavaTypes);
        return decoder.decode(xml);
    }

    public Object decodeObject(Ontology ontology, String xml) throws Codec.CodecException, OntologyException {
        AbsObject abs = this.decodeAbsObject(ontology, xml);
        return ontology.toObject(abs);
    }

    static String toXML(String javaText) {
        StringBuilder result = new StringBuilder();
        StringCharacterIterator iterator = new StringCharacterIterator(javaText);
        char character = iterator.current();
        while (character != '\uffff') {
            if (character == '<') {
                result.append("&lt;");
            } else if (character == '>') {
                result.append("&gt;");
            } else if (character == '\"') {
                result.append("&quot;");
            } else if (character == '\'') {
                result.append("&#039;");
            } else if (character == '&') {
                result.append("&amp;");
            } else if (character == '\n') {
                result.append("&#010;");
            } else if (character == '\r') {
                result.append("&#013;");
            } else {
                result.append(character);
            }
            character = iterator.next();
        }
        return result.toString();
    }

    static String fromXML(String xmlText) {
        xmlText = xmlText.replace("&lt;", "<");
        xmlText = xmlText.replace("&gt;", ">");
        xmlText = xmlText.replace("&quot;", "\"");
        xmlText = xmlText.replace("&#039;", "'");
        xmlText = xmlText.replace("&amp;", "&");
        xmlText = xmlText.replace("&#010;", "\n");
        xmlText = xmlText.replace("&#013;", "\r");
        return xmlText;
    }

    static {
        primitiveTypeNames.put("BO_String", STRING);
        primitiveTypeNames.put("BO_Integer", INTEGER);
        primitiveTypeNames.put("BO_Boolean", BOOLEAN);
        primitiveTypeNames.put("BO_Date", DATE);
        primitiveTypeNames.put("BO_Byte-sequence", BYTE_SEQUENCE);
        primitiveTypeNames.put("BO_Float", FLOAT);
    }
}

