/*
 * Decompiled with CFR 0.152.
 */
package jade.content.lang.xml;

import jade.content.abs.AbsAggregate;
import jade.content.abs.AbsContentElementList;
import jade.content.abs.AbsObject;
import jade.content.abs.AbsPrimitive;
import jade.content.abs.AbsPrimitiveSlotsHolder;
import jade.content.lang.Codec;
import jade.content.lang.xml.XMLCodec;
import jade.content.onto.BasicOntology;
import jade.content.onto.Ontology;
import jade.content.onto.OntologyException;
import jade.content.schema.AggregateSchema;
import jade.content.schema.ObjectSchema;
import jade.lang.acl.ISO8601;
import jade.util.leap.ArrayList;
import jade.util.leap.HashMap;
import jade.util.leap.Iterator;
import jade.util.leap.List;
import jade.util.leap.Map;
import java.util.Date;
import org.apache.commons.codec.binary.Base64;

class XMLEncoder {
    private static final char OPEN_ANG = '<';
    private static final char CLOSE_ANG = '>';
    private Ontology ontology;
    private StringBuffer buffer;
    private boolean indentEnabled = false;
    private int tabs = 0;
    private boolean preserveJavaTypes;

    XMLEncoder() {
    }

    public void init(Ontology onto, StringBuffer sb, boolean preserveJavaTypes) {
        this.ontology = onto;
        this.buffer = sb;
        this.preserveJavaTypes = preserveJavaTypes;
    }

    public void setIndentEnabled(boolean b) {
        this.indentEnabled = b;
    }

    public void encode(AbsObject abs) throws Codec.CodecException, OntologyException {
        if (abs != null) {
            if (this.isAggregate(abs)) {
                this.encodeAggregate((AbsAggregate)abs);
            } else if (this.isFrame(abs)) {
                this.encodeFrame((AbsPrimitiveSlotsHolder)abs);
            } else if (this.isPrimitive(abs)) {
                this.encodePrimitive((AbsPrimitive)abs);
            } else if (this.isContentElementList(abs)) {
                this.encodeContentElementList((AbsContentElementList)abs);
            } else {
                throw new Codec.CodecException("Unsupported Abstract decsriptor type " + abs);
            }
        }
    }

    private boolean isAggregate(AbsObject abs) {
        return abs instanceof AbsAggregate;
    }

    private boolean isFrame(AbsObject abs) {
        return abs instanceof AbsPrimitiveSlotsHolder;
    }

    private boolean isPrimitive(AbsObject abs) {
        return abs instanceof AbsPrimitive;
    }

    private boolean isContentElementList(AbsObject abs) {
        return abs instanceof AbsContentElementList;
    }

    private void encodeAggregate(AbsAggregate abs) throws Codec.CodecException, OntologyException {
        for (int i = 0; i < abs.size(); ++i) {
            this.encode(abs.get(i));
        }
    }

    private void encodeContentElementList(AbsContentElementList abs) throws Codec.CodecException, OntologyException {
        this.encodeOpenTag(abs.getTypeName(), null);
        ++this.tabs;
        for (int i = 0; i < abs.size(); ++i) {
            this.encode(abs.get(i));
        }
        --this.tabs;
        this.encodeCloseTag(abs.getTypeName());
    }

    private void encodeFrame(AbsPrimitiveSlotsHolder abs) throws Codec.CodecException, OntologyException {
        ObjectSchema schema = this.ontology.getSchema(abs.getTypeName());
        if (schema != null) {
            boolean encodeByOrder = schema.getEncodingByOrder();
            String name = abs.getTypeName();
            this.insertIndent();
            this.buffer.append('<');
            this.buffer.append(name);
            List tagSlotNames = this.encodeAttributes(abs, schema);
            if (tagSlotNames.isEmpty()) {
                this.buffer.append('/');
                this.buffer.append('>');
                this.insertNewline();
            } else {
                this.buffer.append('>');
                this.insertNewline();
                ++this.tabs;
                for (int i = 0; i < tagSlotNames.size(); ++i) {
                    String slotName = (String)tagSlotNames.get(i);
                    AbsObject slot = abs.getAbsObject(slotName);
                    if (slot == null) continue;
                    if (slot instanceof AbsPrimitive) {
                        this.encodeString(slotName, ((AbsPrimitive)slot).getString());
                        continue;
                    }
                    boolean closeSlotNameTag = false;
                    if (slot instanceof AbsAggregate) {
                        HashMap aggregateModifyingAttributes = new HashMap();
                        ObjectSchema slotSchema = schema.getSchema(slotName);
                        if (!(slotSchema instanceof AggregateSchema)) {
                            aggregateModifyingAttributes.put("aggregate", "true");
                            if (!slot.getTypeName().equals("sequence")) {
                                aggregateModifyingAttributes.put("aggregate-type", slot.getTypeName());
                            }
                        }
                        this.encodeOpenTag(slotName, aggregateModifyingAttributes);
                        closeSlotNameTag = true;
                        ++this.tabs;
                    } else if (!encodeByOrder) {
                        this.encodeOpenTag(slotName, null);
                        closeSlotNameTag = true;
                        ++this.tabs;
                    }
                    this.encode(slot);
                    if (!closeSlotNameTag) continue;
                    --this.tabs;
                    this.encodeCloseTag(slotName);
                }
                --this.tabs;
                this.encodeCloseTag(name);
            }
        } else {
            throw new OntologyException("No schema found for type " + abs.getTypeName());
        }
    }

    private List encodeAttributes(AbsPrimitiveSlotsHolder abs, ObjectSchema schema) throws Codec.CodecException {
        ArrayList tagSlotNames = new ArrayList();
        try {
            String[] slotNames = schema.getNames();
            for (int i = 0; i < slotNames.length; ++i) {
                String slotName = slotNames[i];
                AbsObject slot = abs.getAbsObject(slotName);
                if (slot != null && slot instanceof AbsPrimitive) {
                    Object obj = ((AbsPrimitive)slot).getObject();
                    if (obj instanceof String && schema.getSchema(slotName) != BasicOntology.getInstance().getSchema("BO_String")) {
                        tagSlotNames.add(slotName);
                        continue;
                    }
                    this.buffer.append(' ');
                    this.buffer.append(slotName);
                    this.buffer.append('=');
                    this.buffer.append('\"');
                    this.buffer.append(this.getPrimitiveValue((AbsPrimitive)slot));
                    this.buffer.append('\"');
                    continue;
                }
                tagSlotNames.add(slotName);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return tagSlotNames;
    }

    private void encodePrimitive(AbsPrimitive abs) throws Codec.CodecException {
        this.insertIndent();
        this.buffer.append('<');
        this.buffer.append("primitive");
        this.buffer.append(' ');
        this.buffer.append("type");
        this.buffer.append('=');
        this.buffer.append('\"');
        this.buffer.append(XMLCodec.getPrimitiveTypeName(abs.getTypeName()));
        this.buffer.append('\"');
        this.buffer.append(' ');
        this.buffer.append("value");
        this.buffer.append('=');
        this.buffer.append('\"');
        this.buffer.append(this.getPrimitiveValue(abs));
        this.buffer.append('\"');
        this.buffer.append("/");
        this.buffer.append('>');
        this.insertNewline();
    }

    private void encodeString(String slotName, String slotValue) {
        this.insertIndent();
        this.buffer.append('<');
        this.buffer.append(slotName);
        this.buffer.append('>');
        this.buffer.append(XMLCodec.toXML(slotValue));
        this.buffer.append('<');
        this.buffer.append('/');
        this.buffer.append(slotName);
        this.buffer.append('>');
        this.insertNewline();
    }

    private void encodeOpenTag(String name, Map attrs) {
        this.insertIndent();
        this.buffer.append('<');
        this.buffer.append(name);
        if (attrs != null) {
            Iterator it = attrs.keySet().iterator();
            while (it.hasNext()) {
                String attrName = (String)it.next();
                this.buffer.append(' ');
                this.buffer.append(attrName);
                this.buffer.append("=\"");
                this.buffer.append(attrs.get(attrName));
                this.buffer.append("\"");
            }
        }
        this.buffer.append('>');
        this.insertNewline();
    }

    private void encodeCloseTag(String name) {
        this.insertIndent();
        this.buffer.append('<');
        this.buffer.append('/');
        this.buffer.append(name);
        this.buffer.append('>');
        this.insertNewline();
    }

    private String getPrimitiveValue(AbsPrimitive abs) throws Codec.CodecException {
        Object obj = abs.getObject();
        if (obj instanceof Date) {
            return ISO8601.toString((Date)obj);
        }
        if (this.preserveJavaTypes && obj instanceof Long) {
            return obj.toString() + 'L';
        }
        if (this.preserveJavaTypes && obj instanceof Float) {
            return obj.toString() + 'F';
        }
        if (obj instanceof byte[]) {
            try {
                String base64Str = new String(Base64.encodeBase64((byte[])((byte[])obj)), "US-ASCII");
                StringBuffer sb = new StringBuffer("#");
                sb.append(base64Str);
                return sb.toString();
            }
            catch (Exception e) {
                throw new Codec.CodecException("Error encoding binary value. ", e);
            }
        }
        if (obj instanceof String) {
            return XMLCodec.toXML((String)obj);
        }
        return obj.toString();
    }

    private void insertNewline() {
        if (this.indentEnabled) {
            this.buffer.append('\n');
        }
    }

    private void insertIndent() {
        if (this.indentEnabled) {
            for (int i = 0; i < this.tabs; ++i) {
                this.buffer.append('\t');
            }
        }
    }
}

