/*
 * Decompiled with CFR 0.152.
 */
package jade.content.lang.xml;

import jade.content.ContentException;
import jade.content.lang.xml.XMLCodec;
import jade.content.onto.BasicOntology;
import jade.content.onto.BeanOntology;
import jade.content.onto.Introspector;
import jade.content.onto.Ontology;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;

public class XMLManager {
    private BeanOntology myOntology;
    private Ontology[] superOntologies;
    private XMLCodec codec = new XMLCodec();

    public XMLManager() {
        this.superOntologies = new Ontology[2];
        this.superOntologies[0] = new Ontology("placeholder", (Introspector)null);
        this.superOntologies[1] = BasicOntology.getInstance();
        this.myOntology = new BeanOntology("dummy", this.superOntologies);
    }

    public XMLManager(String packageName) throws ContentException {
        this();
        this.myOntology.add(packageName);
    }

    public XMLManager(Ontology onto) {
        this();
        this.superOntologies[0] = onto;
    }

    public void add(String packageName) throws ContentException {
        this.myOntology.add(packageName);
    }

    public void add(Class<?> c) throws ContentException {
        this.myOntology.add(c);
    }

    public Ontology getOntology() {
        return this.myOntology;
    }

    public Object decode(String xml) throws ContentException {
        return this.codec.decodeObject(this.myOntology, xml);
    }

    public Object decode(File xmlFile) throws ContentException, IOException {
        return this.codec.decodeObject(this.myOntology, XMLManager.getFileContent(xmlFile));
    }

    public Object decode(InputStream xmlStream) throws ContentException, IOException {
        return this.codec.decodeObject(this.myOntology, XMLManager.getStreamContent(xmlStream));
    }

    public String encode(Object obj) throws ContentException {
        return this.codec.encodeObject(this.myOntology, obj, true);
    }

    public void encodeToFile(Object obj, File output) throws ContentException, IOException {
        String xml = this.codec.encodeObject(this.myOntology, obj, true);
        XMLManager.setFileContents(output, xml);
    }

    private static String getFileContent(File file) throws FileNotFoundException, IOException {
        return XMLManager.getReaderContent(new FileReader(file));
    }

    private static String getStreamContent(InputStream str) throws FileNotFoundException, IOException {
        return XMLManager.getReaderContent(new InputStreamReader(str));
    }

    private static String getReaderContent(Reader r) throws IOException {
        StringBuffer contents = new StringBuffer();
        String lineSeparator = System.getProperty("line.separator");
        BufferedReader input = null;
        input = new BufferedReader(r);
        String line = null;
        while ((line = input.readLine()) != null) {
            contents.append(line);
            contents.append(lineSeparator);
        }
        if (input != null) {
            input.close();
        }
        return contents.toString();
    }

    private static void setFileContents(File file, String contents) throws FileNotFoundException, IOException {
        if (file == null) {
            throw new IllegalArgumentException("File should not be null.");
        }
        if (!file.exists()) {
            file.createNewFile();
        }
        if (!file.isFile()) {
            throw new IllegalArgumentException("Should not be a directory: " + file);
        }
        if (!file.canWrite()) {
            throw new IllegalArgumentException("File cannot be written: " + file);
        }
        try (Writer output = null;){
            output = new BufferedWriter(new FileWriter(file));
            output.write(contents);
        }
    }
}

