/*
 * Decompiled with CFR 0.152.
 */
package jade.content.onto;

import jade.JadeClassLoader;
import jade.content.Concept;
import jade.util.Logger;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

class ClassDiscover {
    private static Logger myLogger = Logger.getMyLogger(ClassDiscover.class.getName());

    ClassDiscover() {
    }

    static List<Class<?>> getClassesForPackage(String pkgname) throws ClassNotFoundException {
        ArrayList classes = new ArrayList();
        ArrayList<File> directories = new ArrayList<File>();
        try {
            ClassLoader cld = Thread.currentThread().getContextClassLoader();
            if (cld == null) {
                throw new ClassNotFoundException("Can't get class loader.");
            }
            Enumeration<URL> resources = cld.getResources(pkgname.replace('.', '/'));
            while (resources.hasMoreElements()) {
                URL res = resources.nextElement();
                if (res.getProtocol().equalsIgnoreCase("jar")) {
                    JarURLConnection conn = (JarURLConnection)res.openConnection();
                    JarFile jar = conn.getJarFile();
                    for (JarEntry e : Collections.list(jar.entries())) {
                        if (!e.getName().startsWith(pkgname.replace('.', '/')) || !e.getName().endsWith(".class") || e.getName().contains("$")) continue;
                        String className = e.getName().replace("/", ".").substring(0, e.getName().length() - 6);
                        myLogger.log(Logger.CONFIG, "Adding class " + className);
                        classes.add(JadeClassLoader.forName(className));
                    }
                    continue;
                }
                directories.add(new File(URLDecoder.decode(res.getPath(), "UTF-8")));
            }
        }
        catch (NullPointerException x) {
            throw new ClassNotFoundException(pkgname + " does not appear to be a valid package (Null pointer exception)");
        }
        catch (UnsupportedEncodingException encex) {
            throw new ClassNotFoundException(pkgname + " does not appear to be a valid package (Unsupported encoding)");
        }
        catch (IOException ioex) {
            throw new ClassNotFoundException("IOException was thrown when trying to get all resources for " + pkgname);
        }
        for (File directory : directories) {
            if (directory.exists()) {
                String[] files;
                for (String file : files = directory.list()) {
                    if (!file.endsWith(".class")) continue;
                    classes.add(JadeClassLoader.forName(pkgname + '.' + file.substring(0, file.length() - 6)));
                }
                continue;
            }
            throw new ClassNotFoundException(pkgname + " (" + directory.getPath() + ") does not appear to be a valid package");
        }
        return classes;
    }

    static List<Class<?>> getClassessOfInterface(String thePackage, Class<Concept> theInterface) throws ClassNotFoundException {
        ArrayList classList = new ArrayList();
        for (Class<?> discovered : ClassDiscover.getClassesForPackage(thePackage)) {
            if (!Arrays.asList(discovered.getInterfaces()).contains(theInterface)) continue;
            classList.add(discovered);
        }
        return classList;
    }
}

