/*
 * Decompiled with CFR 0.152.
 */
package jade.core;

import jade.core.CaseInsensitiveString;
import jade.core.Location;
import jade.mtp.TransportAddress;

public class ContainerID
implements Location {
    public static final String DEFAULT_IMTP = "JADE-IMTP";
    private String name;
    private String protocol = "JADE-IMTP";
    private String address = "<Unknown Host>";
    private String port;
    private Boolean main;

    public ContainerID() {
    }

    public ContainerID(String n, TransportAddress a) {
        this.name = n;
        if (a != null) {
            this.address = a.getHost();
            this.port = a.getPort();
            this.protocol = a.getProto();
        }
    }

    public void setName(String n) {
        this.name = n;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setProtocol(String p) {
        this.protocol = p;
    }

    @Override
    public String getProtocol() {
        return this.protocol;
    }

    public void setAddress(String a) {
        this.address = a;
    }

    @Override
    public String getAddress() {
        return this.address;
    }

    public String getPort() {
        return this.port;
    }

    public void setPort(String port) {
        this.port = port;
    }

    @Override
    public String getID() {
        return this.name + '@' + this.address;
    }

    public String toString() {
        return this.getID();
    }

    public boolean equals(Object obj) {
        try {
            ContainerID cid = (ContainerID)obj;
            return CaseInsensitiveString.equalsIgnoreCase(this.name, cid.getName());
        }
        catch (ClassCastException cce) {
            return false;
        }
    }

    public int hashCode() {
        return this.name.toLowerCase().hashCode();
    }

    public void setMain(Boolean main) {
        this.main = main;
    }

    public Boolean getMain() {
        return this.main;
    }
}

