/*
 * Decompiled with CFR 0.152.
 */
package jade.core.messaging;

import jade.JadeClassLoader;
import jade.core.AID;
import jade.core.AgentContainer;
import jade.core.BaseService;
import jade.core.Filter;
import jade.core.HorizontalCommand;
import jade.core.IMTPException;
import jade.core.Node;
import jade.core.Profile;
import jade.core.ProfileException;
import jade.core.Service;
import jade.core.ServiceException;
import jade.core.ServiceFinder;
import jade.core.VerticalCommand;
import jade.core.messaging.GenericMessage;
import jade.core.messaging.MessageManager;
import jade.core.messaging.PersistentDeliveryFilter;
import jade.core.messaging.PersistentDeliveryManager;
import jade.core.messaging.PersistentDeliverySlice;
import jade.domain.FIPAAgentManagement.Envelope;
import jade.lang.acl.ACLMessage;
import jade.util.Logger;
import java.io.IOException;
import java.util.ArrayList;

public class PersistentDeliveryService
extends BaseService {
    public static final String PERSISTENT_DELIVERY_FILTER = "persistent-delivery-filter";
    public static final String PERSISTENT_DELIVERY_STORAGENODES = "persistent-delivery-storagenodes";
    public static final String PERSISTENT_DELIVERY_SENDFAILUREPERIOD = "persistent-delivery-sendfailureperiod";
    public static final String PERSISTENT_DELIVERY_STORAGEMETHOD = "persistent-delivery-storagemethod";
    public static final String PERSISTENT_DELIVERY_BASEDIR = "persistent-delivery-basedir";
    static final String ACL_USERDEF_DUE_DATE = "JADE-persistentdelivery-duedate";
    private AgentContainer myContainer;
    private ServiceFinder myServiceFinder;
    private PersistentDeliveryManager myManager;
    private final ServiceComponent localSlice = new ServiceComponent();
    private final CommandOutgoingFilter outFilter = new CommandOutgoingFilter();
    private final CommandIncomingFilter inFilter = new CommandIncomingFilter();
    private PersistentDeliveryFilter messageFilter;
    private String[] storageEnabledSliceNames;

    @Override
    public void init(AgentContainer ac, Profile p) throws ProfileException {
        super.init(ac, p);
        this.myContainer = ac;
        this.myServiceFinder = this.myContainer.getServiceFinder();
    }

    @Override
    public String getName() {
        return "jade.core.messaging.PersistentDelivery";
    }

    @Override
    public Class<?> getHorizontalInterface() {
        try {
            return JadeClassLoader.forName("jade.core.messaging.PersistentDeliverySlice");
        }
        catch (ClassNotFoundException cnfe) {
            return null;
        }
    }

    @Override
    public Service.Slice getLocalSlice() {
        return this.localSlice;
    }

    @Override
    public Filter getCommandFilter(boolean direction) {
        if (!direction) {
            return this.inFilter;
        }
        return this.outFilter;
    }

    @Override
    public void boot(Profile myProfile) throws ServiceException {
        try {
            MessageManager.Channel ch;
            String str = myProfile.getParameter(PERSISTENT_DELIVERY_STORAGENODES, null);
            if (str != null) {
                this.storageEnabledSliceNames = str.split(";");
                this.myLogger.log(Logger.CONFIG, "Persistent-Delivery - Storage enabled nodes: " + str);
            }
            if ((ch = (MessageManager.Channel)((Object)this.myServiceFinder.findService("jade.core.messaging.Messaging"))) == null) {
                throw new ServiceException("Can't locate delivery channel");
            }
            this.myManager = PersistentDeliveryManager.instance(myProfile, ch);
            this.myManager.start();
        }
        catch (IMTPException imtpe) {
            imtpe.printStackTrace();
            throw new ServiceException("Cannot retrieve the delivery channel", imtpe);
        }
        try {
            String className = myProfile.getParameter(PERSISTENT_DELIVERY_FILTER, null);
            if (className != null) {
                Class<?> c = JadeClassLoader.forName(className);
                this.messageFilter = (PersistentDeliveryFilter)c.newInstance();
                this.myLogger.log(Logger.INFO, "Persistent-Delivery - Using message filter of type " + this.messageFilter.getClass().getName());
            }
        }
        catch (Exception e) {
            throw new ServiceException("Exception in message filter initialization", e);
        }
    }

    private void flushMessages(final AID target) {
        Thread t = new Thread(){

            @Override
            public void run() {
                try {
                    Service.Slice[] slices = PersistentDeliveryService.this.getStorageEnabledSlices();
                    String sliceName = null;
                    for (int i = 0; i < slices.length; ++i) {
                        PersistentDeliverySlice slice = (PersistentDeliverySlice)slices[i];
                        try {
                            sliceName = slice.getNode().getName();
                            slice.flushMessages(target);
                            continue;
                        }
                        catch (Exception e) {
                            PersistentDeliveryService.this.myLogger.log(Logger.WARNING, "Persistent-Delivery - Error trying to flush messages for agent " + target.getName() + " on node " + sliceName);
                        }
                    }
                }
                catch (ServiceException se) {
                    PersistentDeliveryService.this.myLogger.log(Logger.WARNING, "Persistent-Delivery - Error retrieving storage-enabled slices to flush persisted messages for agent " + target.getName());
                }
            }
        };
        t.start();
    }

    private Service.Slice[] getStorageEnabledSlices() throws ServiceException {
        if (this.storageEnabledSliceNames != null) {
            ArrayList<Service.Slice> ss = new ArrayList<Service.Slice>(this.storageEnabledSliceNames.length);
            for (int i = 0; i < this.storageEnabledSliceNames.length; ++i) {
                try {
                    Service.Slice s = this.getSlice(this.storageEnabledSliceNames[i]);
                    ss.add(s);
                    continue;
                }
                catch (ServiceException serviceException) {
                    // empty catch block
                }
            }
            return ss.toArray(new Service.Slice[0]);
        }
        return this.getAllSlices();
    }

    private class ServiceComponent
    implements Service.Slice {
        private ServiceComponent() {
        }

        @Override
        public Service getService() {
            return PersistentDeliveryService.this;
        }

        @Override
        public Node getNode() throws ServiceException {
            try {
                return PersistentDeliveryService.this.getLocalNode();
            }
            catch (IMTPException imtpe) {
                throw new ServiceException("Problem in contacting the IMTP Manager", imtpe);
            }
        }

        @Override
        public VerticalCommand serve(HorizontalCommand cmd) {
            VerticalCommand result = null;
            try {
                String cmdName = cmd.getName();
                Object[] params = cmd.getParams();
                if (cmdName.equals("5")) {
                    String storeName = (String)params[0];
                    ACLMessage acl = (ACLMessage)params[1];
                    Envelope env = (Envelope)params[2];
                    byte[] payload = (byte[])params[3];
                    Boolean foreignRecv = (Boolean)params[4];
                    String traceId = (String)params[5];
                    GenericMessage msg = new GenericMessage();
                    msg.update(acl, env, payload);
                    msg.setTraceID(traceId);
                    msg.setForeignReceiver(foreignRecv);
                    AID receiver = (AID)params[6];
                    boolean stored = this.storeMessage(storeName, msg, receiver);
                    cmd.setReturnValue(new Boolean(stored));
                } else if (cmdName.equals("6")) {
                    AID receiver = (AID)params[0];
                    this.flushMessages(receiver);
                }
            }
            catch (Throwable t) {
                cmd.setReturnValue(t);
            }
            return result;
        }

        private boolean storeMessage(String storeName, GenericMessage msg, AID receiver) throws IMTPException, ServiceException {
            if (PersistentDeliveryService.this.messageFilter != null) {
                long dueDate;
                long now;
                boolean firstTime;
                block10: {
                    firstTime = false;
                    dueDate = now = System.currentTimeMillis();
                    try {
                        String dd = msg.getACLMessage().getUserDefinedParameter(PersistentDeliveryService.ACL_USERDEF_DUE_DATE);
                        dueDate = Long.parseLong(dd);
                    }
                    catch (Exception e) {
                        long delay = PersistentDeliveryService.this.messageFilter.delayBeforeExpiration(msg.getACLMessage());
                        if (delay == 0L) break block10;
                        dueDate = delay == -1L ? delay : now + delay;
                        msg.getACLMessage().addUserDefinedParameter(PersistentDeliveryService.ACL_USERDEF_DUE_DATE, String.valueOf(dueDate));
                        firstTime = true;
                    }
                }
                if (dueDate > now || dueDate == -1L) {
                    try {
                        if (firstTime) {
                            if (PersistentDeliveryService.this.myLogger.isLoggable(Logger.INFO)) {
                                PersistentDeliveryService.this.myLogger.log(Logger.INFO, "Persistent-Delivery - Storing message\n" + MessageManager.stringify(msg) + " for agent " + receiver.getName() + "\nDue date is " + dueDate);
                            }
                        } else if (PersistentDeliveryService.this.myLogger.isLoggable(Logger.FINE)) {
                            PersistentDeliveryService.this.myLogger.log(Logger.FINE, "Persistent-Delivery - Re-storing message\n" + MessageManager.stringify(msg) + " for agent " + receiver.getName() + "\nDue date is " + dueDate);
                        }
                        PersistentDeliveryService.this.myManager.storeMessage(storeName, msg, receiver);
                        return true;
                    }
                    catch (IOException ioe) {
                        throw new ServiceException("I/O Error in message storage", ioe);
                    }
                }
            }
            return false;
        }

        private void flushMessages(AID receiver) {
            PersistentDeliveryService.this.myLogger.log(Logger.FINE, "Persistent-Delivery - flushing messages for agent " + receiver.getLocalName());
            int cnt = PersistentDeliveryService.this.myManager.flushMessages(receiver);
            if (cnt > 0) {
                PersistentDeliveryService.this.myLogger.log(Logger.INFO, "Persistent-Delivery - " + cnt + " messages delivered to agent " + receiver);
            }
        }
    }

    private class CommandIncomingFilter
    extends Filter {
        private CommandIncomingFilter() {
        }

        @Override
        public void postProcess(VerticalCommand cmd) {
            try {
                String name = cmd.getName();
                if (name.equals("Inform-Created")) {
                    this.handleInformCreated(cmd);
                }
            }
            catch (IMTPException imtpe) {
                cmd.setReturnValue(imtpe);
            }
            catch (ServiceException se) {
                cmd.setReturnValue(se);
            }
        }

        private void handleInformCreated(VerticalCommand cmd) throws IMTPException, ServiceException {
            Object[] params = cmd.getParams();
            AID agentID = (AID)params[0];
            PersistentDeliveryService.this.myLogger.log(Logger.FINE, "Persistent-Delivery - Flushing persisted messages (if any) for newly started agent " + agentID.getLocalName());
            PersistentDeliveryService.this.flushMessages(agentID);
        }
    }

    private class CommandOutgoingFilter
    extends Filter {
        private CommandOutgoingFilter() {
        }

        @Override
        public boolean accept(VerticalCommand cmd) {
            try {
                String name = cmd.getName();
                if (name.equals("Notify-Failure")) {
                    return this.handleNotifyFailure(cmd);
                }
            }
            catch (IMTPException imtpe) {
                cmd.setReturnValue(imtpe);
            }
            catch (ServiceException se) {
                cmd.setReturnValue(se);
            }
            return true;
        }

        private boolean handleNotifyFailure(VerticalCommand cmd) throws IMTPException, ServiceException {
            Object[] params = cmd.getParams();
            GenericMessage msg = (GenericMessage)params[0];
            AID receiver = (AID)params[1];
            ACLMessage acl = msg.getACLMessage();
            if (PersistentDeliveryService.this.myLogger.isLoggable(Logger.FINE)) {
                PersistentDeliveryService.this.myLogger.log(Logger.FINE, "Persistent-Delivery - Processing failed message " + MessageManager.stringify(msg) + " for agent " + receiver.getName());
            }
            Service.Slice[] slices = PersistentDeliveryService.this.getStorageEnabledSlices();
            for (int i = 0; i < slices.length; ++i) {
                PersistentDeliverySlice slice = (PersistentDeliverySlice)slices[i];
                String sliceName = null;
                try {
                    sliceName = slice.getNode().getName();
                    boolean firstTime = acl.getUserDefinedParameter(PersistentDeliveryService.ACL_USERDEF_DUE_DATE) == null;
                    boolean accepted = false;
                    try {
                        accepted = slice.storeMessage(null, msg, receiver);
                    }
                    catch (IMTPException imtpe) {
                        slice = (PersistentDeliverySlice)PersistentDeliveryService.this.getFreshSlice(sliceName);
                        accepted = slice.storeMessage(null, msg, receiver);
                    }
                    if (!accepted) continue;
                    PersistentDeliveryService.this.myLogger.log(firstTime ? Logger.INFO : Logger.FINE, "Persistent-Delivery - Message " + MessageManager.stringify(msg) + " for agent " + receiver.getName() + " stored on node " + sliceName);
                    return false;
                }
                catch (Exception e) {
                    PersistentDeliveryService.this.myLogger.log(Logger.WARNING, "Persistent-Delivery - Error trying to store message " + MessageManager.stringify(msg) + " for agent " + receiver.getName() + " on node " + sliceName);
                }
            }
            return true;
        }
    }
}

