/*
 * Decompiled with CFR 0.152.
 */
package jade.core.nodeMonitoring;

import jade.core.IMTPException;
import jade.core.Node;
import jade.core.NodeEventListener;
import jade.core.NodeFailureMonitor;
import jade.util.Logger;

public class BlockingNodeFailureMonitor
extends NodeFailureMonitor
implements Runnable {
    private boolean nodeExited = false;
    private boolean stopped = false;
    private Logger myLogger = Logger.getMyLogger(this.getClass().getName());

    @Override
    public void start(Node n, NodeEventListener nel) {
        super.start(n, nel);
        Thread thread = new Thread(this);
        thread.setName(this.target.getName() + "-failure-monitor");
        thread.start();
    }

    @Override
    public void run() {
        this.fireNodeAdded();
        while (!this.nodeExited && !this.stopped) {
            try {
                this.nodeExited = this.target.ping(true);
                if (!this.myLogger.isLoggable(Logger.INFO)) continue;
                this.myLogger.log(Logger.INFO, "PING from node " + this.target.getName() + " returned [" + (this.nodeExited ? "EXIT]" : "GO ON]"));
            }
            catch (IMTPException imtpe1) {
                if (this.myLogger.isLoggable(Logger.INFO)) {
                    this.myLogger.log(Logger.INFO, "PING from node " + this.target.getName() + " exited with exception. " + imtpe1.getMessage());
                }
                if (!this.stopped) {
                    this.fireNodeUnreachable();
                }
                try {
                    this.target.ping(false);
                    if (this.myLogger.isLoggable(Logger.INFO)) {
                        this.myLogger.log(Logger.INFO, "PING from node " + this.target.getName() + " returned OK");
                    }
                    if (this.stopped) continue;
                    this.fireNodeReachable();
                }
                catch (IMTPException imtpe2) {
                    this.nodeExited = true;
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        if (!this.stopped) {
            this.fireNodeRemoved();
        }
    }

    @Override
    public void stop() {
        block2: {
            try {
                this.stopped = true;
                this.target.interrupt();
            }
            catch (IMTPException imtpe) {
                if (!this.myLogger.isLoggable(Logger.INFO)) break block2;
                this.myLogger.log(Logger.INFO, "-- The node <" + this.target.getName() + "> is already dead --");
            }
        }
    }
}

