/*
 * Decompiled with CFR 0.152.
 */
package jade.core.sam;

import jade.core.sam.AverageMeasure;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class SAMInfo
implements Serializable {
    private static final long serialVersionUID = 84762938792387L;
    public static final String DEFAULT_AGGREGATION_SEPARATOR = "#";
    public static final char DEFAULT_AGGREGATION_SEPARATOR_CHAR = '#';
    public static final String SUM_AGGREGATION_SEPARATOR = "+";
    public static final char SUM_AGGREGATION_SEPARATOR_CHAR = '+';
    public static final String AVG_AGGREGATION_SEPARATOR = "@";
    public static final char AVG_AGGREGATION_SEPARATOR_CHAR = '@';
    public static final int AVG_AGGREGATION = 0;
    public static final int SUM_AGGREGATION = 1;
    private Map<String, AverageMeasure> entityMeasures;
    private Map<String, Long> counterValues;

    SAMInfo() {
        this(new HashMap<String, AverageMeasure>(), new HashMap<String, Long>());
    }

    SAMInfo(Map<String, AverageMeasure> entityMeasures, Map<String, Long> counterValues) {
        this.entityMeasures = entityMeasures;
        this.counterValues = counterValues;
    }

    public Map<String, AverageMeasure> getEntityMeasures() {
        return this.entityMeasures;
    }

    public Map<String, Long> getCounterValues() {
        return this.counterValues;
    }

    void update(SAMInfo info) {
        Map<String, AverageMeasure> mm = info.getEntityMeasures();
        for (String entityName : mm.keySet()) {
            AverageMeasure newM = mm.get(entityName);
            AverageMeasure m = this.entityMeasures.get(entityName);
            if (m == null) {
                this.entityMeasures.put(entityName, newM);
                continue;
            }
            m.update(newM);
        }
        Map<String, Long> vv = info.getCounterValues();
        for (String counterName : vv.keySet()) {
            long newV = vv.get(counterName);
            Long v = this.counterValues.get(counterName);
            if (v == null) {
                this.counterValues.put(counterName, newV);
                continue;
            }
            this.counterValues.put(counterName, v + newV);
        }
    }

    void computeAggregatedValues() {
        Map<String, AverageMeasure> aggregatedMeasures = SAMInfo.oneShotComputeAggregatedMeasures(this.entityMeasures);
        while (aggregatedMeasures.size() > 0) {
            SAMInfo.addAllMeasures(aggregatedMeasures, this.entityMeasures);
            aggregatedMeasures = SAMInfo.oneShotComputeAggregatedMeasures(aggregatedMeasures);
        }
        Map<String, Long> aggregatedCounters = SAMInfo.oneShotComputeAggregatedCounters(this.counterValues);
        while (aggregatedCounters.size() > 0) {
            SAMInfo.addAllCounters(aggregatedCounters, this.counterValues);
            aggregatedCounters = SAMInfo.oneShotComputeAggregatedCounters(aggregatedCounters);
        }
    }

    private static Map<String, AverageMeasure> oneShotComputeAggregatedMeasures(Map<String, AverageMeasure> measures) {
        HashMap<String, AverageMeasure> aggregatedMeasures = new HashMap<String, AverageMeasure>();
        for (String entityName : measures.keySet()) {
            AverageMeasure am = measures.get(entityName);
            AggregationInfo ai = SAMInfo.getAggregationInfo(entityName, 0);
            if (ai == null) continue;
            String aggregatedEntityName = ai.aggregatedName;
            AverageMeasure agM = (AverageMeasure)aggregatedMeasures.get(aggregatedEntityName);
            if (agM == null) {
                agM = new AverageMeasure();
                aggregatedMeasures.put(aggregatedEntityName, agM);
            }
            agM.update(am, ai.aggregation);
        }
        return aggregatedMeasures;
    }

    private static void addAllMeasures(Map<String, AverageMeasure> mm1, Map<String, AverageMeasure> mm2) {
        for (String entityName : mm1.keySet()) {
            AverageMeasure m = mm1.get(entityName);
            AverageMeasure old = mm2.get(entityName);
            if (old != null) {
                old.update(m);
                continue;
            }
            mm2.put(entityName, m);
        }
    }

    private static Map<String, Long> oneShotComputeAggregatedCounters(Map<String, Long> counters) {
        HashMap<String, CounterAggregator> aggregatedCounters = new HashMap<String, CounterAggregator>();
        for (String counterName : counters.keySet()) {
            Long c = counters.get(counterName);
            AggregationInfo ai = SAMInfo.getAggregationInfo(counterName, 1);
            if (ai == null) continue;
            String aggregatedCounterName = ai.aggregatedName;
            CounterAggregator agC = (CounterAggregator)aggregatedCounters.get(aggregatedCounterName);
            if (agC == null) {
                agC = new CounterAggregator();
                aggregatedCounters.put(aggregatedCounterName, agC);
            }
            agC.update(c, ai.aggregation);
        }
        HashMap<String, Long> result = new HashMap<String, Long>(aggregatedCounters.size());
        for (Map.Entry entry : aggregatedCounters.entrySet()) {
            result.put((String)entry.getKey(), ((CounterAggregator)entry.getValue()).getAggregatedValue());
        }
        return result;
    }

    private static void addAllCounters(Map<String, Long> cc1, Map<String, Long> cc2) {
        for (String counterName : cc1.keySet()) {
            Long c = cc1.get(counterName);
            Long old = cc2.get(counterName);
            if (old == null) {
                old = new Long(0L);
            }
            cc2.put(counterName, old + c);
        }
    }

    public static final AggregationInfo getAggregationInfo(String name, int defaultAggregation) {
        for (int i = name.length() - 1; i >= 0; --i) {
            AggregationInfo ai = null;
            char c = name.charAt(i);
            if (c == '#') {
                ai = new AggregationInfo(defaultAggregation);
            } else if (c == '+') {
                ai = new AggregationInfo(1);
            } else if (c == '@') {
                ai = new AggregationInfo(0);
            }
            if (ai == null) continue;
            ai.aggregatedName = name.substring(0, i);
            return ai;
        }
        return null;
    }

    private static class CounterAggregator {
        private double aggregatedVal = 0.0;
        private int contributionsCnt = 0;

        private CounterAggregator() {
        }

        public void update(long contribution, int aggregation) {
            if (aggregation == 0) {
                this.aggregatedVal = (this.aggregatedVal * (double)this.contributionsCnt + (double)contribution) / (double)(this.contributionsCnt + 1);
                ++this.contributionsCnt;
            } else {
                this.aggregatedVal += (double)contribution;
            }
        }

        public long getAggregatedValue() {
            return (long)this.aggregatedVal;
        }
    }

    public static class AggregationInfo {
        private int aggregation;
        private String aggregatedName;

        AggregationInfo(int aggregation) {
            this.aggregation = aggregation;
        }
    }
}

