/*
 * Decompiled with CFR 0.152.
 */
package jade.imtp.leap;

import jade.core.FrontEnd;
import jade.core.IMTPException;
import jade.core.NotFoundException;
import jade.imtp.leap.Command;
import jade.imtp.leap.MicroSkeleton;
import jade.lang.acl.ACLMessage;

public class FrontEndSkel
extends MicroSkeleton {
    static final int CREATE_AGENT = 10;
    static final int KILL_AGENT = 11;
    static final int SUSPEND_AGENT = 12;
    static final int RESUME_AGENT = 13;
    static final int MESSAGE_IN = 14;
    static final int EXIT = 15;
    static final int SYNCH = 16;
    private FrontEnd myFrontEnd;

    public FrontEndSkel(FrontEnd fe) {
        this.myFrontEnd = fe;
    }

    @Override
    Command executeCommand(Command c) throws Throwable {
        try {
            switch (c.getCode()) {
                case 14: {
                    this.myFrontEnd.messageIn((ACLMessage)c.getParamAt(0), (String)c.getParamAt(1));
                    break;
                }
                case 10: {
                    this.myFrontEnd.createAgent((String)c.getParamAt(0), (String)c.getParamAt(1), (String[])c.getParamAt(2));
                    break;
                }
                case 11: {
                    this.myFrontEnd.killAgent((String)c.getParamAt(0));
                    break;
                }
                case 12: {
                    this.myFrontEnd.suspendAgent((String)c.getParamAt(0));
                    break;
                }
                case 13: {
                    this.myFrontEnd.resumeAgent((String)c.getParamAt(0));
                    break;
                }
                case 15: {
                    this.myFrontEnd.exit((Boolean)c.getParamAt(0));
                    break;
                }
                case 16: {
                    this.myFrontEnd.synch();
                    break;
                }
                default: {
                    throw new IMTPException("Unsupported command " + c.getCode());
                }
            }
            c.reset(1);
        }
        catch (NotFoundException nfe) {
            c = this.createErrorRsp(nfe, true);
        }
        catch (IMTPException imtpe) {
            c = this.createErrorRsp(imtpe, true);
        }
        return c;
    }
}

