/*
 * Decompiled with CFR 0.152.
 */
package jade.imtp.leap.sms;

import jade.imtp.leap.sms.SMSManager;
import jade.util.leap.Properties;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class SMSManagerGui
extends JFrame {
    private JTextField msisdnTF;
    private JTextField portTF;
    private JTextArea textTA;
    private SMSManager theSMSManager;

    public SMSManagerGui() {
        super("SMS Manager GUI");
    }

    public void init(Properties pp) {
        this.theSMSManager = SMSManager.getInstance(pp);
        if (this.theSMSManager != null) {
            this.setSize(this.getProperSize(320, 400));
            this.setResizable(false);
            JPanel main = new JPanel();
            main.setLayout(new GridLayout(2, 1));
            JPanel p = new JPanel();
            p.setLayout(new GridLayout(5, 1));
            p.add(new JLabel("Telephon number:"));
            this.msisdnTF = new JTextField();
            p.add(this.msisdnTF);
            p.add(new JLabel("Port:"));
            this.portTF = new JTextField();
            p.add(this.portTF);
            p.add(new JLabel("Message text:"));
            main.add(p);
            p = new JPanel();
            p.setLayout(new GridLayout(1, 1));
            this.textTA = new JTextArea();
            p.add(this.textTA);
            main.add(p);
            this.getContentPane().add((Component)main, "Center");
            p = new JPanel();
            JButton b = new JButton("Send");
            b.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        String msisdn = SMSManagerGui.this.msisdnTF.getText().trim();
                        String tmp = SMSManagerGui.this.portTF.getText();
                        int port = -1;
                        if (tmp != null && tmp.trim().length() > 0) {
                            port = Integer.parseInt(SMSManagerGui.this.portTF.getText());
                        }
                        String txt = SMSManagerGui.this.textTA.getText();
                        SMSManagerGui.this.theSMSManager.sendTextMessage(msisdn, port, txt);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            });
            p.add(b);
            this.getContentPane().add((Component)p, "South");
            this.showCorrect();
        } else {
            System.out.println("Cannot retrieve the SMS Manager");
        }
    }

    private void showCorrect() {
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        int scrH = (int)dim.getHeight();
        int scrW = (int)dim.getWidth();
        this.setLocation((int)((double)scrW * 0.2), (int)((double)scrH * 0.1));
        this.setVisible(true);
    }

    private Dimension getProperSize(int maxX, int maxY) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int x = screenSize.width < maxX ? screenSize.width : maxX;
        int y = screenSize.height < maxY ? screenSize.height : maxY;
        return new Dimension(x, y);
    }

    public static void main(String[] args) {
        if (args != null && args.length == 1) {
            try {
                Properties pp = new Properties();
                pp.load(args[0]);
                SMSManagerGui gui = new SMSManagerGui();
                gui.init(pp);
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        } else {
            System.out.println("USAGE: java SMSManagerGui <properties-file>");
        }
    }
}

