/*
 * Decompiled with CFR 0.152.
 */
package jade.imtp.rmi;

import jade.JadeClassLoader;
import jade.core.IMTPException;
import jade.core.IMTPManager;
import jade.core.Node;
import jade.core.NodeDescriptor;
import jade.core.PlatformManager;
import jade.core.PlatformManagerImpl;
import jade.core.Profile;
import jade.core.Service;
import jade.core.ServiceDescriptor;
import jade.core.ServiceException;
import jade.core.SliceProxy;
import jade.imtp.rmi.NodeAdapter;
import jade.imtp.rmi.RMIAddress;
import jade.imtp.rmi.ServiceManagerRMI;
import jade.imtp.rmi.ServiceManagerRMIImpl;
import jade.mtp.TransportAddress;
import jade.security.JADESecurityException;
import jade.util.Logger;
import jade.util.leap.LinkedList;
import jade.util.leap.List;
import java.net.InetAddress;
import java.rmi.AlreadyBoundException;
import java.rmi.ConnectException;
import java.rmi.Naming;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.rmi.server.UnicastRemoteObject;
import java.util.Vector;

public class RMIIMTPManager
implements IMTPManager {
    public static final String LOCAL_SERVICE_MANAGER_PORT = "smport";
    public static final String LOCAL_NODE_PORT = "nodeport";
    public static final String ENABLE_RMI_LOG = "jade_imtp_rmi_RMIIMTPManager_enablermilog";
    private static final int DEFAULT_RMI_PORT = 1099;
    private Profile myProfile;
    private String mainHost;
    private int mainPort;
    private String localHost;
    private int localPort;
    private int localSvcMgrPort;
    private int localNodePort;
    private String localAddr;
    private String originalPMAddr;
    private NodeAdapter localNode;
    private ServiceManagerRMIImpl myRMIServiceManager;
    private Logger myLogger = Logger.getMyLogger(this.getClass().getName());
    private static final char SLASH = '/';
    private static final char COLON = ':';
    private static final char DIESIS = '#';

    @Override
    public void initialize(Profile p) throws IMTPException {
        this.myProfile = p;
        this.mainHost = this.myProfile.getParameter("host", null);
        this.mainPort = 1099;
        String mainPortStr = this.myProfile.getParameter("port", null);
        try {
            this.mainPort = Integer.parseInt(mainPortStr);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.myProfile.isMasterMain()) {
            this.localHost = this.myProfile.getParameter("local-host", this.mainHost);
            this.localPort = this.mainPort;
        } else {
            this.localHost = this.myProfile.getParameter("local-host", null);
            this.localPort = 1099;
        }
        String localPortStr = this.myProfile.getParameter("local-port", null);
        try {
            this.localPort = Integer.parseInt(localPortStr);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.localSvcMgrPort = 0;
        String localSvcMgrPortStr = this.myProfile.getParameter(LOCAL_SERVICE_MANAGER_PORT, null);
        try {
            this.localSvcMgrPort = Integer.parseInt(localSvcMgrPortStr);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.localNodePort = !this.myProfile.getBooleanProperty("main", true) ? this.localPort : 0;
        String localNodePortStr = this.myProfile.getParameter(LOCAL_NODE_PORT, null);
        try {
            this.localNodePort = Integer.parseInt(localNodePortStr);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.localAddr = "rmi://" + this.localHost + ":" + this.localPort + "/";
        if (this.myProfile.isBackupMain()) {
            this.originalPMAddr = "rmi://" + this.mainHost + ":" + this.mainPort + "/";
        }
        if (this.myLogger.isLoggable(Logger.CONFIG)) {
            this.myLogger.log(Logger.CONFIG, "IMTP parameters: main-host=" + this.mainHost + " main-port=" + this.mainPort + " local-host=" + this.localHost + " local-port=" + this.localPort + " sm-port=" + this.localSvcMgrPort + " node-port=" + this.localNodePort);
        }
        System.getProperties().put("java.rmi.server.hostname", this.localHost);
        if (this.myProfile.getBooleanProperty(ENABLE_RMI_LOG, false)) {
            UnicastRemoteObject.setLog(System.out);
        }
        try {
            this.localNode = new NodeAdapter("No-Name", this.myProfile.getBooleanProperty("main", true), this.localNodePort, this);
        }
        catch (RemoteException re) {
            throw new IMTPException("An RMI error occurred", re);
        }
    }

    private Registry getRmiRegistry(String host, int portNumber) throws RemoteException {
        Registry rmiRegistry = null;
        try {
            rmiRegistry = LocateRegistry.getRegistry(host, portNumber);
            rmiRegistry.list();
            this.myLogger.log(Logger.CONFIG, "Local RMI Registry on port " + portNumber + " already exists. Use it");
        }
        catch (Exception exc) {
            rmiRegistry = LocateRegistry.createRegistry(portNumber);
            this.myLogger.log(Logger.CONFIG, "Local RMI Registry successfully created on port " + portNumber);
        }
        return rmiRegistry;
    }

    @Override
    public void exportPlatformManager(PlatformManager mgr) throws IMTPException {
        block12: {
            try {
                String svcMgrName = this.localAddr + "ServiceManager";
                mgr.setLocalAddress(this.localAddr);
                this.myRMIServiceManager = new ServiceManagerRMIImpl(mgr, this, this.localSvcMgrPort);
                Registry theRegistry = this.getRmiRegistry(null, this.localPort);
                Naming.bind(svcMgrName, this.myRMIServiceManager);
                if (this.myLogger.isLoggable(Logger.CONFIG)) {
                    String[] names = theRegistry.list();
                    StringBuffer sb = new StringBuffer("Local RMI Registry bindings:\n");
                    for (int i = 0; i < names.length; ++i) {
                        sb.append("Name " + names[i] + " bound to " + theRegistry.lookup(names[i]) + "\n");
                    }
                    this.myLogger.log(Logger.CONFIG, sb.toString());
                }
                if (this.originalPMAddr == null) break block12;
                try {
                    PlatformManager originalPM = this.getPlatformManagerProxy(this.originalPMAddr);
                    ((PlatformManagerImpl)mgr).setPlatformName(originalPM.getPlatformName());
                    this.myLogger.log(Logger.INFO, "Connecting to master Main Container at address " + this.originalPMAddr);
                    mgr.addReplica(this.originalPMAddr, true);
                    originalPM.addReplica(this.localAddr, false);
                }
                catch (ServiceException se) {
                    throw new IMTPException("Cannot attach to the original PlatformManager.", se);
                }
                catch (IMTPException imtpe) {
                    Throwable t = imtpe.getNested();
                    if (t != null && t instanceof ConnectException) {
                        this.myLogger.log(Logger.INFO, "No master Main Container found at address " + this.originalPMAddr + ". Take the leadership");
                        this.originalPMAddr = null;
                        this.myProfile.setParameter("backupmain", "false");
                        break block12;
                    }
                    throw imtpe;
                }
            }
            catch (ConnectException ce) {
                System.out.println("ERROR: trying to bind to a remote RMI registry.");
                System.out.println("If you want to start a JADE main container:");
                System.out.println("  Make sure the specified host name or IP address belongs to the local machine.");
                System.out.println("  Please use '-host' and/or '-port' options to setup JADE host and port.");
                System.out.println("If you want to start a JADE non-main container: ");
                System.out.println("  Use the '-container' option, then use '-host' and '-port' to specify the ");
                System.out.println("  location of the main container you want to connect to.");
                throw new IMTPException("RMI Binding error", ce);
            }
            catch (RemoteException re) {
                throw new IMTPException("Communication failure while starting JADE Runtime System. Check if the RMIRegistry CLASSPATH includes the RMI Stub classes of JADE.", re);
            }
            catch (AlreadyBoundException abe) {
                throw new IMTPException("The Service Manager was already bound in the RMI Registry", abe);
            }
            catch (IMTPException imtpe) {
                throw imtpe;
            }
            catch (Exception e) {
                throw new IMTPException("Problem starting JADE Runtime System.", e);
            }
        }
    }

    @Override
    public void unexportPlatformManager(PlatformManager mgr) throws IMTPException {
        if (this.myRMIServiceManager != null && this.myRMIServiceManager.getPlatformManager().equals(mgr)) {
            try {
                String svcMgrName = this.localAddr + "ServiceManager";
                Naming.unbind(svcMgrName);
                ServiceManagerRMIImpl.unexportObject(this.myRMIServiceManager, true);
            }
            catch (Exception e) {
                throw new IMTPException("Error in unexporting the RMI Service Manager", e);
            }
        }
    }

    @Override
    public PlatformManager getPlatformManagerProxy() throws IMTPException {
        return this.getPlatformManagerProxy("rmi://" + this.mainHost + ":" + this.mainPort + "/");
    }

    @Override
    public PlatformManager getPlatformManagerProxy(String addr) throws IMTPException {
        try {
            String pmName = addr + "ServiceManager";
            ServiceManagerRMI sm = (ServiceManagerRMI)Naming.lookup(pmName);
            return new PlatformManagerAdapter(sm, addr);
        }
        catch (Exception e) {
            throw new IMTPException("Can't get a proxy to the PlatformManager at address " + addr, e);
        }
    }

    @Override
    public void reconnected(PlatformManager pm) {
    }

    @Override
    public Service.Slice createSliceProxy(String serviceName, Class itf, Node where) throws IMTPException {
        try {
            Class<?> proxyClass = JadeClassLoader.forName(serviceName + "Proxy");
            Service.Slice proxy = (Service.Slice)proxyClass.newInstance();
            if (proxy instanceof SliceProxy) {
                ((SliceProxy)proxy).setNode(where);
            } else if (proxy instanceof Service.SliceProxy) {
                ((Service.SliceProxy)proxy).setNode(where);
            } else {
                throw new IMTPException("Class " + proxyClass.getName() + " is not a slice proxy.");
            }
            return proxy;
        }
        catch (Exception e) {
            throw new IMTPException("Error creating a slice proxy", e);
        }
    }

    @Override
    public Node getLocalNode() throws IMTPException {
        return this.localNode;
    }

    @Override
    public void shutDown() {
        try {
            if (this.localNode != null) {
                this.localNode.exit();
            }
        }
        catch (IMTPException imtpe) {
            imtpe.printStackTrace();
        }
    }

    @Override
    public List getLocalAddresses() throws IMTPException {
        try {
            LinkedList l = new LinkedList();
            RMIAddress addr = new RMIAddress(InetAddress.getLocalHost().getHostName(), String.valueOf(this.localPort), null, null);
            l.add(addr);
            return l;
        }
        catch (Exception e) {
            throw new IMTPException("Exception reading local addresses", e);
        }
    }

    public boolean compareAddresses(String addr1, String addr2) throws IMTPException {
        return addr1.equalsIgnoreCase(addr2);
    }

    public RMIClientSocketFactory getClientSocketFactory() {
        return null;
    }

    public RMIServerSocketFactory getServerSocketFactory() {
        return null;
    }

    @Override
    public TransportAddress stringToAddr(String url) throws IMTPException {
        if (url == null) {
            throw new IMTPException("Null URL");
        }
        String protocol = null;
        String host = null;
        String port = null;
        String file = null;
        String anchor = null;
        int fieldStart = 0;
        int fieldEnd = url.indexOf(58, fieldStart);
        if (fieldEnd <= 0 || url.charAt(fieldEnd + 1) != '/' || url.charAt(fieldEnd + 2) != '/') {
            throw new IMTPException("Invalid URL: " + url + ".");
        }
        protocol = url.substring(fieldStart, fieldEnd);
        fieldStart = fieldEnd + 3;
        fieldEnd = url.indexOf(58, fieldStart);
        if (fieldEnd > 0) {
            host = url.substring(fieldStart, fieldEnd);
            fieldStart = fieldEnd + 1;
            if ((fieldEnd = url.indexOf(47, fieldStart)) > 0) {
                port = url.substring(fieldStart, fieldEnd);
                fieldStart = fieldEnd + 1;
                if ((fieldEnd = url.indexOf(35, fieldStart)) > 0) {
                    file = url.substring(fieldStart, fieldEnd);
                    fieldStart = fieldEnd + 1;
                    anchor = url.substring(fieldStart, url.length());
                } else {
                    file = url.substring(fieldStart, url.length());
                }
            } else {
                port = url.substring(fieldStart, url.length());
            }
        } else {
            fieldEnd = url.indexOf(47, fieldStart);
            if (fieldEnd > 0) {
                host = url.substring(fieldStart, fieldEnd);
                fieldStart = fieldEnd + 1;
                if ((fieldEnd = url.indexOf(35, fieldStart)) > 0) {
                    file = url.substring(fieldStart, fieldEnd);
                    fieldStart = fieldEnd + 1;
                    anchor = url.substring(fieldStart, url.length());
                } else {
                    file = url.substring(fieldStart, url.length());
                }
            } else {
                host = url.substring(fieldStart, url.length());
            }
        }
        return new RMIAddress(host, port, file, anchor);
    }

    private class PlatformManagerAdapter
    implements PlatformManager {
        private String localAddress;
        private ServiceManagerRMI adaptee;

        private PlatformManagerAdapter(ServiceManagerRMI adaptee, String localAddress) {
            this.localAddress = localAddress;
            this.adaptee = adaptee;
        }

        @Override
        public String getPlatformName() throws IMTPException {
            try {
                return this.adaptee.getPlatformName();
            }
            catch (RemoteException re) {
                throw new IMTPException("RMI exception", re);
            }
        }

        @Override
        public String getLocalAddress() {
            return this.localAddress;
        }

        @Override
        public void setLocalAddress(String addr) {
        }

        @Override
        public String addNode(NodeDescriptor dsc, Vector nodeServices, boolean propagated) throws IMTPException, ServiceException, JADESecurityException {
            try {
                return this.adaptee.addNode(dsc, nodeServices, propagated);
            }
            catch (RemoteException re) {
                throw new IMTPException("RMI exception", re);
            }
        }

        @Override
        public void removeNode(NodeDescriptor dsc, boolean propagated) throws IMTPException, ServiceException {
            try {
                this.adaptee.removeNode(dsc, propagated);
            }
            catch (RemoteException re) {
                throw new IMTPException("RMI exception", re);
            }
        }

        @Override
        public void addSlice(ServiceDescriptor service, NodeDescriptor dsc, boolean propagated) throws IMTPException, ServiceException {
            try {
                this.adaptee.addSlice(service, dsc, propagated);
            }
            catch (RemoteException re) {
                throw new IMTPException("RMI exception", re);
            }
        }

        @Override
        public void removeSlice(String serviceKey, String sliceKey, boolean propagated) throws IMTPException, ServiceException {
            try {
                this.adaptee.removeSlice(serviceKey, sliceKey, propagated);
            }
            catch (RemoteException re) {
                throw new IMTPException("RMI exception", re);
            }
        }

        @Override
        public void addReplica(String newAddr, boolean propagated) throws IMTPException, ServiceException {
            try {
                this.adaptee.addReplica(newAddr, propagated);
            }
            catch (RemoteException re) {
                throw new IMTPException("RMI exception", re);
            }
        }

        @Override
        public void removeReplica(String address, boolean propagated) throws IMTPException, ServiceException {
            try {
                this.adaptee.removeReplica(address, propagated);
            }
            catch (RemoteException re) {
                throw new IMTPException("RMI exception", re);
            }
        }

        @Override
        public Service.Slice findSlice(String serviceKey, String sliceKey) throws IMTPException, ServiceException {
            try {
                return this.adaptee.findSlice(serviceKey, sliceKey);
            }
            catch (RemoteException re) {
                throw new IMTPException("RMI exception", re);
            }
        }

        @Override
        public Vector findAllSlices(String serviceKey) throws IMTPException, ServiceException {
            try {
                return this.adaptee.findAllSlices(serviceKey);
            }
            catch (RemoteException re) {
                throw new IMTPException("RMI exception", re);
            }
        }

        @Override
        public void adopt(Node n, Node[] children) throws IMTPException {
            try {
                this.adaptee.adopt(n, children);
            }
            catch (RemoteException re) {
                throw new IMTPException("RMI exception", re);
            }
        }

        @Override
        public void ping() throws IMTPException {
            try {
                this.adaptee.ping();
            }
            catch (RemoteException re) {
                throw new IMTPException("RMI exception", re);
            }
        }

        public String toString() {
            return "PlatformManagerAdapter: local-address=" + this.localAddress + " adaptee=" + this.adaptee;
        }
    }
}

