/*
 * Decompiled with CFR 0.152.
 */
package jade.lang.acl;

import jade.core.Agent;
import jade.lang.acl.ACLMessage;
import jade.lang.acl.MessageTemplate;
import jade.util.leap.HashSet;
import jade.util.leap.Serializable;

public class ConversationList
implements Serializable {
    private HashSet conversations = new HashSet();
    protected Agent myAgent = null;
    protected int cnt = 0;
    private MessageTemplate myTemplate = new MessageTemplate(new MessageTemplate.MatchExpression(){

        @Override
        public boolean match(ACLMessage msg) {
            String convId = msg.getConversationId();
            return convId == null || !ConversationList.this.conversations.contains(convId);
        }
    });

    public ConversationList(Agent a) {
        this.myAgent = a;
    }

    public String registerConversation() {
        String id = this.createConversationId();
        this.conversations.add(id);
        return id;
    }

    public void registerConversation(String convId) {
        if (convId != null) {
            this.conversations.add(convId);
        }
    }

    public void deregisterConversation(String convId) {
        if (convId != null) {
            this.conversations.remove(convId);
        }
    }

    public void clear() {
        this.conversations.clear();
    }

    public MessageTemplate getMessageTemplate() {
        return this.myTemplate;
    }

    public String toString() {
        return "CL" + this.conversations;
    }

    protected String createConversationId() {
        return this.myAgent.getName() + this.cnt++;
    }
}

