/*
 * Decompiled with CFR 0.152.
 */
package jade.proto;

import jade.core.AID;
import jade.core.Agent;
import jade.core.behaviours.Behaviour;
import jade.core.behaviours.DataStore;
import jade.core.behaviours.FSMBehaviour;
import jade.core.behaviours.OneShotBehaviour;
import jade.lang.acl.ACLMessage;
import jade.lang.acl.MessageTemplate;
import jade.proto.states.MsgReceiver;
import jade.util.leap.HashMap;
import jade.util.leap.Iterator;
import jade.util.leap.Map;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;

abstract class Initiator
extends FSMBehaviour {
    protected final String INITIATION_K = "__initiation" + this.hashCode();
    protected final String ALL_INITIATIONS_K = "__all-initiations" + this.hashCode();
    protected final String REPLY_K = "__reply" + this.hashCode();
    protected static final String PREPARE_INITIATIONS = "Prepare-initiations";
    protected static final String SEND_INITIATIONS = "Send-initiations";
    protected static final String RECEIVE_REPLY = "Receive-reply";
    protected static final String CHECK_IN_SEQ = "Check-in-seq";
    protected static final String HANDLE_NOT_UNDERSTOOD = "Handle-not-understood";
    protected static final String HANDLE_FAILURE = "Handle-failure";
    protected static final String HANDLE_OUT_OF_SEQ = "Handle-out-of-seq";
    protected static final String CHECK_SESSIONS = "Check-sessions";
    protected static final String DUMMY_FINAL = "Dummy-final";
    protected Map sessions = new HashMap();
    protected MsgReceiver replyReceiver = null;
    protected MessageTemplate replyTemplate = null;
    private ACLMessage initiation;
    private static int cnt = 0;

    protected Initiator(Agent a, ACLMessage initiation) {
        this(a, initiation, new DataStore());
    }

    protected Initiator(Agent a, ACLMessage initiation, DataStore store) {
        super(a);
        this.setDataStore(store);
        this.initiation = initiation;
        this.registerDefaultTransition(PREPARE_INITIATIONS, SEND_INITIATIONS);
        this.registerTransition(SEND_INITIATIONS, DUMMY_FINAL, 0);
        this.registerDefaultTransition(SEND_INITIATIONS, RECEIVE_REPLY);
        this.registerTransition(RECEIVE_REPLY, CHECK_SESSIONS, -1001);
        this.registerTransition(RECEIVE_REPLY, CHECK_SESSIONS, -1002);
        this.registerDefaultTransition(RECEIVE_REPLY, CHECK_IN_SEQ);
        this.registerTransition(CHECK_IN_SEQ, HANDLE_NOT_UNDERSTOOD, 10);
        this.registerTransition(CHECK_IN_SEQ, HANDLE_FAILURE, 6);
        this.registerDefaultTransition(CHECK_IN_SEQ, HANDLE_OUT_OF_SEQ);
        this.registerDefaultTransition(HANDLE_NOT_UNDERSTOOD, CHECK_SESSIONS);
        this.registerDefaultTransition(HANDLE_FAILURE, CHECK_SESSIONS);
        this.registerDefaultTransition(HANDLE_OUT_OF_SEQ, RECEIVE_REPLY);
        this.registerDefaultTransition(CHECK_SESSIONS, RECEIVE_REPLY, this.getToBeReset());
        OneShotBehaviour b = null;
        b = new OneShotBehaviour(this.myAgent){
            private static final long serialVersionUID = 3487495895818000L;

            @Override
            public void action() {
                DataStore ds = this.getDataStore();
                Vector allInitiations = (Vector)ds.get(Initiator.this.ALL_INITIATIONS_K);
                if (allInitiations == null || allInitiations.size() == 0) {
                    allInitiations = Initiator.this.prepareInitiations((ACLMessage)ds.get(Initiator.this.INITIATION_K));
                    ds.put(Initiator.this.ALL_INITIATIONS_K, allInitiations);
                }
            }
        };
        b.setDataStore(this.getDataStore());
        this.registerFirstState(b, PREPARE_INITIATIONS);
        b = new OneShotBehaviour(this.myAgent){
            private static final long serialVersionUID = 3487495895818001L;

            @Override
            public void action() {
                Vector allInitiations = (Vector)this.getDataStore().get(Initiator.this.ALL_INITIATIONS_K);
                if (allInitiations != null) {
                    Initiator.this.sendInitiations(allInitiations);
                }
            }

            @Override
            public int onEnd() {
                return Initiator.this.sessions.size();
            }
        };
        b.setDataStore(this.getDataStore());
        this.registerState(b, SEND_INITIATIONS);
        this.replyReceiver = new MsgReceiver(this.myAgent, null, -1L, this.getDataStore(), this.REPLY_K);
        this.registerState(this.replyReceiver, RECEIVE_REPLY);
        b = new OneShotBehaviour(this.myAgent){
            int ret;
            private static final long serialVersionUID = 3487495895818002L;

            @Override
            public void action() {
                ACLMessage reply = (ACLMessage)this.getDataStore().get(Initiator.this.REPLY_K);
                this.ret = Initiator.this.checkInSequence(reply) ? reply.getPerformative() : -1;
            }

            @Override
            public int onEnd() {
                return this.ret;
            }
        };
        b.setDataStore(this.getDataStore());
        this.registerState(b, CHECK_IN_SEQ);
        b = new OneShotBehaviour(this.myAgent){
            private static final long serialVersionUID = 3487495895818005L;

            @Override
            public void action() {
                Initiator.this.handleNotUnderstood((ACLMessage)this.getDataStore().get(Initiator.this.REPLY_K));
            }
        };
        b.setDataStore(this.getDataStore());
        this.registerState(b, HANDLE_NOT_UNDERSTOOD);
        b = new OneShotBehaviour(this.myAgent){
            private static final long serialVersionUID = 3487495895818007L;

            @Override
            public void action() {
                Initiator.this.handleFailure((ACLMessage)this.getDataStore().get(Initiator.this.REPLY_K));
            }
        };
        b.setDataStore(this.getDataStore());
        this.registerState(b, HANDLE_FAILURE);
        b = new OneShotBehaviour(this.myAgent){
            private static final long serialVersionUID = 3487495895818008L;

            @Override
            public void action() {
                Initiator.this.handleOutOfSequence((ACLMessage)this.getDataStore().get(Initiator.this.REPLY_K));
            }
        };
        b.setDataStore(this.getDataStore());
        this.registerState(b, HANDLE_OUT_OF_SEQ);
        b = new OneShotBehaviour(this.myAgent){
            int ret;
            private static final long serialVersionUID = 3487495895818009L;

            @Override
            public void action() {
                ACLMessage reply = (ACLMessage)this.getDataStore().get(Initiator.this.REPLY_K);
                this.ret = Initiator.this.checkSessions(reply);
            }

            @Override
            public int onEnd() {
                return this.ret;
            }
        };
        b.setDataStore(this.getDataStore());
        this.registerState(b, CHECK_SESSIONS);
        b = new OneShotBehaviour(this.myAgent){
            private static final long serialVersionUID = 3487495895818010L;

            @Override
            public void action() {
            }
        };
        this.registerLastState(b, DUMMY_FINAL);
    }

    protected abstract Vector prepareInitiations(ACLMessage var1);

    protected abstract boolean checkInSequence(ACLMessage var1);

    protected abstract int checkSessions(ACLMessage var1);

    protected abstract String[] getToBeReset();

    protected abstract ProtocolSession getSession(ACLMessage var1, int var2);

    protected void sendInitiations(Vector initiations) {
        long currentTime = System.currentTimeMillis();
        long minTimeout = -1L;
        long deadline = -1L;
        String conversationID = this.createConvId(initiations);
        this.replyTemplate = MessageTemplate.MatchConversationId(conversationID);
        int cnt = 0;
        Vector<ACLMessage> sentMessages = new Vector<ACLMessage>();
        Enumeration e = initiations.elements();
        while (e.hasMoreElements()) {
            long timeout;
            ACLMessage initiation = (ACLMessage)e.nextElement();
            if (initiation == null) continue;
            Iterator receivers = initiation.getAllReceiver();
            while (receivers.hasNext()) {
                ACLMessage toSend = (ACLMessage)initiation.clone();
                toSend.setConversationId(conversationID);
                toSend.clearAllReceiver();
                AID r = (AID)receivers.next();
                toSend.addReceiver(r);
                ProtocolSession ps = this.getSession(toSend, cnt);
                if (ps != null) {
                    String sessionKey = ps.getId();
                    if (sessionKey == null) {
                        sessionKey = "R" + System.currentTimeMillis() + "_" + Integer.toString(cnt);
                    }
                    toSend.setReplyWith(sessionKey);
                    this.sessions.put(sessionKey, ps);
                    this.adjustReplyTemplate(toSend);
                    ++cnt;
                }
                this.myAgent.send(toSend);
                sentMessages.addElement(toSend);
            }
            Date d = initiation.getReplyByDate();
            if (d == null || (timeout = d.getTime() - currentTime) <= 0L || timeout >= minTimeout && minTimeout > 0L) continue;
            minTimeout = timeout;
            deadline = d.getTime();
        }
        this.getDataStore().put(this.ALL_INITIATIONS_K, sentMessages);
        this.replyReceiver.setTemplate(this.replyTemplate);
        this.replyReceiver.setDeadline(deadline);
    }

    protected void handleNotUnderstood(ACLMessage notUnderstood) {
    }

    protected void handleFailure(ACLMessage failure) {
    }

    protected void handleOutOfSequence(ACLMessage msg) {
    }

    protected void registerPrepareInitiations(Behaviour b) {
        this.registerState(b, PREPARE_INITIATIONS);
        b.setDataStore(this.getDataStore());
    }

    public void registerHandleNotUnderstood(Behaviour b) {
        this.registerState(b, HANDLE_NOT_UNDERSTOOD);
        b.setDataStore(this.getDataStore());
    }

    public void registerHandleFailure(Behaviour b) {
        this.registerState(b, HANDLE_FAILURE);
        b.setDataStore(this.getDataStore());
    }

    public void registerHandleOutOfSequence(Behaviour b) {
        this.registerState(b, HANDLE_OUT_OF_SEQ);
        b.setDataStore(this.getDataStore());
    }

    @Override
    public void reset() {
        this.reset(null);
    }

    public void reset(ACLMessage msg) {
        this.initiation = msg;
        this.reinit();
        super.reset();
    }

    protected void reinit() {
        this.replyReceiver.reset(null, -1L, this.getDataStore(), this.REPLY_K);
        this.sessions.clear();
        DataStore ds = this.getDataStore();
        ds.remove(this.INITIATION_K);
        ds.remove(this.ALL_INITIATIONS_K);
        ds.remove(this.REPLY_K);
    }

    @Override
    public void onStart() {
        this.initializeDataStore(this.initiation);
    }

    @Override
    public void setDataStore(DataStore ds) {
        super.setDataStore(ds);
        Iterator it = this.getChildren().iterator();
        while (it.hasNext()) {
            Behaviour b = (Behaviour)it.next();
            b.setDataStore(ds);
        }
    }

    protected void initializeDataStore(ACLMessage initiation) {
        this.getDataStore().put(this.INITIATION_K, initiation);
    }

    protected String createConvId(Vector msgs) {
        String convId = null;
        if (msgs.size() > 0) {
            ACLMessage msg = (ACLMessage)msgs.elementAt(0);
            convId = msg == null || msg.getConversationId() == null ? "C" + this.hashCode() + "_" + this.myAgent.getLocalName() + "_" + System.currentTimeMillis() + "_" + Initiator.getCnt() : msg.getConversationId();
        }
        return convId;
    }

    private static synchronized int getCnt() {
        int k = cnt++;
        return k;
    }

    protected void adjustReplyTemplate(ACLMessage msg) {
        AID r = (AID)msg.getAllReceiver().next();
        if (this.myAgent.getAID().equals(r)) {
            this.replyTemplate = MessageTemplate.and(this.replyTemplate, MessageTemplate.not(MessageTemplate.MatchCustom(msg, true)));
        }
    }

    protected static interface ProtocolSession {
        public String getId();

        public boolean update(int var1);

        public int getState();

        public boolean isCompleted();
    }
}

