/*
 * Decompiled with CFR 0.152.
 */
package jade.content.lang.leap;

import jade.content.abs.AbsAggregate;
import jade.content.abs.AbsContentElement;
import jade.content.abs.AbsContentElementList;
import jade.content.abs.AbsHelper;
import jade.content.abs.AbsObject;
import jade.content.abs.AbsPrimitive;
import jade.content.abs.AbsTerm;
import jade.content.lang.ByteArrayCodec;
import jade.content.lang.Codec;
import jade.content.onto.Ontology;
import jade.content.schema.ObjectSchema;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Date;
import java.util.Vector;

public class LEAPCodec
extends ByteArrayCodec {
    public static final String NAME = "LEAP";
    private transient ByteArrayOutputStream outBuffer = new ByteArrayOutputStream();
    private transient DataOutputStream outStream = new DataOutputStream(this.outBuffer);
    private transient Vector stringReferences = new Vector();
    private static final byte PRIMITIVE = 0;
    private static final byte AGGREGATE = 1;
    private static final byte CONTENT_ELEMENT_LIST = 2;
    private static final byte OBJECT = 3;
    private static final byte ELEMENT = 4;
    private static final byte END = 5;
    private static final byte STRING = 6;
    private static final byte BOOLEAN = 7;
    private static final byte INTEGER = 8;
    private static final byte LONG = 9;
    private static final byte FLOAT = 10;
    private static final byte DOUBLE = 11;
    private static final byte DATE = 12;
    private static final byte BYTE_SEQUENCE = 13;
    private static final byte BIG_STRING = 14;
    private static final byte MODIFIER = 16;
    private static final byte UNMODIFIER = -17;

    private void readObject(ObjectInputStream oin) throws IOException, ClassNotFoundException {
        oin.defaultReadObject();
        this.outBuffer = new ByteArrayOutputStream();
        this.outStream = new DataOutputStream(this.outBuffer);
        this.stringReferences = new Vector();
    }

    public LEAPCodec() {
        super(NAME);
    }

    @Override
    public synchronized byte[] encode(AbsContentElement content) throws Codec.CodecException {
        try {
            this.outBuffer.reset();
            this.stringReferences.removeAllElements();
            this.write(this.outStream, content);
            return this.outBuffer.toByteArray();
        }
        catch (Throwable t) {
            throw new Codec.CodecException("Error encoding content", t);
        }
    }

    @Override
    public byte[] encode(Ontology ontology, AbsContentElement content) throws Codec.CodecException {
        return this.encode(content);
    }

    @Override
    public AbsContentElement decode(byte[] content) throws Codec.CodecException {
        throw new Codec.CodecException("Not supported");
    }

    @Override
    public synchronized AbsContentElement decode(Ontology ontology, byte[] content) throws Codec.CodecException {
        if (content.length == 0) {
            return null;
        }
        try {
            ByteArrayInputStream inpBuffer = new ByteArrayInputStream(content);
            DataInputStream inpStream = new DataInputStream(inpBuffer);
            this.stringReferences.removeAllElements();
            AbsObject obj = this.read(inpStream, ontology);
            inpStream.close();
            return (AbsContentElement)obj;
        }
        catch (Throwable t) {
            throw new Codec.CodecException("Error decoding content", t);
        }
    }

    private void write(DataOutputStream stream, AbsObject abs) throws Throwable {
        if (abs instanceof AbsPrimitive) {
            Object obj = ((AbsPrimitive)abs).getObject();
            if (obj instanceof String) {
                String s = (String)obj;
                if (s.length() >= 65535) {
                    this.writeBigString(stream, (byte)14, s);
                } else {
                    this.writeString(stream, (byte)6, s);
                }
            } else if (obj instanceof Boolean) {
                stream.writeByte(7);
                stream.writeBoolean((Boolean)obj);
            } else if (obj instanceof Integer) {
                stream.writeByte(8);
                stream.writeInt((Integer)obj);
            } else if (obj instanceof Long) {
                stream.writeByte(9);
                stream.writeLong((Long)obj);
            } else if (obj instanceof Float) {
                stream.writeByte(10);
                stream.writeFloat(((Float)obj).floatValue());
            } else if (obj instanceof Double) {
                stream.writeByte(11);
                stream.writeDouble((Double)obj);
            } else if (obj instanceof Date) {
                stream.writeByte(12);
                stream.writeLong(((Date)obj).getTime());
            } else if (obj instanceof byte[]) {
                stream.writeByte(13);
                byte[] b = (byte[])obj;
                stream.writeInt(b.length);
                stream.write(b, 0, b.length);
            }
            return;
        }
        if (abs instanceof AbsAggregate) {
            this.writeString(stream, (byte)1, abs.getTypeName());
            AbsAggregate aggregate = (AbsAggregate)abs;
            for (int i = 0; i < aggregate.size(); ++i) {
                stream.writeByte(4);
                this.write(stream, aggregate.get(i));
            }
            stream.writeByte(5);
            return;
        }
        if (abs instanceof AbsContentElementList) {
            stream.writeByte(2);
            AbsContentElementList acel = (AbsContentElementList)abs;
            for (int i = 0; i < acel.size(); ++i) {
                stream.writeByte(4);
                this.write(stream, acel.get(i));
            }
            stream.writeByte(5);
            return;
        }
        this.writeString(stream, (byte)3, abs.getTypeName());
        String[] names = abs.getNames();
        for (int i = 0; i < abs.getCount(); ++i) {
            this.writeString(stream, (byte)4, names[i]);
            AbsObject child = abs.getAbsObject(names[i]);
            this.write(stream, child);
        }
        stream.writeByte(5);
    }

    private AbsObject read(DataInputStream stream, Ontology ontology) throws Throwable {
        byte type = stream.readByte();
        if ((type & 0xFFFFFFEF) == 6) {
            return AbsPrimitive.wrap(this.readString(stream, type));
        }
        if ((type & 0xFFFFFFEF) == 14) {
            return AbsPrimitive.wrap(this.readBigString(stream, type));
        }
        if (type == 7) {
            boolean value = stream.readBoolean();
            return AbsPrimitive.wrap(value);
        }
        if (type == 8) {
            int value = stream.readInt();
            return AbsPrimitive.wrap(value);
        }
        if (type == 9) {
            long value = stream.readLong();
            return AbsPrimitive.wrap(value);
        }
        if (type == 10) {
            float value = stream.readFloat();
            return AbsPrimitive.wrap(value);
        }
        if (type == 11) {
            double value = stream.readDouble();
            return AbsPrimitive.wrap(value);
        }
        if (type == 12) {
            long value = stream.readLong();
            return AbsPrimitive.wrap(new Date(value));
        }
        if (type == 13) {
            byte[] value = new byte[stream.readInt()];
            stream.read(value, 0, value.length);
            return AbsPrimitive.wrap(value);
        }
        if ((type & 0xFFFFFFEF) == 1) {
            String typeName = this.readString(stream, type);
            AbsAggregate abs = new AbsAggregate(typeName);
            byte marker = stream.readByte();
            do {
                if (marker != 4) continue;
                AbsObject elementValue = this.read(stream, ontology);
                if (elementValue != null) {
                    try {
                        abs.add((AbsTerm)elementValue);
                    }
                    catch (ClassCastException cce) {
                        throw new Codec.CodecException("Non term element in aggregate");
                    }
                }
                marker = stream.readByte();
            } while (marker != 5);
            return abs;
        }
        if (type == 2) {
            AbsContentElementList abs = new AbsContentElementList();
            byte marker = stream.readByte();
            do {
                if (marker != 4) continue;
                AbsObject elementValue = this.read(stream, ontology);
                if (elementValue != null) {
                    try {
                        abs.add((AbsContentElement)elementValue);
                    }
                    catch (ClassCastException cce) {
                        throw new Codec.CodecException("Non content-element element in content-element-list");
                    }
                }
                marker = stream.readByte();
            } while (marker != 5);
            return abs;
        }
        String typeName = this.readString(stream, type);
        ObjectSchema schema = ontology.getSchema(typeName);
        AbsObject abs = schema.newInstance();
        byte marker = stream.readByte();
        do {
            if ((marker & 0xFFFFFFEF) != 4) continue;
            String attributeName = this.readString(stream, marker);
            AbsObject attributeValue = this.read(stream, ontology);
            if (attributeValue != null) {
                AbsHelper.setAttribute(abs, attributeName, attributeValue);
            }
            marker = stream.readByte();
        } while (marker != 5);
        return abs;
    }

    private final void writeString(DataOutputStream stream, byte tag, String s) throws Throwable {
        int index = this.stringReferences.indexOf(s);
        if (index >= 0) {
            stream.writeByte(tag | 0x10);
            stream.writeByte(index);
        } else {
            stream.writeByte(tag);
            stream.writeUTF(s);
            if (s.length() > 1 && this.stringReferences.size() < 256) {
                this.stringReferences.addElement(s);
            }
        }
    }

    private final void writeBigString(DataOutputStream stream, byte tag, String s) throws Throwable {
        int index = this.stringReferences.indexOf(s);
        if (index >= 0) {
            stream.writeByte(tag | 0x10);
            stream.writeByte(index);
        } else {
            stream.writeByte(tag);
            byte[] bytes = s.getBytes();
            stream.writeInt(bytes.length);
            stream.write(bytes, 0, bytes.length);
            if (s.length() > 1 && this.stringReferences.size() < 256) {
                this.stringReferences.addElement(s);
            }
        }
    }

    private final String readString(DataInputStream stream, byte tag) throws Throwable {
        String s = null;
        if ((tag & 0x10) != 0) {
            int index = stream.readUnsignedByte();
            if (index < this.stringReferences.size()) {
                s = (String)this.stringReferences.elementAt(index);
            }
        } else {
            s = stream.readUTF();
            if (s.length() > 1 && this.stringReferences.size() < 256) {
                this.stringReferences.addElement(s);
            }
        }
        return s;
    }

    private final String readBigString(DataInputStream stream, byte tag) throws Throwable {
        String s = null;
        if ((tag & 0x10) != 0) {
            int index = stream.readUnsignedByte();
            if (index < this.stringReferences.size()) {
                s = (String)this.stringReferences.elementAt(index);
            }
        } else {
            byte[] bytes = new byte[stream.readInt()];
            stream.read(bytes, 0, bytes.length);
            s = new String(bytes);
            if (s.length() > 1 && this.stringReferences.size() < 256) {
                this.stringReferences.addElement(s);
            }
        }
        return s;
    }
}

