/*
 * Decompiled with CFR 0.152.
 */
package jade.content.onto;

import jade.content.abs.AbsAggregate;
import jade.content.abs.AbsTerm;
import jade.content.onto.NotAnAggregate;
import jade.content.onto.Ontology;
import jade.content.onto.OntologyException;
import jade.content.onto.ReflectiveIntrospector;
import jade.content.schema.ObjectSchema;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class CFReflectiveIntrospector
extends ReflectiveIntrospector {
    @Override
    public AbsAggregate externalizeAggregate(String slotName, Object obj, ObjectSchema schema, Ontology referenceOnto) throws OntologyException {
        if (!(obj instanceof Collection)) {
            throw new NotAnAggregate();
        }
        AbsAggregate absAggregate = null;
        Collection c = (Collection)obj;
        if (!c.isEmpty() || schema == null || schema.isMandatory(slotName)) {
            String aggregateType = null;
            if (obj instanceof List) {
                aggregateType = "sequence";
            } else if (obj instanceof Set) {
                aggregateType = "set";
            } else {
                throw new NotAnAggregate();
            }
            absAggregate = this.externaliseCollection(c, referenceOnto, aggregateType);
        }
        return absAggregate;
    }

    @Override
    public Object internalizeAggregate(String slotName, AbsAggregate absAggregate, ObjectSchema schema, Ontology referenceOnto) throws OntologyException {
        Collection c = this.internaliseCollection(absAggregate, referenceOnto);
        return c;
    }

    private AbsAggregate externaliseCollection(Collection c, Ontology referenceOnto, String aggregateType) throws OntologyException {
        AbsAggregate ret = new AbsAggregate(aggregateType);
        try {
            Iterator it = c.iterator();
            while (it.hasNext()) {
                ret.add((AbsTerm)Ontology.externalizeSlotValue(it.next(), this, referenceOnto));
            }
        }
        catch (ClassCastException cce) {
            throw new OntologyException("Non term object in aggregate");
        }
        return ret;
    }

    private Collection internaliseCollection(AbsAggregate absAggregate, Ontology referenceOnto) throws OntologyException {
        AbstractCollection ret = null;
        ret = absAggregate.getTypeName().equals("set") ? new HashSet(absAggregate.size()) : new ArrayList(absAggregate.size());
        for (int i = 0; i < absAggregate.size(); ++i) {
            Object element = Ontology.internalizeSlotValue(absAggregate.get(i), this, referenceOnto);
            Ontology.checkIsTerm(element);
            ret.add(element);
        }
        return ret;
    }
}

