/*
 * Decompiled with CFR 0.152.
 */
package jade.content.onto;

import jade.content.abs.AbsAggregate;
import jade.content.abs.AbsObject;
import jade.content.abs.AbsTerm;
import jade.content.onto.BasicOntology;
import jade.content.onto.Introspector;
import jade.content.onto.NotASpecialType;
import jade.content.onto.NotAnAggregate;
import jade.content.onto.Ontology;
import jade.content.onto.OntologyException;
import jade.content.schema.ObjectSchema;
import jade.core.CaseInsensitiveString;
import jade.util.leap.ArrayList;
import jade.util.leap.List;
import java.lang.reflect.Method;

public class ReflectiveIntrospector
implements Introspector {
    @Override
    public Object getSlotValue(String slotName, Object obj, ObjectSchema schema) throws OntologyException {
        String methodName = "get" + this.translateName(slotName);
        Method getMethod = this.findMethodCaseInsensitive(methodName, obj.getClass());
        return this.invokeAccessorMethod(getMethod, obj);
    }

    protected boolean isAggregateObject(Object obj) {
        return obj instanceof List;
    }

    protected Object invokeAccessorMethod(Method method, Object obj) throws OntologyException {
        try {
            return method.invoke(obj, (Object[])null);
        }
        catch (Exception e) {
            throw new OntologyException("Error invoking accessor method " + method.getName() + " on object " + obj, e);
        }
    }

    @Override
    public void setSlotValue(String slotName, Object slotValue, Object obj, ObjectSchema schema) throws OntologyException {
        String methodName = "set" + this.translateName(slotName);
        Method setMethod = this.findMethodCaseInsensitive(methodName, obj.getClass());
        this.invokeSetterMethod(setMethod, obj, slotValue);
    }

    protected void invokeSetterMethod(Method method, Object obj, Object value) throws OntologyException {
        try {
            Object[] params = new Object[]{value};
            try {
                method.invoke(obj, params);
            }
            catch (IllegalArgumentException iae) {
                params[0] = BasicOntology.adjustPrimitiveValue(value, method.getParameterTypes()[0]);
                method.invoke(obj, params);
            }
        }
        catch (Exception e) {
            throw new OntologyException("Error invoking setter method " + method.getName() + " on object " + obj + " with parameter " + value, e);
        }
    }

    @Override
    public void checkClass(ObjectSchema schema, Class javaClass, Ontology onto) throws OntologyException {
    }

    protected Method findMethodCaseInsensitive(String name, Class c) throws OntologyException {
        Method[] methods = c.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            String ithName = methods[i].getName();
            if (!CaseInsensitiveString.equalsIgnoreCase(ithName, name)) continue;
            return methods[i];
        }
        throw new OntologyException("Method " + name + " not found in class " + c.getName());
    }

    protected String translateName(String name) {
        StringBuffer buf = new StringBuffer();
        boolean capitalize = true;
        block4: for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            switch (c) {
                case ':': {
                    continue block4;
                }
                case '-': {
                    capitalize = true;
                    continue block4;
                }
                default: {
                    if (capitalize) {
                        buf.append(Character.toUpperCase(c));
                        capitalize = false;
                        continue block4;
                    }
                    buf.append(c);
                }
            }
        }
        return buf.toString();
    }

    @Override
    public AbsAggregate externalizeAggregate(String slotName, Object obj, ObjectSchema schema, Ontology referenceOnto) throws OntologyException {
        if (!this.isAggregateObject(obj)) {
            throw new NotAnAggregate();
        }
        AbsAggregate absAggregateValue = null;
        List l = (List)obj;
        if (!l.isEmpty() || schema.isMandatory(slotName)) {
            String slotSchemaTypeName = schema.getSchema(slotName).getTypeName();
            absAggregateValue = new AbsAggregate(slotSchemaTypeName);
            try {
                for (int i = 0; i < l.size(); ++i) {
                    absAggregateValue.add((AbsTerm)Ontology.externalizeSlotValue(l.get(i), this, referenceOnto));
                }
            }
            catch (ClassCastException cce) {
                throw new OntologyException("Non term object in aggregate");
            }
        }
        return absAggregateValue;
    }

    @Override
    public Object internalizeAggregate(String slotName, AbsAggregate abs, ObjectSchema schema, Ontology referenceOnto) throws OntologyException {
        ArrayList l = new ArrayList();
        for (int i = 0; i < abs.size(); ++i) {
            Object element = Ontology.internalizeSlotValue(abs.get(i), this, referenceOnto);
            Ontology.checkIsTerm(element);
            l.add(element);
        }
        return l;
    }

    @Override
    public AbsObject externalizeSpecialType(Object obj, ObjectSchema schema, Class javaClass, Ontology referenceOnto) throws OntologyException {
        throw new NotASpecialType();
    }

    @Override
    public Object internalizeSpecialType(AbsObject abs, ObjectSchema schema, Class javaClass, Ontology referenceOnto) throws OntologyException {
        throw new NotASpecialType();
    }
}

