/*
 * Decompiled with CFR 0.152.
 */
package jade.core;

import jade.JadeClassLoader;
import jade.core.Profile;
import jade.core.ResourceManager;

class FullResourceManager
implements ResourceManager {
    public static final String DISABLE_THREAD_GROUP_INTERRUPT = "jade_core_FullResourceManager_disablethreadgroupinterrupt";
    private static final boolean DEFAULT_DISABLE_THREAD_GROUP_INTERRUPT = false;
    public static final String THREAD_GROUP_INTERRUPT_TIMEOUT = "jade_core_FullResourceManager_threadgroupinterrupttimeout";
    private static final String DEFAULT_THREAD_GROUP_INTERRUPT_TIMEOUT = "5000";
    private static final String USER_AGENTS_GROUP_NAME = "JADE User Agents";
    private static final String SYSTEM_AGENTS_GROUP_NAME = "JADE System Agents";
    private static final String CRITICAL_THREADS_GROUP_NAME = "JADE Time-critical Threads";
    private ThreadGroup parent = new ThreadGroup("JADE"){

        @Override
        public void uncaughtException(Thread t, Throwable e) {
            if (!FullResourceManager.this.terminating) {
                super.uncaughtException(t, e);
            }
        }
    };
    private ThreadGroup agentThreads = new ThreadGroup(this.parent, "JADE User Agents");
    private ThreadGroup systemAgentThreads;
    private ThreadGroup criticalThreads;
    private boolean terminating = false;
    private Profile myProfile;
    private boolean disableThreadGroupInterrupt;
    private int threadGroupInterruptTimeout;

    public FullResourceManager() {
        this.agentThreads.setMaxPriority(5);
        this.systemAgentThreads = new ThreadGroup(this.parent, SYSTEM_AGENTS_GROUP_NAME);
        this.systemAgentThreads.setMaxPriority(6);
        this.criticalThreads = new ThreadGroup(this.parent, CRITICAL_THREADS_GROUP_NAME);
        this.criticalThreads.setMaxPriority(10);
    }

    @Override
    public Thread getThread(int type, String name, Runnable r) {
        Thread t = null;
        switch (type) {
            case 0: {
                t = new Thread(this.agentThreads, r);
                t.setPriority(this.agentThreads.getMaxPriority());
                break;
            }
            case 1: {
                t = new Thread(this.systemAgentThreads, r);
                t.setPriority(this.systemAgentThreads.getMaxPriority());
                break;
            }
            case 2: {
                t = new Thread(this.criticalThreads, r);
                t.setPriority(this.criticalThreads.getMaxPriority());
            }
        }
        if (t != null) {
            t.setName(name);
        }
        return t;
    }

    @Override
    public void releaseResources() {
        this.terminating = true;
        if (!this.disableThreadGroupInterrupt) {
            Thread t = new Thread(){

                @Override
                public void run() {
                    try {
                        Thread.sleep(FullResourceManager.this.threadGroupInterruptTimeout);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    if (FullResourceManager.this.parent != null) {
                        FullResourceManager.this.parent.interrupt();
                    }
                    FullResourceManager.this.agentThreads = null;
                    FullResourceManager.this.systemAgentThreads = null;
                    FullResourceManager.this.criticalThreads = null;
                    FullResourceManager.this.parent = null;
                }
            };
            t.start();
        }
    }

    @Override
    public void initialize(Profile p) {
        this.myProfile = p;
        this.disableThreadGroupInterrupt = this.myProfile.getBooleanProperty(DISABLE_THREAD_GROUP_INTERRUPT, false);
        String tmp = this.myProfile.getParameter(THREAD_GROUP_INTERRUPT_TIMEOUT, DEFAULT_THREAD_GROUP_INTERRUPT_TIMEOUT);
        this.threadGroupInterruptTimeout = Integer.parseInt(tmp);
        if (!this.myProfile.getBooleanProperty("no-display", false)) {
            try {
                JadeClassLoader.forName("java.awt.Frame").newInstance();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

