/*
 * Decompiled with CFR 0.152.
 */
package jade.core;

import jade.core.Agent;
import jade.core.FrontEndContainer;
import jade.core.Location;
import jade.wrapper.AgentController;
import jade.wrapper.O2AException;
import jade.wrapper.O2AProxy;
import jade.wrapper.StaleProxyException;
import jade.wrapper.State;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;

class MicroAgentControllerImpl
implements AgentController {
    private String agentName;
    private FrontEndContainer myFrontEnd;

    MicroAgentControllerImpl(String an, FrontEndContainer fec) {
        this.agentName = an;
        this.myFrontEnd = fec;
    }

    @Override
    public String getName() throws StaleProxyException {
        Agent a = this.myFrontEnd.getLocalAgent(this.agentName);
        if (a != null) {
            return a.getName();
        }
        throw new StaleProxyException();
    }

    @Override
    public State getState() throws StaleProxyException {
        return null;
    }

    @Override
    public void start() throws StaleProxyException {
    }

    @Override
    public void kill() throws StaleProxyException {
        try {
            this.myFrontEnd.killAgent(this.agentName);
        }
        catch (Throwable t) {
            throw new StaleProxyException(t);
        }
    }

    @Override
    public void suspend() throws StaleProxyException {
        try {
            this.myFrontEnd.suspendAgent(this.agentName);
        }
        catch (Throwable t) {
            throw new StaleProxyException(t);
        }
    }

    @Override
    public void activate() throws StaleProxyException {
        try {
            this.myFrontEnd.resumeAgent(this.agentName);
        }
        catch (Throwable t) {
            throw new StaleProxyException(t);
        }
    }

    @Override
    public void move(Location where) throws StaleProxyException {
    }

    @Override
    public void clone(Location where, String newName) throws StaleProxyException {
    }

    @Override
    public void putO2AObject(Object o, boolean blocking) throws StaleProxyException {
        Agent adaptee = this.myFrontEnd.getLocalAgent(this.agentName);
        if (adaptee == null) {
            throw new StaleProxyException();
        }
        try {
            adaptee.putO2AObject(o, blocking);
        }
        catch (InterruptedException ace) {
            throw new StaleProxyException(ace);
        }
    }

    @Override
    public <T> T getO2AInterface(Class<T> theInterface) throws StaleProxyException {
        Agent adaptee = this.myFrontEnd.getLocalAgent(this.agentName);
        if (adaptee == null) {
            throw new StaleProxyException("Controlled agent does not exist");
        }
        T o2aInterfaceImpl = adaptee.getO2AInterface(theInterface);
        if (o2aInterfaceImpl == null) {
            return null;
        }
        ClassLoader classLoader = o2aInterfaceImpl.getClass().getClassLoader();
        return (T)Proxy.newProxyInstance(classLoader, new Class[]{theInterface}, (InvocationHandler)new O2AProxy(o2aInterfaceImpl){

            @Override
            protected void checkAgent() throws O2AException {
                if (MicroAgentControllerImpl.this.myFrontEnd.getLocalAgent(MicroAgentControllerImpl.this.agentName) == null) {
                    throw new O2AException("Controlled agent does not exist");
                }
            }
        });
    }
}

