/*
 * Decompiled with CFR 0.152.
 */
package jade.core;

import jade.util.Logger;
import java.io.InputStream;
import java.util.jar.Attributes;
import java.util.jar.Manifest;

public class VersionManager {
    private static Logger logger = Logger.getMyLogger(VersionManager.class.getName());
    private static final String GROUP = "Jade Informations";
    private static final String WCVER = "Specification-Version";
    private static final String WCREV = "SVN-Revision";
    private static final String WCDATE = "SVN-Date";
    private boolean isVersionFromOSGIBundle = this.loadVersionInfoFromSOGIBundle();
    private static final String BUNDLE_SYMBOLIC_NAME = "Bundle-SymbolicName";
    private static final String BUNDLE_VERSION = "Bundle-Version";
    private static final String BUNDLE_DATE = "Bundle-Date";
    private static final String BUNDLE_VENDOR = "Bundle-Vendor";
    private Attributes attributes;

    public VersionManager() {
        if (!this.isVersionFromOSGIBundle) {
            this.loadVersionInfoFromJar();
        }
    }

    private boolean loadVersionInfoFromSOGIBundle() {
        try {
            Manifest manifest = this.getManifest();
            this.attributes = manifest.getMainAttributes();
            return true;
        }
        catch (Exception e) {
            logger.log(Logger.WARNING, "Error retrieving version information", e);
            return false;
        }
    }

    private boolean loadVersionInfoFromJar() {
        try {
            String classPath = this.getClassPath();
            if (!classPath.startsWith("jar")) {
                logger.log(Logger.WARNING, "VersionManager not from jar -> no version information available");
                return false;
            }
            Manifest manifest = this.getManifest();
            this.attributes = manifest.getAttributes(GROUP);
            return true;
        }
        catch (Exception e) {
            logger.log(Logger.WARNING, "Error retrieving versions info", e);
            return false;
        }
    }

    private String getClassPath() {
        Class<?> clazz = this.getClass();
        String className = clazz.getSimpleName() + ".class";
        return clazz.getResource(className).toString();
    }

    private Manifest getManifest() {
        Manifest manifest = null;
        try {
            InputStream is = this.getClass().getResourceAsStream("/META-INF/MANIFEST.MF");
            manifest = new Manifest(is);
            is.close();
        }
        catch (Exception e) {
            logger.log(Logger.WARNING, "Error retrieving versions info", e);
        }
        return manifest;
    }

    public String getVersion() {
        if (this.attributes != null) {
            if (this.isVersionFromOSGIBundle) {
                return this.attributes.getValue(BUNDLE_VERSION);
            }
            return this.attributes.getValue(WCVER);
        }
        return "UNKNOWN";
    }

    public String getRevision() {
        if (this.attributes != null) {
            if (this.isVersionFromOSGIBundle) {
                return null;
            }
            return this.attributes.getValue(WCREV);
        }
        return "UNKNOWN";
    }

    public String getDate() {
        if (this.attributes != null) {
            if (this.isVersionFromOSGIBundle) {
                return this.attributes.getValue(BUNDLE_DATE);
            }
            return this.attributes.getValue(WCDATE);
        }
        return "UNKNOWN";
    }

    public String getBundleName() {
        if (this.attributes != null && this.isVersionFromOSGIBundle) {
            return this.attributes.getValue(BUNDLE_SYMBOLIC_NAME);
        }
        return "UNKNOWN";
    }

    public String getBundleVendor() {
        if (this.attributes != null && this.isVersionFromOSGIBundle) {
            return this.attributes.getValue(BUNDLE_VENDOR);
        }
        return "UNKNOWN";
    }
}

