/*
 * Decompiled with CFR 0.152.
 */
package jade.core.behaviours;

import jade.core.Agent;
import jade.core.behaviours.SimpleBehaviour;
import java.util.Date;

public abstract class WakerBehaviour
extends SimpleBehaviour {
    private long wakeupTime;
    private long blockTime;
    private long timeout;
    private int state;
    private boolean finished;

    public WakerBehaviour(Agent a, Date wakeupDate) {
        super(a);
        this.timeout = 0L;
        this.wakeupTime = wakeupDate.getTime();
        this.state = 0;
        this.finished = false;
    }

    public WakerBehaviour(Agent a, long timeout) {
        super(a);
        this.wakeupTime = -1L;
        this.timeout = timeout;
        this.state = 0;
        this.finished = false;
    }

    @Override
    public final void action() {
        if (!this.finished) {
            switch (this.state) {
                case 0: {
                    if (this.wakeupTime == -1L) {
                        this.wakeupTime = System.currentTimeMillis() + this.timeout;
                    }
                    this.blockTime = this.wakeupTime - System.currentTimeMillis();
                    if (this.blockTime > 0L) {
                        this.block(this.blockTime);
                    }
                    ++this.state;
                    break;
                }
                case 1: {
                    this.blockTime = this.wakeupTime - System.currentTimeMillis();
                    if (this.blockTime <= 0L) {
                        this.finished = true;
                        this.onWake();
                        break;
                    }
                    this.block(this.blockTime);
                    break;
                }
                default: {
                    this.state = 0;
                }
            }
        }
    }

    protected void onWake() {
        this.handleElapsedTimeout();
    }

    protected void handleElapsedTimeout() {
    }

    public void reset(Date wakeupDate) {
        this.reset();
        this.wakeupTime = wakeupDate.getTime();
    }

    public void reset(long timeout) {
        this.reset();
        this.timeout = timeout;
    }

    @Override
    public void reset() {
        super.reset();
        this.wakeupTime = -1L;
        this.state = 0;
        this.finished = false;
    }

    public void stop() {
        this.finished = true;
        this.restart();
    }

    @Override
    public final boolean done() {
        return this.finished;
    }

    public final long getWakeupTime() {
        return this.wakeupTime;
    }
}

