/*
 * Decompiled with CFR 0.152.
 */
package jade.core.messaging;

import jade.core.AID;
import jade.core.messaging.GenericMessage;
import jade.core.messaging.MessageManager;
import jade.core.messaging.MultipleGenericMessage;
import jade.core.messaging.QueueFullException;
import jade.core.messaging.StuckDeliverer;
import jade.lang.acl.ACLMessage;
import jade.util.Logger;
import jade.util.leap.HashMap;
import jade.util.leap.LinkedList;
import jade.util.leap.List;
import jade.util.leap.Map;
import jade.util.leap.RoundList;
import java.util.ArrayList;

class OutBox {
    private static final int PENDING_MSG_PER_RECEIVER_THR = -1;
    private int size = 0;
    private int pendingCnt = 0;
    private int warningSize;
    private int maxSize;
    private int sleepTimeFactor;
    private boolean enableMultipleDelivery;
    private boolean overWarningSize = false;
    private MessageManager manager;
    private long lastDiscardedLogTime = -1L;
    private long discardedSinceLastLogCnt = 0L;
    private long servedSinceLastDiscardedLogCnt = -1L;
    private final Map messagesByReceiver = new HashMap();
    private final RoundList messagesByOrder = new RoundList();
    private Logger myLogger;

    OutBox(int warningSize, int maxSize, int sleepTimeFactor, boolean enableMultipleDelivery, MessageManager manager) {
        this.warningSize = warningSize;
        this.maxSize = maxSize;
        this.sleepTimeFactor = sleepTimeFactor;
        this.enableMultipleDelivery = enableMultipleDelivery;
        this.manager = manager;
        this.myLogger = Logger.getMyLogger(this.getClass().getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addLast(AID receiverID, GenericMessage msg, MessageManager.Channel ch) {
        ACLMessage acl;
        if (this.size + msg.length() > this.maxSize) {
            long time = System.currentTimeMillis();
            OutBox outBox = this;
            synchronized (outBox) {
                if (time - this.lastDiscardedLogTime > 1000L) {
                    String servedWhileDiscardingStr = this.servedSinceLastDiscardedLogCnt >= 0L ? " (" + this.servedSinceLastDiscardedLogCnt + " messages served since last discard-log)" : "";
                    this.myLogger.log(Logger.SEVERE, String.valueOf(this.discardedSinceLastLogCnt + 1L) + " message(s) discarded by MessageManager! Current-queue-size = " + this.size + ", max-size = " + this.maxSize + ", number of pending messages = " + this.pendingCnt + ", size of last message = " + msg.length() + servedWhileDiscardingStr);
                    this.lastDiscardedLogTime = time;
                    this.discardedSinceLastLogCnt = 0L;
                    this.servedSinceLastDiscardedLogCnt = 0L;
                } else {
                    ++this.discardedSinceLastLogCnt;
                }
            }
            throw new QueueFullException();
        }
        boolean logActivated = this.myLogger.isLoggable(Logger.FINER);
        if (logActivated) {
            this.myLogger.log(Logger.FINER, "Entering addLast for receiver " + receiverID.getName());
        }
        if (msg.getPayload() != null && msg.isModifiable() && (acl = msg.getACLMessage()) != null) {
            acl.setContent(null);
        }
        int length = msg.length();
        this.increaseSize(length);
        OutBox outBox = this;
        synchronized (outBox) {
            String owner;
            Box b = (Box)this.messagesByReceiver.get(receiverID);
            if (logActivated) {
                String msgDebug = b == null ? "No box for receiver " + receiverID.getName() : "Box for receiver " + receiverID.getName() + " busy ?  " + b.isBusy();
                this.myLogger.log(Logger.FINER, msgDebug);
            }
            if (b == null) {
                b = new Box(receiverID);
                this.messagesByReceiver.put(receiverID, b);
                this.messagesByOrder.add(b);
                if (logActivated) {
                    this.myLogger.log(Logger.FINER, "Box created for receiver " + receiverID.getName());
                }
            }
            if (b.size() > -1 && this.manager.isStuck(owner = b.getOwner())) {
                this.decreaseSize(length);
                throw new StuckDeliverer(owner);
            }
            if (logActivated) {
                this.myLogger.log(Logger.FINER, "Message entered in box for receiver " + receiverID.getName());
            }
            b.addLast(new MessageManager.PendingMsg(msg, receiverID, ch, -1L));
            this.notifyAll();
        }
        if (logActivated) {
            this.myLogger.log(Logger.FINER, "Exiting addLast for receiver " + receiverID.getName());
        }
    }

    final synchronized MessageManager.PendingMsg get() {
        Box b = null;
        while ((b = this.getNextIdle()) == null) {
            try {
                if (this.myLogger.isLoggable(Logger.FINER)) {
                    this.myLogger.log(Logger.FINER, "Deliverer " + Thread.currentThread() + " go to sleep...");
                }
                this.wait();
                if (!this.myLogger.isLoggable(Logger.FINER)) continue;
                this.myLogger.log(Logger.FINER, "Deliverer " + Thread.currentThread() + " wake up");
            }
            catch (InterruptedException interruptedException) {}
        }
        MessageManager.PendingMsg pm = b.removeFirst();
        int s = pm.getMessage().length();
        this.decreaseSize(s);
        if ((b.size() >= 3 || this.size > this.warningSize) && this.enableMultipleDelivery) {
            int mulMessageSize;
            ArrayList<GenericMessage> mm = null;
            for (mulMessageSize = s; !b.isEmpty() && mulMessageSize < 100000; mulMessageSize += s) {
                if (mm == null) {
                    mm = new ArrayList<GenericMessage>();
                    mm.add(pm.getMessage());
                }
                MessageManager.PendingMsg next = b.removeFirst();
                GenericMessage g = next.getMessage();
                s = g.length();
                this.decreaseSize(s);
                mm.add(g);
            }
            if (mm != null) {
                MultipleGenericMessage mgm = new MultipleGenericMessage(mulMessageSize);
                mgm.setMessages(mm);
                pm.setMessage(mgm);
            }
        }
        return pm;
    }

    private final Box getNextIdle() {
        for (int i = 0; i < this.messagesByOrder.size(); ++i) {
            Box b = (Box)this.messagesByOrder.get();
            if (b.isBusy()) continue;
            b.setBusy(true);
            if (this.myLogger.isLoggable(Logger.FINER)) {
                this.myLogger.log(Logger.FINER, "Setting box busy for receiver " + b.getReceiver().getName());
            }
            return b;
        }
        return null;
    }

    final synchronized void handleServed(AID receiverID, int n) {
        Box b;
        boolean logActivated;
        if (this.servedSinceLastDiscardedLogCnt >= 0L) {
            this.servedSinceLastDiscardedLogCnt += (long)n;
        }
        if (logActivated = this.myLogger.isLoggable(Logger.FINER)) {
            this.myLogger.log(Logger.FINER, "Entering handleServed for " + receiverID.getName());
        }
        if ((b = (Box)this.messagesByReceiver.get(receiverID)).isEmpty()) {
            this.messagesByReceiver.remove(receiverID);
            this.messagesByOrder.remove(b);
            if (logActivated) {
                this.myLogger.log(Logger.FINER, "Removed box for receiver " + receiverID.getName());
            }
        } else {
            b.setBusy(false);
            if (logActivated) {
                this.myLogger.log(Logger.FINER, "Freeing box for receiver " + receiverID.getName());
            }
        }
        if (logActivated) {
            this.myLogger.log(Logger.FINER, "Exiting handleServed for " + receiverID.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void increaseSize(int lastMessageSize) {
        long sleepTime = 0L;
        OutBox outBox = this;
        synchronized (outBox) {
            ++this.pendingCnt;
            this.size += lastMessageSize;
            if (this.size > this.warningSize) {
                if (!this.overWarningSize) {
                    this.myLogger.log(Logger.WARNING, "MessageManager queue size (" + this.size + ") > " + this.warningSize + ". Number of pending messages = " + this.pendingCnt + ", size of last message = " + lastMessageSize);
                    this.overWarningSize = true;
                }
                if (this.sleepTimeFactor > 0) {
                    sleepTime = (1 + (this.size - this.warningSize) / 1000000) * this.sleepTimeFactor;
                }
            }
        }
        if (sleepTime > 0L) {
            try {
                Thread.sleep(sleepTime);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private void decreaseSize(int k) {
        --this.pendingCnt;
        this.size -= k;
        if (this.size < this.warningSize && this.overWarningSize) {
            this.myLogger.log(Logger.INFO, "MessageManager queue size < " + this.warningSize);
            this.overWarningSize = false;
        }
    }

    synchronized String[] getStatus() {
        Object[] boxes = this.messagesByOrder.toArray();
        String[] status = new String[boxes.length];
        for (int i = 0; i < boxes.length; ++i) {
            status[i] = boxes[i].toString();
        }
        return status;
    }

    int getSize() {
        return this.size;
    }

    int getPendingCnt() {
        return this.pendingCnt;
    }

    private class Box {
        private final AID receiver;
        private boolean busy;
        private String owner;
        private final List messages;

        public Box(AID r) {
            this.receiver = r;
            this.busy = false;
            this.messages = new LinkedList();
        }

        private AID getReceiver() {
            return this.receiver;
        }

        private void setBusy(boolean b) {
            this.busy = b;
            this.owner = this.busy ? Thread.currentThread().getName() : null;
        }

        private boolean isBusy() {
            return this.busy;
        }

        private String getOwner() {
            return this.owner;
        }

        private void addLast(MessageManager.PendingMsg pm) {
            this.messages.add(pm);
        }

        private MessageManager.PendingMsg removeFirst() {
            return (MessageManager.PendingMsg)this.messages.remove(0);
        }

        private boolean isEmpty() {
            return this.messages.isEmpty();
        }

        private int size() {
            return this.messages.size();
        }

        public String toString() {
            return "(" + this.receiver.getName() + " :busy " + this.busy + (this.owner != null ? " :owner " + this.owner : "") + " :message-cnt " + this.messages.size() + ")";
        }
    }
}

