/*
 * Decompiled with CFR 0.152.
 */
package jade.core.sam;

import jade.core.Service;
import jade.core.ServiceException;
import jade.core.Timer;
import jade.core.TimerDispatcher;
import jade.core.TimerListener;
import jade.core.sam.SAMInfo;
import jade.core.sam.SAMInfoHandler;
import jade.core.sam.SAMService;
import jade.core.sam.SAMSlice;
import jade.util.Logger;
import java.util.Date;

class Poller
extends Thread {
    private SAMService myService;
    private volatile SAMInfoHandler[] handlers;
    private long period;
    private boolean active;
    private Timer watchDogTimer = null;
    private Logger myLogger = Logger.getMyLogger(this.getClass().getName());

    Poller(SAMService service, long p, SAMInfoHandler[] hh) {
        this.myService = service;
        this.period = p;
        this.handlers = hh;
        this.setName("SAMService-Poller");
    }

    public synchronized void startPolling() {
        this.active = true;
        this.start();
    }

    public synchronized void stopPolling() {
        this.active = false;
        this.interrupt();
    }

    public synchronized void addHandler(SAMInfoHandler h, boolean first) {
        SAMInfoHandler[] newHandlers = new SAMInfoHandler[this.handlers.length + 1];
        int k = 0;
        if (first) {
            newHandlers[0] = h;
            k = 1;
        }
        for (int i = 0; i < this.handlers.length; ++i) {
            newHandlers[k + i] = this.handlers[i];
        }
        if (!first) {
            newHandlers[this.handlers.length] = h;
        }
        this.handlers = newHandlers;
    }

    public synchronized void removeHandler(SAMInfoHandler handler) {
        boolean found = false;
        for (SAMInfoHandler h : this.handlers) {
            if (h != handler) continue;
            found = true;
            break;
        }
        if (found) {
            SAMInfoHandler[] newHandlers = new SAMInfoHandler[this.handlers.length - 1];
            int k = 0;
            for (int i = 0; i < this.handlers.length; ++i) {
                if (this.handlers[i] == handler) continue;
                newHandlers[k++] = this.handlers[i];
            }
            this.handlers = newHandlers;
        }
    }

    @Override
    public void run() {
        block4: {
            this.myLogger.log(Logger.INFO, "SAMService poller thread started");
            try {
                while (this.active) {
                    Thread.sleep(this.period);
                    this.poll();
                }
            }
            catch (InterruptedException ie) {
                if (!this.active) break block4;
                this.myLogger.log(Logger.WARNING, "SAMService poller thread unexpectedly interrupted");
            }
        }
        for (SAMInfoHandler h : this.handlers) {
            h.shutdown();
        }
        this.myLogger.log(Logger.CONFIG, "SAMService poller thread terminated");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void poll() {
        this.myLogger.log(Logger.FINE, "SAMService poller - Retrieving SAM information from all nodes");
        Date timeStamp = new Date();
        SAMInfo globalInfo = new SAMInfo();
        try {
            Service.Slice[] slices = this.myService.getAllSlices();
            for (int i = 0; i < slices.length; ++i) {
                SAMSlice s = (SAMSlice)slices[i];
                String nodeName = s.getNode().getName();
                this.startWatchDog(Thread.currentThread(), nodeName);
                try {
                    if (this.myLogger.isLoggable(Logger.FINER)) {
                        this.myLogger.log(Logger.FINER, "SAMService poller - Retrieving SAM information from node " + nodeName);
                    }
                    SAMInfo sliceInfo = s.getSAMInfo();
                    globalInfo.update(sliceInfo);
                    if (!this.myLogger.isLoggable(Logger.FINEST)) continue;
                    this.myLogger.log(Logger.FINEST, "SAMService poller - SAM information successfully retrieved from node " + nodeName);
                    continue;
                }
                catch (Exception imtpe) {
                    this.myLogger.log(Logger.WARNING, "SAMService poller - Error retrieving SAM information from node " + nodeName, imtpe);
                    continue;
                }
                finally {
                    this.stopWatchDog();
                }
            }
            globalInfo.computeAggregatedValues();
            for (SAMInfoHandler h : this.handlers) {
                try {
                    h.handle(timeStamp, globalInfo);
                }
                catch (Exception e) {
                    this.myLogger.log(Logger.WARNING, "SAMService poller - Error processing info by handler " + h, e);
                }
            }
        }
        catch (ServiceException se) {
            this.myLogger.log(Logger.WARNING, "SAMService poller - Error retrieving SAM slices", se);
        }
        catch (Exception e) {
            this.myLogger.log(Logger.WARNING, "SAMService poller - Unexpected error polling SAM information", e);
        }
    }

    private synchronized void startWatchDog(final Thread thread, final String nodeName) {
        this.watchDogTimer = TimerDispatcher.getTimerDispatcher().add(new Timer(System.currentTimeMillis() + 10000L, new TimerListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void doTimeOut(Timer t) {
                Poller poller = Poller.this;
                synchronized (poller) {
                    if (t == Poller.this.watchDogTimer) {
                        Poller.this.myLogger.log(Logger.WARNING, "SAMService - WatchDog timer expired while retrieving SAM information from node " + nodeName);
                        thread.interrupt();
                        Poller.this.myLogger.log(Logger.WARNING, "SAMService - Poller Thread interrupted!!!");
                    }
                }
            }
        }));
    }

    private synchronized void stopWatchDog() {
        if (this.watchDogTimer != null) {
            TimerDispatcher.getTimerDispatcher().remove(this.watchDogTimer);
            this.watchDogTimer = null;
        }
        Thread.interrupted();
    }
}

