/*
 * Decompiled with CFR 0.152.
 */
package jade.domain;

import jade.core.Agent;
import jade.domain.DFService;
import jade.domain.FIPAAgentManagement.DFAgentDescription;
import jade.lang.acl.ACLMessage;
import jade.proto.SubscriptionInitiator;
import jade.util.Logger;
import jade.util.leap.Iterator;

public abstract class DFSubscriber
extends SubscriptionInitiator {
    private static final long serialVersionUID = -5741304962740821073L;
    private static final Logger logger = Logger.getJADELogger(DFSubscriber.class.getName());
    private boolean firstNotificationReceived = false;

    public DFSubscriber(Agent a, DFAgentDescription template) {
        super(a, DFService.createSubscriptionMessage(a, a.getDefaultDF(), template, null));
    }

    public abstract void onRegister(DFAgentDescription var1);

    public abstract void onDeregister(DFAgentDescription var1);

    public void afterFirstNotification(DFAgentDescription[] dfds) {
    }

    @Override
    protected void handleInform(ACLMessage inform) {
        try {
            DFAgentDescription[] dfds = DFService.decodeNotification(inform.getContent());
            for (int i = 0; i < dfds.length; ++i) {
                DFAgentDescription dfad = dfds[i];
                Iterator services = dfad.getAllServices();
                if (services.hasNext()) {
                    this.onRegister(dfad);
                    continue;
                }
                this.onDeregister(dfad);
            }
            if (!this.firstNotificationReceived) {
                this.firstNotificationReceived = true;
                this.afterFirstNotification(dfds);
            }
        }
        catch (Exception e) {
            logger.log(Logger.SEVERE, "Agent " + this.myAgent.getName() + ": Error decoding DF notification", e);
        }
    }
}

